# t20002 - Free function sequence diagram test case
## Config
```yaml
diagrams:
  t20002_sequence:
    type: sequence
    glob:
      - t20002.cc
    include:
      namespaces:
        - clanguml::t20002
    using_namespace: clanguml::t20002
    from:
      - function: "clanguml::t20002::m1()"

```
## Source code
File `tests/t20002/t20002.cc`
```cpp
namespace clanguml {
namespace t20002 {

void m4() { }

void m3() { m4(); }

void m2() { m3(); }

void m1() { m2(); }
}
}

```
## Generated PlantUML diagrams
![t20002_sequence](./t20002_sequence.svg "Free function sequence diagram test case")
## Generated Mermaid diagrams
![t20002_sequence](./t20002_sequence_mermaid.svg "Free function sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20002_sequence",
  "participants": [
    {
      "display_name": "m1()",
      "full_name": "clanguml::t20002::m1()",
      "id": "12955371434168513235",
      "name": "m1",
      "namespace": "clanguml::t20002",
      "source_location": {
        "column": 6,
        "file": "t20002.cc",
        "line": 10,
        "translation_unit": "t20002.cc"
      },
      "type": "function"
    },
    {
      "display_name": "m2()",
      "full_name": "clanguml::t20002::m2()",
      "id": "12601921857248901395",
      "name": "m2",
      "namespace": "clanguml::t20002",
      "source_location": {
        "column": 6,
        "file": "t20002.cc",
        "line": 8,
        "translation_unit": "t20002.cc"
      },
      "type": "function"
    },
    {
      "display_name": "m3()",
      "full_name": "clanguml::t20002::m3()",
      "id": "14710473408713676641",
      "name": "m3",
      "namespace": "clanguml::t20002",
      "source_location": {
        "column": 6,
        "file": "t20002.cc",
        "line": 6,
        "translation_unit": "t20002.cc"
      },
      "type": "function"
    },
    {
      "display_name": "m4()",
      "full_name": "clanguml::t20002::m4()",
      "id": "509720501689748277",
      "name": "m4",
      "namespace": "clanguml::t20002",
      "source_location": {
        "column": 6,
        "file": "t20002.cc",
        "line": 4,
        "translation_unit": "t20002.cc"
      },
      "type": "function"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "12955371434168513235",
            "participant_id": "12955371434168513235"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 13,
            "file": "t20002.cc",
            "line": 10,
            "translation_unit": "t20002.cc"
          },
          "to": {
            "activity_id": "12601921857248901395",
            "participant_id": "12601921857248901395"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "12601921857248901395",
            "participant_id": "12601921857248901395"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 13,
            "file": "t20002.cc",
            "line": 8,
            "translation_unit": "t20002.cc"
          },
          "to": {
            "activity_id": "14710473408713676641",
            "participant_id": "14710473408713676641"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14710473408713676641",
            "participant_id": "14710473408713676641"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 13,
            "file": "t20002.cc",
            "line": 6,
            "translation_unit": "t20002.cc"
          },
          "to": {
            "activity_id": "509720501689748277",
            "participant_id": "509720501689748277"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "12955371434168513235",
        "location": "clanguml::t20002::m1()"
      }
    }
  ],
  "using_namespace": "clanguml::t20002"
}
```
## Generated GraphML models
