# t00088 - Typed element Objective-C class diagram filter test case
## Config
```yaml
diagrams:
  t00088_class:
    type: class
    glob:
      - t00088.m
    include:
      paths:
        - .
      elements:
        - type: objc_interface
          name: It00088_Foo
    exclude:
      elements:
        - type: objc_method
          name:
            r: 'It00088_Foo::bar.*'
        - type: objc_method
          name: 'It00088_Foo::baz:with:'
        - type: objc_member
          name: 'It00088_Foo::_barMember'
        - type: objc_protocol
          name: Pr00088
```
## Source code
File `tests/t00088/t00088.h`
```cpp
#import <Foundation/Foundation.h>

struct It00088_Foo { };

@protocol Pr00088

@end

@interface It00088_Foo : NSObject {
    int _fooMember;
    int _barMember;
}

+ (void)foo;
+ (void)bar;
+ (void)baz:(int)b with:(int)c;

@end

@interface It00088_Bar : NSObject {
}

@end
```
File `tests/t00088/t00088.m`
```cpp
#include "t00088.h"

@implementation It00088_Foo

+ (void)foo
{
}

+ (void)bar
{
}

+ (void)baz:(int)b with:(int)c
{
}
@end
```
## Generated PlantUML diagrams
![t00088_class](./t00088_class.svg "Typed element Objective-C class diagram filter test case")
## Generated Mermaid diagrams
![t00088_class](./t00088_class_mermaid.svg "Typed element Objective-C class diagram filter test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [
        {
          "id": "13825978819641664869"
        }
      ],
      "display_name": "It00088_Foo",
      "id": "13875468327584959141",
      "is_category": false,
      "is_protocol": false,
      "members": [
        {
          "access": "protected",
          "name": "_fooMember",
          "source_location": {
            "column": 9,
            "file": "t00088.h",
            "line": 10,
            "translation_unit": "t00088.m"
          },
          "type": "int"
        },
        {
          "access": "protected",
          "name": "_barMember",
          "source_location": {
            "column": 9,
            "file": "t00088.h",
            "line": 11,
            "translation_unit": "t00088.m"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_optional": false,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 1,
            "file": "t00088.h",
            "line": 14,
            "translation_unit": "t00088.m"
          },
          "type": "void"
        }
      ],
      "name": "It00088_Foo",
      "namespace": "",
      "protocols": [],
      "source_location": {
        "column": 12,
        "file": "t00088.h",
        "line": 9,
        "translation_unit": "t00088.m"
      },
      "type": "objc_interface"
    }
  ],
  "name": "t00088_class",
  "package_type": "namespace",
  "relationships": []
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <node id="n0">
   <data key="nd1">objc_interface</data>
   <data key="nd2">It00088_Foo</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00088/t00088.h#L9</data>
   <data key="nd5">It00088_Foo</data>
  </node>
 </graph>
</graphml>

```
