# t00074 - Test case for rendering concepts without requirements
## Config
```yaml
diagrams:
  t00074_class:
    type: class
    glob:
      - t00074.cc
    generate_concept_requirements: false
    include:
      namespaces:
        - clanguml::t00074
    using_namespace: clanguml::t00074
```
## Source code
File `tests/t00074/t00074.cc`
```cpp
namespace clanguml {
namespace t00074 {
template <typename T>
concept fruit_c = requires(T t) {
    T{};
    t.get_name();
};

template <typename T>
concept apple_c = fruit_c<T> && requires(T t) { t.get_sweetness(); };

template <typename T>
concept orange_c = fruit_c<T> && requires(T t) { t.get_bitterness(); };

}
}
```
## Generated PlantUML diagrams
![t00074_class](./t00074_class.svg "Test case for rendering concepts without requirements")
## Generated Mermaid diagrams
![t00074_class](./t00074_class_mermaid.svg "Test case for rendering concepts without requirements")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "display_name": "fruit_c<T>",
      "id": "3888955019157142299",
      "name": "fruit_c",
      "namespace": "clanguml::t00074",
      "parameters": [
        {
          "name": "t",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00074.cc",
        "line": 4,
        "translation_unit": "t00074.cc"
      },
      "statements": [
        "T{}",
        "t.get_name()"
      ],
      "type": "concept"
    },
    {
      "display_name": "apple_c<T>",
      "id": "4482028329158094097",
      "name": "apple_c",
      "namespace": "clanguml::t00074",
      "parameters": [
        {
          "name": "t",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00074.cc",
        "line": 10,
        "translation_unit": "t00074.cc"
      },
      "statements": [
        "t.get_sweetness()"
      ],
      "type": "concept"
    },
    {
      "display_name": "orange_c<T>",
      "id": "8476723110668827646",
      "name": "orange_c",
      "namespace": "clanguml::t00074",
      "parameters": [
        {
          "name": "t",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00074.cc",
        "line": 13,
        "translation_unit": "t00074.cc"
      },
      "statements": [
        "t.get_bitterness()"
      ],
      "type": "concept"
    }
  ],
  "name": "t00074_class",
  "package_type": "namespace",
  "relationships": [
    {
      "destination": "3888955019157142299",
      "label": "T",
      "source": "4482028329158094097",
      "type": "constraint"
    },
    {
      "destination": "3888955019157142299",
      "label": "T",
      "source": "8476723110668827646",
      "type": "constraint"
    }
  ],
  "using_namespace": "clanguml::t00074"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00074</data>
  <node id="n0">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[fruit_c<T>]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00074/t00074.cc#L4</data>
   <data key="nd5">fruit_c</data>
  </node>
  <node id="n1">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[apple_c<T>]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00074/t00074.cc#L10</data>
   <data key="nd5">apple_c</data>
  </node>
  <node id="n2">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[orange_c<T>]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00074/t00074.cc#L13</data>
   <data key="nd5">orange_c</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e1" source="n2" target="n0">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
 </graph>
</graphml>

```
