# t00072 - Class diagram with C++20 module partitions generated as packages
## Config
```yaml
diagrams:
  t00072_class:
    type: class
    glob:
      - t00072.cc
    generate_packages: true
    package_type: module
    include:
      modules:
        - t00072
    using_module: t00072
    using_namespace: clanguml::t00072
```
## Source code
File `tests/t00072/t00072.cc`
```cpp
import t00072.app;

namespace clanguml {
namespace t00072 {
}
}
```
File `tests/t00072/src/lib1mod2.cppm`
```cpp
export module t00072.app:lib1.mod2;

export namespace clanguml::t00072 {
class E { };
}
```
File `tests/t00072/src/t00072_mod.cppm`
```cpp
export module t00072.app;
export import :lib1;
export import :lib1.mod1;
export import :lib1.mod2;
export import :lib2;

export namespace clanguml::t00072 {
class A {
    int get() { return a; }

    int a;
};
}
```
File `tests/t00072/src/lib2.cppm`
```cpp
export module t00072.app:lib2;

export namespace clanguml::t00072 {
class C { };

template <typename T> class CC {
    T t;
};

namespace detail {
enum class CCC { ccc1, ccc2 };
}
}
```
File `tests/t00072/src/lib1.cppm`
```cpp
export module t00072.app:lib1;

export namespace clanguml::t00072 {
class B { };

template <typename T> class BB {
    T t;
};

namespace detail {
enum class BBB { bbb1, bbb2 };
} // namespace detail
}
```
File `tests/t00072/src/lib1mod1.cppm`
```cpp
export module t00072.app:lib1.mod1;

export namespace clanguml::t00072 {
class D { };
}
```
## Generated PlantUML diagrams
![t00072_class](./t00072_class.svg "Class diagram with C++20 module partitions generated as packages")
## Generated Mermaid diagrams
![t00072_class](./t00072_class_mermaid.svg "Class diagram with C++20 module partitions generated as packages")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "display_name": "app",
      "elements": [
        {
          "display_name": ":lib1",
          "elements": [
            {
              "bases": [],
              "display_name": "B",
              "id": "11601203371562062198",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "module": {
                "is_private": false,
                "name": "t00072.app:lib1"
              },
              "name": "B",
              "namespace": "clanguml::t00072",
              "source_location": {
                "column": 7,
                "file": "src/lib1.cppm",
                "line": 4,
                "translation_unit": "t00072.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "BB<T>",
              "id": "5959403768066984874",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": true,
              "is_union": false,
              "members": [
                {
                  "access": "private",
                  "is_static": false,
                  "name": "t",
                  "source_location": {
                    "column": 7,
                    "file": "src/lib1.cppm",
                    "line": 7,
                    "translation_unit": "t00072.cc"
                  },
                  "type": "T"
                }
              ],
              "methods": [],
              "module": {
                "is_private": false,
                "name": "t00072.app:lib1"
              },
              "name": "BB",
              "namespace": "clanguml::t00072",
              "source_location": {
                "column": 29,
                "file": "src/lib1.cppm",
                "line": 6,
                "translation_unit": "t00072.cc"
              },
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "template_type",
                  "name": "T",
                  "template_parameters": []
                }
              ],
              "type": "class"
            },
            {
              "constants": [
                "bbb1",
                "bbb2"
              ],
              "display_name": "BBB",
              "id": "4882347220944948110",
              "is_nested": false,
              "module": {
                "is_private": false,
                "name": "t00072.app:lib1"
              },
              "name": "BBB",
              "namespace": "clanguml::t00072::detail",
              "source_location": {
                "column": 12,
                "file": "src/lib1.cppm",
                "line": 11,
                "translation_unit": "t00072.cc"
              },
              "type": "enum"
            },
            {
              "display_name": "mod1",
              "elements": [
                {
                  "bases": [],
                  "display_name": "D",
                  "id": "4129635462122133424",
                  "is_abstract": false,
                  "is_nested": false,
                  "is_struct": false,
                  "is_template": false,
                  "is_union": false,
                  "members": [],
                  "methods": [],
                  "module": {
                    "is_private": false,
                    "name": "t00072.app:lib1.mod1"
                  },
                  "name": "D",
                  "namespace": "clanguml::t00072",
                  "source_location": {
                    "column": 7,
                    "file": "src/lib1mod1.cppm",
                    "line": 4,
                    "translation_unit": "t00072.cc"
                  },
                  "template_parameters": [],
                  "type": "class"
                }
              ],
              "name": "mod1",
              "type": "module"
            },
            {
              "display_name": "mod2",
              "elements": [
                {
                  "bases": [],
                  "display_name": "E",
                  "id": "2777639070146181284",
                  "is_abstract": false,
                  "is_nested": false,
                  "is_struct": false,
                  "is_template": false,
                  "is_union": false,
                  "members": [],
                  "methods": [],
                  "module": {
                    "is_private": false,
                    "name": "t00072.app:lib1.mod2"
                  },
                  "name": "E",
                  "namespace": "clanguml::t00072",
                  "source_location": {
                    "column": 7,
                    "file": "src/lib1mod2.cppm",
                    "line": 4,
                    "translation_unit": "t00072.cc"
                  },
                  "template_parameters": [],
                  "type": "class"
                }
              ],
              "name": "mod2",
              "type": "module"
            }
          ],
          "name": ":lib1",
          "type": "module"
        },
        {
          "display_name": ":lib2",
          "elements": [
            {
              "bases": [],
              "display_name": "C",
              "id": "9156897130910376461",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "module": {
                "is_private": false,
                "name": "t00072.app:lib2"
              },
              "name": "C",
              "namespace": "clanguml::t00072",
              "source_location": {
                "column": 7,
                "file": "src/lib2.cppm",
                "line": 4,
                "translation_unit": "t00072.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "CC<T>",
              "id": "11783506550202616713",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": true,
              "is_union": false,
              "members": [
                {
                  "access": "private",
                  "is_static": false,
                  "name": "t",
                  "source_location": {
                    "column": 7,
                    "file": "src/lib2.cppm",
                    "line": 7,
                    "translation_unit": "t00072.cc"
                  },
                  "type": "T"
                }
              ],
              "methods": [],
              "module": {
                "is_private": false,
                "name": "t00072.app:lib2"
              },
              "name": "CC",
              "namespace": "clanguml::t00072",
              "source_location": {
                "column": 29,
                "file": "src/lib2.cppm",
                "line": 6,
                "translation_unit": "t00072.cc"
              },
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "template_type",
                  "name": "T",
                  "template_parameters": []
                }
              ],
              "type": "class"
            },
            {
              "constants": [
                "ccc1",
                "ccc2"
              ],
              "display_name": "CCC",
              "id": "3591084589486106282",
              "is_nested": false,
              "module": {
                "is_private": false,
                "name": "t00072.app:lib2"
              },
              "name": "CCC",
              "namespace": "clanguml::t00072::detail",
              "source_location": {
                "column": 12,
                "file": "src/lib2.cppm",
                "line": 11,
                "translation_unit": "t00072.cc"
              },
              "type": "enum"
            }
          ],
          "name": ":lib2",
          "type": "module"
        },
        {
          "bases": [],
          "display_name": "A",
          "id": "12416769441368968359",
          "is_abstract": false,
          "is_nested": false,
          "is_struct": false,
          "is_template": false,
          "is_union": false,
          "members": [
            {
              "access": "private",
              "is_static": false,
              "name": "a",
              "source_location": {
                "column": 9,
                "file": "src/t00072_mod.cppm",
                "line": 11,
                "translation_unit": "t00072.cc"
              },
              "type": "int"
            }
          ],
          "methods": [
            {
              "access": "private",
              "display_name": "get",
              "is_const": false,
              "is_consteval": false,
              "is_constexpr": false,
              "is_constructor": false,
              "is_copy_assignment": false,
              "is_coroutine": false,
              "is_defaulted": false,
              "is_deleted": false,
              "is_move_assignment": false,
              "is_noexcept": false,
              "is_operator": false,
              "is_pure_virtual": false,
              "is_static": false,
              "is_virtual": false,
              "name": "get",
              "parameters": [],
              "source_location": {
                "column": 9,
                "file": "src/t00072_mod.cppm",
                "line": 9,
                "translation_unit": "t00072.cc"
              },
              "template_parameters": [],
              "type": "int"
            }
          ],
          "module": {
            "is_private": false,
            "name": "t00072.app"
          },
          "name": "A",
          "namespace": "clanguml::t00072",
          "source_location": {
            "column": 7,
            "file": "src/t00072_mod.cppm",
            "line": 8,
            "translation_unit": "t00072.cc"
          },
          "template_parameters": [],
          "type": "class"
        }
      ],
      "name": "app",
      "type": "module"
    }
  ],
  "name": "t00072_class",
  "package_type": "module",
  "relationships": [],
  "using_module": "t00072",
  "using_namespace": "clanguml::t00072"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00072</data>
  <node id="n0">
   <data key="nd2">app</data>
   <data key="nd1">module</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">:lib1</data>
     <data key="nd1">module</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[B]]></data>
       <data key="nd6">false</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib1.cppm#L4</data>
       <data key="nd5">B</data>
      </node>
      <node id="n3">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[BB<T>]]></data>
       <data key="nd6">true</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib1.cppm#L6</data>
       <data key="nd5">BB</data>
      </node>
      <node id="n4">
       <data key="nd1">enum</data>
       <data key="nd2"><![CDATA[BBB]]></data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib1.cppm#L11</data>
       <data key="nd5">BBB</data>
      </node>
      <node id="n5">
       <data key="nd2">mod1</data>
       <data key="nd1">module</data>
       <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
        <node id="n6">
         <data key="nd1">class</data>
         <data key="nd2"><![CDATA[D]]></data>
         <data key="nd6">false</data>
         <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib1mod1.cppm#L4</data>
         <data key="nd5">D</data>
        </node>
       </graph>
      </node>
      <node id="n7">
       <data key="nd2">mod2</data>
       <data key="nd1">module</data>
       <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
        <node id="n8">
         <data key="nd1">class</data>
         <data key="nd2"><![CDATA[E]]></data>
         <data key="nd6">false</data>
         <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib1mod2.cppm#L4</data>
         <data key="nd5">E</data>
        </node>
       </graph>
      </node>
     </graph>
    </node>
    <node id="n9">
     <data key="nd2">:lib2</data>
     <data key="nd1">module</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n10">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[C]]></data>
       <data key="nd6">false</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib2.cppm#L4</data>
       <data key="nd5">C</data>
      </node>
      <node id="n11">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[CC<T>]]></data>
       <data key="nd6">true</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib2.cppm#L6</data>
       <data key="nd5">CC</data>
      </node>
      <node id="n12">
       <data key="nd1">enum</data>
       <data key="nd2"><![CDATA[CCC]]></data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/lib2.cppm#L11</data>
       <data key="nd5">CCC</data>
      </node>
     </graph>
    </node>
    <node id="n13">
     <data key="nd1">class</data>
     <data key="nd2"><![CDATA[A]]></data>
     <data key="nd6">false</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00072/src/t00072_mod.cppm#L8</data>
     <data key="nd5">A</data>
    </node>
   </graph>
  </node>
 </graph>
</graphml>

```
