# t00070 - Diagram filter based on C++20 modules
## Config
```yaml
diagrams:
  t00070_class:
    type: class
    glob:
      - t00070.cc
    include:
      modules:
        - t00070
    exclude:
      modules:
        - t00070.lib2
      module_access:
        - private
    using_namespace: clanguml::t00070
```
## Source code
File `tests/t00070/t00070.cc`
```cpp
import t00070;
import t00070.lib1;
import t00070.lib2;

namespace clanguml {
namespace t00070 {
int tmain()
{
    B b;
    C c;

    return 0;
}
}
}
```
File `tests/t00070/src/common.cppm`
```cpp
export module t00070;
export import t00070.lib1;
export import t00070.lib2;

export namespace clanguml::t00070 {
class A {
    int get() { return a; }

    int a;
};
}
```
File `tests/t00070/src/lib2.cppm`
```cpp
export module t00070.lib2;

export namespace clanguml::t00070 {
class C { };

template <typename T> class CC {
    T t;
};

enum class CCC { ccc1, ccc2 };
}
```
File `tests/t00070/src/lib1.cppm`
```cpp
export module t00070.lib1;

export namespace clanguml::t00070 {
class B { };

template <typename T> class BB {
    T t;
};

enum class BBB { bbb1, bbb2 };
}

module :private;
namespace clanguml::t00070 {
class BBBB { };
}
```
## Generated PlantUML diagrams
![t00070_class](./t00070_class.svg "Diagram filter based on C++20 modules")
## Generated Mermaid diagrams
![t00070_class](./t00070_class_mermaid.svg "Diagram filter based on C++20 modules")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "B",
      "id": "10914092792287246676",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "module": {
        "is_private": false,
        "name": "t00070.lib1"
      },
      "name": "B",
      "namespace": "clanguml::t00070",
      "source_location": {
        "column": 7,
        "file": "src/lib1.cppm",
        "line": 4,
        "translation_unit": "t00070.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "BB<T>",
      "id": "11886040664362261287",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "t",
          "source_location": {
            "column": 7,
            "file": "src/lib1.cppm",
            "line": 7,
            "translation_unit": "t00070.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "module": {
        "is_private": false,
        "name": "t00070.lib1"
      },
      "name": "BB",
      "namespace": "clanguml::t00070",
      "source_location": {
        "column": 29,
        "file": "src/lib1.cppm",
        "line": 6,
        "translation_unit": "t00070.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "constants": [
        "bbb1",
        "bbb2"
      ],
      "display_name": "BBB",
      "id": "13877552612980328783",
      "is_nested": false,
      "module": {
        "is_private": false,
        "name": "t00070.lib1"
      },
      "name": "BBB",
      "namespace": "clanguml::t00070",
      "source_location": {
        "column": 12,
        "file": "src/lib1.cppm",
        "line": 10,
        "translation_unit": "t00070.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "5345771447310891397",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 9,
            "file": "src/common.cppm",
            "line": 9,
            "translation_unit": "t00070.cc"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "private",
          "display_name": "get",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get",
          "parameters": [],
          "source_location": {
            "column": 9,
            "file": "src/common.cppm",
            "line": 7,
            "translation_unit": "t00070.cc"
          },
          "template_parameters": [],
          "type": "int"
        }
      ],
      "module": {
        "is_private": false,
        "name": "t00070"
      },
      "name": "A",
      "namespace": "clanguml::t00070",
      "source_location": {
        "column": 7,
        "file": "src/common.cppm",
        "line": 6,
        "translation_unit": "t00070.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00070_class",
  "package_type": "namespace",
  "relationships": [],
  "using_namespace": "clanguml::t00070"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00070</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00070/src/lib1.cppm#L4</data>
   <data key="nd5">B</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[BB<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00070/src/lib1.cppm#L6</data>
   <data key="nd5">BB</data>
  </node>
  <node id="n2">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[BBB]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00070/src/lib1.cppm#L10</data>
   <data key="nd5">BBB</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00070/src/common.cppm#L6</data>
   <data key="nd5">A</data>
  </node>
 </graph>
</graphml>

```
