# t00068 - Context filter radius parameter test case
## Config
```yaml
diagrams:
  t00068_r0_class:
    type: class
    title: AAA context of radius 0
    glob:
      - t00068.cc
    include:
      namespaces:
        - clanguml::t00068
      context:
        - match:
            radius: 0
            pattern: clanguml::t00068::AAA
    using_namespace: clanguml::t00068
  t00068_r1_class:
    type: class
    title: AAA context of radius 1
    glob:
      - t00068.cc
    include:
      namespaces:
        - clanguml::t00068
      context:
        - match:
            radius: 1
            pattern: clanguml::t00068::AAA
    using_namespace: clanguml::t00068
  t00068_r2_class:
    type: class
    title: AAA context of radius 2
    glob:
      - t00068.cc
    include:
      namespaces:
        - clanguml::t00068
      context:
        - match:
            radius: 2
            pattern: clanguml::t00068::AAA
    using_namespace: clanguml::t00068
```
## Source code
File `tests/t00068/t00068.cc`
```cpp
#include <memory>
#include <vector>

namespace clanguml {
namespace t00068 {

struct B { };

struct BB {
    std::vector<B> b;
};

enum class AKind { OneA, TwoA, ThreeA };

struct A { };

struct AA : public A { };

struct AAA : public AA {
    BB *bb;
    AKind akind;
};

struct R {
    AAA *aaa;
};

struct RR {
    std::shared_ptr<R> r;
};
}
}
```
## Generated PlantUML diagrams
![t00068_r0_class](./t00068_r0_class.svg "Context filter radius parameter test case")
![t00068_r1_class](./t00068_r1_class.svg "Context filter radius parameter test case")
![t00068_r2_class](./t00068_r2_class.svg "Context filter radius parameter test case")
## Generated Mermaid diagrams
![t00068_r0_class](./t00068_r0_class_mermaid.svg "Context filter radius parameter test case")
![t00068_r1_class](./t00068_r1_class_mermaid.svg "Context filter radius parameter test case")
![t00068_r2_class](./t00068_r2_class_mermaid.svg "Context filter radius parameter test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "AAA",
      "id": "11878554252076959348",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "bb",
          "source_location": {
            "column": 9,
            "file": "t00068.cc",
            "line": 20,
            "translation_unit": "t00068.cc"
          },
          "type": "BB *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "akind",
          "source_location": {
            "column": 11,
            "file": "t00068.cc",
            "line": 21,
            "translation_unit": "t00068.cc"
          },
          "type": "AKind"
        }
      ],
      "methods": [],
      "name": "AAA",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 19,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00068_r0_class",
  "package_type": "namespace",
  "relationships": [],
  "title": "AAA context of radius 0",
  "using_namespace": "clanguml::t00068"
}
```
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "BB",
      "id": "11421192930710045248",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 20,
            "file": "t00068.cc",
            "line": 10,
            "translation_unit": "t00068.cc"
          },
          "type": "std::vector<B>"
        }
      ],
      "methods": [],
      "name": "BB",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 9,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "OneA",
        "TwoA",
        "ThreeA"
      ],
      "display_name": "AKind",
      "id": "15107428292598946277",
      "is_nested": false,
      "name": "AKind",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 12,
        "file": "t00068.cc",
        "line": 13,
        "translation_unit": "t00068.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "AA",
      "id": "4623850284883436621",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "AA",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 17,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "4623850284883436621",
          "is_virtual": false
        }
      ],
      "display_name": "AAA",
      "id": "11878554252076959348",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "bb",
          "source_location": {
            "column": 9,
            "file": "t00068.cc",
            "line": 20,
            "translation_unit": "t00068.cc"
          },
          "type": "BB *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "akind",
          "source_location": {
            "column": 11,
            "file": "t00068.cc",
            "line": 21,
            "translation_unit": "t00068.cc"
          },
          "type": "AKind"
        }
      ],
      "methods": [],
      "name": "AAA",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 19,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "7996971851715399690",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "aaa",
          "source_location": {
            "column": 10,
            "file": "t00068.cc",
            "line": 25,
            "translation_unit": "t00068.cc"
          },
          "type": "AAA *"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 24,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00068_r1_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "11421192930710045248",
      "label": "bb",
      "source": "11878554252076959348",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "15107428292598946277",
      "label": "akind",
      "source": "11878554252076959348",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "4623850284883436621",
      "source": "11878554252076959348",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "11878554252076959348",
      "label": "aaa",
      "source": "7996971851715399690",
      "type": "association"
    }
  ],
  "title": "AAA context of radius 1",
  "using_namespace": "clanguml::t00068"
}
```
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "B",
      "id": "2873470995533754050",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 7,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "BB",
      "id": "11421192930710045248",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 20,
            "file": "t00068.cc",
            "line": 10,
            "translation_unit": "t00068.cc"
          },
          "type": "std::vector<B>"
        }
      ],
      "methods": [],
      "name": "BB",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 9,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "OneA",
        "TwoA",
        "ThreeA"
      ],
      "display_name": "AKind",
      "id": "15107428292598946277",
      "is_nested": false,
      "name": "AKind",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 12,
        "file": "t00068.cc",
        "line": 13,
        "translation_unit": "t00068.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "10379518537157600457",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 15,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "10379518537157600457",
          "is_virtual": false
        }
      ],
      "display_name": "AA",
      "id": "4623850284883436621",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "AA",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 17,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "4623850284883436621",
          "is_virtual": false
        }
      ],
      "display_name": "AAA",
      "id": "11878554252076959348",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "bb",
          "source_location": {
            "column": 9,
            "file": "t00068.cc",
            "line": 20,
            "translation_unit": "t00068.cc"
          },
          "type": "BB *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "akind",
          "source_location": {
            "column": 11,
            "file": "t00068.cc",
            "line": 21,
            "translation_unit": "t00068.cc"
          },
          "type": "AKind"
        }
      ],
      "methods": [],
      "name": "AAA",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 19,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "7996971851715399690",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "aaa",
          "source_location": {
            "column": 10,
            "file": "t00068.cc",
            "line": 25,
            "translation_unit": "t00068.cc"
          },
          "type": "AAA *"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 24,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "RR",
      "id": "9347006300339413552",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "r",
          "source_location": {
            "column": 24,
            "file": "t00068.cc",
            "line": 29,
            "translation_unit": "t00068.cc"
          },
          "type": "std::shared_ptr<R>"
        }
      ],
      "methods": [],
      "name": "RR",
      "namespace": "clanguml::t00068",
      "source_location": {
        "column": 8,
        "file": "t00068.cc",
        "line": 28,
        "translation_unit": "t00068.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00068_r2_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "2873470995533754050",
      "label": "b",
      "source": "11421192930710045248",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "10379518537157600457",
      "source": "4623850284883436621",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "11421192930710045248",
      "label": "bb",
      "source": "11878554252076959348",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "15107428292598946277",
      "label": "akind",
      "source": "11878554252076959348",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "4623850284883436621",
      "source": "11878554252076959348",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "11878554252076959348",
      "label": "aaa",
      "source": "7996971851715399690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "7996971851715399690",
      "label": "r",
      "source": "9347006300339413552",
      "type": "association"
    }
  ],
  "title": "AAA context of radius 2",
  "using_namespace": "clanguml::t00068"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <desc><![CDATA[AAA context of radius 0]]></desc>
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00068</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AAA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L19</data>
   <data key="nd5">AAA</data>
  </node>
 </graph>
</graphml>

```
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <desc><![CDATA[AAA context of radius 1]]></desc>
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00068</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[BB]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L9</data>
   <data key="nd5">BB</data>
  </node>
  <node id="n1">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[AKind]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L13</data>
   <data key="nd5">AKind</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L17</data>
   <data key="nd5">AA</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AAA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L19</data>
   <data key="nd5">AAA</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L24</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n3" target="n0">
   <data key="ed0">association</data>
   <data key="ed2">bb</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n3" target="n1">
   <data key="ed0">aggregation</data>
   <data key="ed2">akind</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n3" target="n2">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n4" target="n3">
   <data key="ed0">association</data>
   <data key="ed2">aaa</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <desc><![CDATA[AAA context of radius 2]]></desc>
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00068</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L7</data>
   <data key="nd5">B</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[BB]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L9</data>
   <data key="nd5">BB</data>
  </node>
  <node id="n2">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[AKind]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L13</data>
   <data key="nd5">AKind</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L15</data>
   <data key="nd5">A</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L17</data>
   <data key="nd5">AA</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AAA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L19</data>
   <data key="nd5">AAA</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L24</data>
   <data key="nd5">R</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[RR]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00068/t00068.cc#L28</data>
   <data key="nd5">RR</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">aggregation</data>
   <data key="ed2">b</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n4" target="n3">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n5" target="n1">
   <data key="ed0">association</data>
   <data key="ed2">bb</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n2">
   <data key="ed0">aggregation</data>
   <data key="ed2">akind</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n5" target="n4">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n6" target="n5">
   <data key="ed0">association</data>
   <data key="ed2">aaa</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n7" target="n6">
   <data key="ed0">association</data>
   <data key="ed2">r</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
