# t00063 - Element types diagram filter test case
## Config
```yaml
diagrams:
  t00063_class:
    type: class
    glob:
      - t00063.cc
    include:
      namespaces:
        - clanguml::t00063
    exclude:
      element_types:
        - enum
      elements:
        - type: member
          name: clanguml::t00063::R::d
    using_namespace: clanguml::t00063
```
## Source code
File `tests/t00063/t00063.cc`
```cpp
namespace clanguml {
namespace t00063 {
class A { };

enum B { b1, b2, b3 };

enum class C { c1, c2, c3 };

typedef enum { d1, d2, d3 } D;

struct R {
    enum RR { r1, r2, r3 };
    typedef enum { rr1, rr2, rr3 } RRR;
    A a;
    D d;
};
}
}
```
## Generated PlantUML diagrams
![t00063_class](./t00063_class.svg "Element types diagram filter test case")
## Generated Mermaid diagrams
![t00063_class](./t00063_class_mermaid.svg "Element types diagram filter test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "12145374198390396463",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00063",
      "source_location": {
        "column": 7,
        "file": "t00063.cc",
        "line": 3,
        "translation_unit": "t00063.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "6598844047351279039",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 7,
            "file": "t00063.cc",
            "line": 14,
            "translation_unit": "t00063.cc"
          },
          "type": "A"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00063",
      "source_location": {
        "column": 8,
        "file": "t00063.cc",
        "line": 11,
        "translation_unit": "t00063.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00063_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "12145374198390396463",
      "label": "a",
      "source": "6598844047351279039",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00063"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00063</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00063/t00063.cc#L3</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00063/t00063.cc#L11</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">aggregation</data>
   <data key="ed2">a</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
