# t00062 - Template specialization matching based on deduced context
## Config
```yaml
diagrams:
  t00062_class:
    type: class
    glob:
      - t00062.cc
    include:
      namespaces:
        - clanguml::t00062
    using_namespace: clanguml::t00062
    plantuml:
      before:
        - left to right direction
```
## Source code
File `tests/t00062/t00062.cc`
```cpp
#include <map>
#include <string>
#include <vector>

namespace clanguml {
namespace t00062 {
template <typename T> struct A;

template <typename U> struct A<U &> {
    U &u;
};

template <typename U> struct A<std::map<std::string, U> &> {
    U &u;
};

template <>
struct A<std::map<std::string, std::map<std::string, std::string>> &> { };

template <typename U> struct A<U **> {
    U **u;
};

template <typename U> struct A<U **const *> {
    U ***u;
};

template <typename U> struct A<U const *const volatile> {
    U ***u;
};

template <typename U> struct A<U &&> {
    U &&u;
};

template <typename U> struct A<U const &> {
    U const &u;
};

template <typename M, typename C> struct A<M C::*> {
    C &c;
    M C::*m;
};

template <typename M, typename C> struct A<M C::*&&> {
    C &&c;
    M C::*m;
};

template <typename M, typename C, typename Arg> struct A<M (C::*)(Arg)> {
    C &c;
    M C::*m;
};

template <typename C> struct A<int (C::*)(bool)> {
    C &c;
};

template <typename M, typename C, typename Arg> struct A<M (C::*)(Arg) &&> {
    C &&c;
    M C::*m;
};

template <typename C> struct A<float (C::*)(int) &&> {
    C &&c;
    float C::*mf;
};

template <typename M, typename C, typename Arg1, typename Arg2, typename Arg3>
struct A<M (C::*)(Arg1, Arg2, Arg3)> {
    C &c;
    M C::*m;
};

template <int N> struct A<char[N]> {
    char n[N];
};

template <> struct A<char[1000]> {
    std::vector<char> n;
};

template <int K, int L, int M> struct A<char[K][L][M]> {
    char klm[K][L][M];
};

template <typename U> struct A<U(...)> {
    bool u;
};

template <template <typename> class C, typename T> struct A<C<T>> {
    C<T> c;
};

template <template <typename, typename...> class C, typename T,
    typename... Args>
struct A<C<T, Args...>> {
    C<T> c;
    std::tuple<Args...> args;
};

}
}
```
## Generated PlantUML diagrams
![t00062_class](./t00062_class.svg "Template specialization matching based on deduced context")
## Generated Mermaid diagrams
![t00062_class](./t00062_class_mermaid.svg "Template specialization matching based on deduced context")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A<U &>",
      "id": "8374617602400725687",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 8,
            "file": "t00062.cc",
            "line": 10,
            "translation_unit": "t00062.cc"
          },
          "type": "U &"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 9,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "U",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<std::map<std::string,U> &>",
      "id": "8796385431567289962",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 8,
            "file": "t00062.cc",
            "line": 14,
            "translation_unit": "t00062.cc"
          },
          "type": "U &"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 13,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "std::string"
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "U",
              "template_parameters": []
            }
          ],
          "type": "std::map"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<std::map<std::string,std::map<std::string,std::string>> &>",
      "id": "9915105679966348381",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 8,
        "file": "t00062.cc",
        "line": 18,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "std::string"
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "std::string"
                },
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "std::string"
                }
              ],
              "type": "std::map"
            }
          ],
          "type": "std::map"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<U * *>",
      "id": "365615182513296790",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 9,
            "file": "t00062.cc",
            "line": 21,
            "translation_unit": "t00062.cc"
          },
          "type": "U **"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 20,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "U",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<U * * const*>",
      "id": "11033550166423942282",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 10,
            "file": "t00062.cc",
            "line": 25,
            "translation_unit": "t00062.cc"
          },
          "type": "U ***"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 24,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "U",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<U const volatile* const volatile>",
      "id": "11262922699574218242",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 10,
            "file": "t00062.cc",
            "line": 29,
            "translation_unit": "t00062.cc"
          },
          "type": "U ***"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 28,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "U",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<U &&>",
      "id": "8275865821195203329",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 9,
            "file": "t00062.cc",
            "line": 33,
            "translation_unit": "t00062.cc"
          },
          "type": "U &&"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 32,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "U",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<U const&>",
      "id": "2819662860157368941",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 14,
            "file": "t00062.cc",
            "line": 37,
            "translation_unit": "t00062.cc"
          },
          "type": "const U &"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 36,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "U",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<M C::*>",
      "id": "2517666306563442180",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 8,
            "file": "t00062.cc",
            "line": 41,
            "translation_unit": "t00062.cc"
          },
          "type": "C &"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "m",
          "source_location": {
            "column": 11,
            "file": "t00062.cc",
            "line": 42,
            "translation_unit": "t00062.cc"
          },
          "type": "M C::*"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 42,
        "file": "t00062.cc",
        "line": 40,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "M",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "C",
              "template_parameters": []
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<M C::* &&>",
      "id": "6622026683139123216",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 9,
            "file": "t00062.cc",
            "line": 46,
            "translation_unit": "t00062.cc"
          },
          "type": "C &&"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "m",
          "source_location": {
            "column": 11,
            "file": "t00062.cc",
            "line": 47,
            "translation_unit": "t00062.cc"
          },
          "type": "M C::*"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 42,
        "file": "t00062.cc",
        "line": 45,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "M",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "C",
              "template_parameters": []
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<M (C::*)(Arg)>",
      "id": "3164667843261489999",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 8,
            "file": "t00062.cc",
            "line": 51,
            "translation_unit": "t00062.cc"
          },
          "type": "C &"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "m",
          "source_location": {
            "column": 11,
            "file": "t00062.cc",
            "line": 52,
            "translation_unit": "t00062.cc"
          },
          "type": "M C::*"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 56,
        "file": "t00062.cc",
        "line": 50,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "M",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "C",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "Arg",
              "template_parameters": []
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<int (C::*)(bool)>",
      "id": "3811976443982984629",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 8,
            "file": "t00062.cc",
            "line": 56,
            "translation_unit": "t00062.cc"
          },
          "type": "C &"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 55,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "int"
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "C",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "bool"
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<M (C::*)(Arg) &&>",
      "id": "12957078077344767239",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 9,
            "file": "t00062.cc",
            "line": 60,
            "translation_unit": "t00062.cc"
          },
          "type": "C &&"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "m",
          "source_location": {
            "column": 11,
            "file": "t00062.cc",
            "line": 61,
            "translation_unit": "t00062.cc"
          },
          "type": "M C::*"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 56,
        "file": "t00062.cc",
        "line": 59,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "M",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "C",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "Arg",
              "template_parameters": []
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<float (C::*)(int) &&>",
      "id": "10861974466521141736",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 9,
            "file": "t00062.cc",
            "line": 65,
            "translation_unit": "t00062.cc"
          },
          "type": "C &&"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "mf",
          "source_location": {
            "column": 15,
            "file": "t00062.cc",
            "line": 66,
            "translation_unit": "t00062.cc"
          },
          "type": "float C::*"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 64,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "float"
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "C",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "int"
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<M (C::*)(Arg1,Arg2,Arg3)>",
      "id": "4354686233576631860",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 8,
            "file": "t00062.cc",
            "line": 71,
            "translation_unit": "t00062.cc"
          },
          "type": "C &"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "m",
          "source_location": {
            "column": 11,
            "file": "t00062.cc",
            "line": 72,
            "translation_unit": "t00062.cc"
          },
          "type": "M C::*"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 8,
        "file": "t00062.cc",
        "line": 70,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "M",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "C",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "Arg1",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "Arg2",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "Arg3",
              "template_parameters": []
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<char[N]>",
      "id": "4816535843331823446",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "n",
          "source_location": {
            "column": 10,
            "file": "t00062.cc",
            "line": 76,
            "translation_unit": "t00062.cc"
          },
          "type": "char[]"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 25,
        "file": "t00062.cc",
        "line": 75,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "char"
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "N",
              "template_parameters": []
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<char[1000]>",
      "id": "10547357379550851326",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "n",
          "source_location": {
            "column": 23,
            "file": "t00062.cc",
            "line": 80,
            "translation_unit": "t00062.cc"
          },
          "type": "std::vector<char>"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 20,
        "file": "t00062.cc",
        "line": 79,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "char"
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "1000"
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<char[M][L][K]>",
      "id": "4796750855835709219",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "klm",
          "source_location": {
            "column": 10,
            "file": "t00062.cc",
            "line": 84,
            "translation_unit": "t00062.cc"
          },
          "type": "char[][][]"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 39,
        "file": "t00062.cc",
        "line": 83,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "template_type",
                  "template_parameters": [
                    {
                      "is_variadic": false,
                      "kind": "argument",
                      "template_parameters": [],
                      "type": "char"
                    },
                    {
                      "is_variadic": false,
                      "kind": "template_type",
                      "name": "M",
                      "template_parameters": []
                    }
                  ]
                },
                {
                  "is_variadic": false,
                  "kind": "template_type",
                  "name": "L",
                  "template_parameters": []
                }
              ]
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "K",
              "template_parameters": []
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<U(...)>",
      "id": "123162362144007934",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "u",
          "source_location": {
            "column": 10,
            "file": "t00062.cc",
            "line": 88,
            "translation_unit": "t00062.cc"
          },
          "type": "bool"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 87,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "U",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": ""
            }
          ]
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<C<T>>",
      "id": "12826574907988417656",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 10,
            "file": "t00062.cc",
            "line": 92,
            "translation_unit": "t00062.cc"
          },
          "type": "C<T>"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 59,
        "file": "t00062.cc",
        "line": 91,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "T",
              "template_parameters": []
            }
          ],
          "type": "C"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<C<T,Args...>>",
      "id": "1860151690737773362",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 10,
            "file": "t00062.cc",
            "line": 98,
            "translation_unit": "t00062.cc"
          },
          "type": "C<T>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "args",
          "source_location": {
            "column": 25,
            "file": "t00062.cc",
            "line": 99,
            "translation_unit": "t00062.cc"
          },
          "type": "std::tuple<Args...>"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 8,
        "file": "t00062.cc",
        "line": 97,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "T",
              "template_parameters": []
            },
            {
              "is_variadic": true,
              "kind": "template_type",
              "name": "Args...",
              "template_parameters": []
            }
          ],
          "type": "C"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<T>",
      "id": "968828526679491811",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00062",
      "source_location": {
        "column": 30,
        "file": "t00062.cc",
        "line": 7,
        "translation_unit": "t00062.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00062_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "8374617602400725687",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "8374617602400725687",
      "source": "8796385431567289962",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "8796385431567289962",
      "source": "9915105679966348381",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "365615182513296790",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "365615182513296790",
      "source": "11033550166423942282",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "11262922699574218242",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "8275865821195203329",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "2819662860157368941",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "2517666306563442180",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "8275865821195203329",
      "source": "6622026683139123216",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "3164667843261489999",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "3164667843261489999",
      "source": "3811976443982984629",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "8275865821195203329",
      "source": "12957078077344767239",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "12957078077344767239",
      "source": "10861974466521141736",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "4354686233576631860",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "4816535843331823446",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "4816535843331823446",
      "source": "10547357379550851326",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "4796750855835709219",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "123162362144007934",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "12826574907988417656",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "968828526679491811",
      "source": "1860151690737773362",
      "type": "instantiation"
    }
  ],
  "using_namespace": "clanguml::t00062"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00062</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<U &>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L9</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<std::map<std::string,U> &>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L13</data>
   <data key="nd5">A</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<std::map<std::string,std::map<std::string,std::string>> &>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L18</data>
   <data key="nd5">A</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<U * *>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L20</data>
   <data key="nd5">A</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<U * * const*>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L24</data>
   <data key="nd5">A</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<U const volatile* const volatile>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L28</data>
   <data key="nd5">A</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<U &&>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L32</data>
   <data key="nd5">A</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<U const&>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L36</data>
   <data key="nd5">A</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<M C::*>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L40</data>
   <data key="nd5">A</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<M C::* &&>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L45</data>
   <data key="nd5">A</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<M (C::*)(Arg)>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L50</data>
   <data key="nd5">A</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<int (C::*)(bool)>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L55</data>
   <data key="nd5">A</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<M (C::*)(Arg) &&>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L59</data>
   <data key="nd5">A</data>
  </node>
  <node id="n13">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<float (C::*)(int) &&>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L64</data>
   <data key="nd5">A</data>
  </node>
  <node id="n14">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<M (C::*)(Arg1,Arg2,Arg3)>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L70</data>
   <data key="nd5">A</data>
  </node>
  <node id="n15">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<char[N]>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L75</data>
   <data key="nd5">A</data>
  </node>
  <node id="n16">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<char[1000]>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L79</data>
   <data key="nd5">A</data>
  </node>
  <node id="n17">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<char[M][L][K]>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L83</data>
   <data key="nd5">A</data>
  </node>
  <node id="n18">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<U(...)>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L87</data>
   <data key="nd5">A</data>
  </node>
  <node id="n19">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<C<T>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L91</data>
   <data key="nd5">A</data>
  </node>
  <node id="n20">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<C<T,Args...>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L97</data>
   <data key="nd5">A</data>
  </node>
  <node id="n21">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00062/t00062.cc#L7</data>
   <data key="nd5">A</data>
  </node>
  <edge id="e0" source="n0" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n1" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n2" target="n1">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n3" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n4" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n5" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n6" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n7" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n8" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n9" target="n6">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n10" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n11" target="n10">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n12" target="n6">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e13" source="n13" target="n12">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e14" source="n14" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e15" source="n15" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e16" source="n16" target="n15">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e17" source="n17" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e18" source="n18" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e19" source="n19" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e20" source="n20" target="n21">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
