# t00060 - Parents (base classes) diagram filter test case
## Config
```yaml
diagrams:
  t00060_class:
    type: class
    glob:
      - t00060.cc
    include:
      namespaces:
        - clanguml::t00060
      parents:
        - clanguml::t00060::D
        - clanguml::t00060::H<T,P>
    using_namespace: clanguml::t00060
```
## Source code
File `tests/t00060/t00060.cc`
```cpp
namespace clanguml {
namespace t00060 {
struct A { };
struct B : public A { };
struct C : public A { };
struct D : public B, public C { };
struct E : public C { };
struct F : public D { };

template <typename T> struct G {
    T g;
};

template <typename T, typename P> struct H : public G<T> {
    G<T> h;
    P hh;
};

}
}
```
## Generated PlantUML diagrams
![t00060_class](./t00060_class.svg "Parents (base classes) diagram filter test case")
## Generated Mermaid diagrams
![t00060_class](./t00060_class_mermaid.svg "Parents (base classes) diagram filter test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "10988924398770427782",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00060",
      "source_location": {
        "column": 8,
        "file": "t00060.cc",
        "line": 3,
        "translation_unit": "t00060.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "10988924398770427782",
          "is_virtual": false
        }
      ],
      "display_name": "B",
      "id": "3837202951447476570",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00060",
      "source_location": {
        "column": 8,
        "file": "t00060.cc",
        "line": 4,
        "translation_unit": "t00060.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "10988924398770427782",
          "is_virtual": false
        }
      ],
      "display_name": "C",
      "id": "14621286753018118303",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00060",
      "source_location": {
        "column": 8,
        "file": "t00060.cc",
        "line": 5,
        "translation_unit": "t00060.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "3837202951447476570",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "14621286753018118303",
          "is_virtual": false
        }
      ],
      "display_name": "D",
      "id": "13037498978322255855",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00060",
      "source_location": {
        "column": 8,
        "file": "t00060.cc",
        "line": 6,
        "translation_unit": "t00060.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G<T>",
      "id": "15018438600264556141",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "g",
          "source_location": {
            "column": 7,
            "file": "t00060.cc",
            "line": 11,
            "translation_unit": "t00060.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00060",
      "source_location": {
        "column": 30,
        "file": "t00060.cc",
        "line": 10,
        "translation_unit": "t00060.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "15018438600264556141",
          "is_virtual": false
        }
      ],
      "display_name": "H<T,P>",
      "id": "15052882792987965106",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "h",
          "source_location": {
            "column": 10,
            "file": "t00060.cc",
            "line": 15,
            "translation_unit": "t00060.cc"
          },
          "type": "G<T>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "hh",
          "source_location": {
            "column": 7,
            "file": "t00060.cc",
            "line": 16,
            "translation_unit": "t00060.cc"
          },
          "type": "P"
        }
      ],
      "methods": [],
      "name": "H",
      "namespace": "clanguml::t00060",
      "source_location": {
        "column": 42,
        "file": "t00060.cc",
        "line": 14,
        "translation_unit": "t00060.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "P",
          "template_parameters": []
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00060_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "10988924398770427782",
      "source": "3837202951447476570",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "10988924398770427782",
      "source": "14621286753018118303",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "3837202951447476570",
      "source": "13037498978322255855",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "14621286753018118303",
      "source": "13037498978322255855",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15018438600264556141",
      "label": "h",
      "source": "15052882792987965106",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "15018438600264556141",
      "source": "15052882792987965106",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00060"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00060</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00060/t00060.cc#L3</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00060/t00060.cc#L4</data>
   <data key="nd5">B</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00060/t00060.cc#L5</data>
   <data key="nd5">C</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00060/t00060.cc#L6</data>
   <data key="nd5">D</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00060/t00060.cc#L10</data>
   <data key="nd5">G</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[H<T,P>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00060/t00060.cc#L14</data>
   <data key="nd5">H</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n3" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n3" target="n2">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n5" target="n4">
   <data key="ed0">aggregation</data>
   <data key="ed2">h</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n5" target="n4">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
