# t00059 - Non-virtual abstract factory pattern using concepts test case
## Config
```yaml
diagrams:
  t00059_class:
    type: class
    glob:
      - t00059.cc
    include:
      namespaces:
        - clanguml::t00059
    plantuml:
      style:
        instantiation: up
        association: up
        aggregation: up
        dependency: up
        constraint: up
    using_namespace: clanguml::t00059
```
## Source code
File `tests/t00059/t00059.cc`
```cpp
#include <string>

namespace clanguml {
namespace t00059 {

template <typename T>
concept fruit_c = requires(T t) {
    T{};
    t.get_name();
};

template <typename T>
concept apple_c = fruit_c<T> && requires(T t) { t.get_sweetness(); };

template <typename T>
concept orange_c = fruit_c<T> && requires(T t) { t.get_bitterness(); };

class gala_apple {
public:
    auto get_name() const -> std::string { return "gala"; }
    auto get_sweetness() const -> float { return 0.8; }
};

class empire_apple {
public:
    auto get_name() const -> std::string { return "empire"; }
    auto get_sweetness() const -> float { return 0.6; }
};

class lima_orange {
public:
    auto get_name() const -> std::string { return "lima"; }
    auto get_bitterness() const -> float { return 0.8; }
};

class valencia_orange {
public:
    auto get_name() const -> std::string { return "valencia"; }
    auto get_bitterness() const -> float { return 0.6; }
};

template <apple_c TA, orange_c TO> class fruit_factory {
public:
    auto create_apple() const -> TA { return TA{}; }
    auto create_orange() const -> TO { return TO{}; }
};

using fruit_factory_1 = fruit_factory<gala_apple, valencia_orange>;
using fruit_factory_2 = fruit_factory<empire_apple, lima_orange>;

struct R {
    fruit_factory_1 factory_1;
    fruit_factory_2 factory_2;
};
}
}
```
## Generated PlantUML diagrams
![t00059_class](./t00059_class.svg "Non-virtual abstract factory pattern using concepts test case")
## Generated Mermaid diagrams
![t00059_class](./t00059_class_mermaid.svg "Non-virtual abstract factory pattern using concepts test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "display_name": "fruit_c<T>",
      "id": "15409614944555682724",
      "name": "fruit_c",
      "namespace": "clanguml::t00059",
      "parameters": [
        {
          "name": "t",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00059.cc",
        "line": 7,
        "translation_unit": "t00059.cc"
      },
      "statements": [
        "T{}",
        "t.get_name()"
      ],
      "type": "concept"
    },
    {
      "display_name": "apple_c<T>",
      "id": "15460658973889491278",
      "name": "apple_c",
      "namespace": "clanguml::t00059",
      "parameters": [
        {
          "name": "t",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00059.cc",
        "line": 13,
        "translation_unit": "t00059.cc"
      },
      "statements": [
        "t.get_sweetness()"
      ],
      "type": "concept"
    },
    {
      "display_name": "orange_c<T>",
      "id": "11871235528526449070",
      "name": "orange_c",
      "namespace": "clanguml::t00059",
      "parameters": [
        {
          "name": "t",
          "type": "T"
        }
      ],
      "source_location": {
        "column": 9,
        "file": "t00059.cc",
        "line": 16,
        "translation_unit": "t00059.cc"
      },
      "statements": [
        "t.get_bitterness()"
      ],
      "type": "concept"
    },
    {
      "bases": [],
      "display_name": "gala_apple",
      "id": "3199977289714626562",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "get_name",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_name",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 20,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "std::string"
        },
        {
          "access": "public",
          "display_name": "get_sweetness",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_sweetness",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 21,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "float"
        }
      ],
      "name": "gala_apple",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 7,
        "file": "t00059.cc",
        "line": 18,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "empire_apple",
      "id": "5283255778782189239",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "get_name",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_name",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 26,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "std::string"
        },
        {
          "access": "public",
          "display_name": "get_sweetness",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_sweetness",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 27,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "float"
        }
      ],
      "name": "empire_apple",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 7,
        "file": "t00059.cc",
        "line": 24,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "lima_orange",
      "id": "13194363620083632640",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "get_name",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_name",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 32,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "std::string"
        },
        {
          "access": "public",
          "display_name": "get_bitterness",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_bitterness",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 33,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "float"
        }
      ],
      "name": "lima_orange",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 7,
        "file": "t00059.cc",
        "line": 30,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "valencia_orange",
      "id": "6421822083325871384",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "get_name",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_name",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 38,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "std::string"
        },
        {
          "access": "public",
          "display_name": "get_bitterness",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_bitterness",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 39,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "float"
        }
      ],
      "name": "valencia_orange",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 7,
        "file": "t00059.cc",
        "line": 36,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "fruit_factory<apple_c TA,orange_c TO>",
      "id": "18414291870583467652",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "create_apple",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "create_apple",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 44,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "TA"
        },
        {
          "access": "public",
          "display_name": "create_orange",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "create_orange",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00059.cc",
            "line": 45,
            "translation_unit": "t00059.cc"
          },
          "template_parameters": [],
          "type": "TO"
        }
      ],
      "name": "fruit_factory",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 42,
        "file": "t00059.cc",
        "line": 42,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "TA",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "TO",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "fruit_factory<gala_apple,valencia_orange>",
      "id": "4410224819557178230",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "fruit_factory",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 42,
        "file": "t00059.cc",
        "line": 42,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "gala_apple"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "valencia_orange"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "fruit_factory<empire_apple,lima_orange>",
      "id": "4291122236508329812",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "fruit_factory",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 42,
        "file": "t00059.cc",
        "line": 42,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "empire_apple"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "lima_orange"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "9026405371626834603",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "factory_1",
          "source_location": {
            "column": 21,
            "file": "t00059.cc",
            "line": 52,
            "translation_unit": "t00059.cc"
          },
          "type": "fruit_factory_1"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "factory_2",
          "source_location": {
            "column": 21,
            "file": "t00059.cc",
            "line": 53,
            "translation_unit": "t00059.cc"
          },
          "type": "fruit_factory_2"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00059",
      "source_location": {
        "column": 8,
        "file": "t00059.cc",
        "line": 51,
        "translation_unit": "t00059.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00059_class",
  "package_type": "namespace",
  "relationships": [
    {
      "destination": "15409614944555682724",
      "label": "T",
      "source": "15460658973889491278",
      "type": "constraint"
    },
    {
      "destination": "15409614944555682724",
      "label": "T",
      "source": "11871235528526449070",
      "type": "constraint"
    },
    {
      "destination": "15460658973889491278",
      "label": "TA",
      "source": "18414291870583467652",
      "type": "constraint"
    },
    {
      "destination": "11871235528526449070",
      "label": "TO",
      "source": "18414291870583467652",
      "type": "constraint"
    },
    {
      "access": "public",
      "destination": "3199977289714626562",
      "source": "4410224819557178230",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "6421822083325871384",
      "source": "4410224819557178230",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "18414291870583467652",
      "source": "4410224819557178230",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "5283255778782189239",
      "source": "4291122236508329812",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "13194363620083632640",
      "source": "4291122236508329812",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "18414291870583467652",
      "source": "4291122236508329812",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "4410224819557178230",
      "label": "factory_1",
      "source": "9026405371626834603",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "4291122236508329812",
      "label": "factory_2",
      "source": "9026405371626834603",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00059"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00059</data>
  <node id="n0">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[fruit_c<T>]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L7</data>
   <data key="nd5">fruit_c</data>
  </node>
  <node id="n1">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[apple_c<T>]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L13</data>
   <data key="nd5">apple_c</data>
  </node>
  <node id="n2">
   <data key="nd1">concept</data>
   <data key="nd2"><![CDATA[orange_c<T>]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L16</data>
   <data key="nd5">orange_c</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[gala_apple]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L18</data>
   <data key="nd5">gala_apple</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[empire_apple]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L24</data>
   <data key="nd5">empire_apple</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[lima_orange]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L30</data>
   <data key="nd5">lima_orange</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[valencia_orange]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L36</data>
   <data key="nd5">valencia_orange</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[fruit_factory<apple_c TA,orange_c TO>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L42</data>
   <data key="nd5">fruit_factory</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[fruit_factory<gala_apple,valencia_orange>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L42</data>
   <data key="nd5">fruit_factory</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[fruit_factory<empire_apple,lima_orange>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L42</data>
   <data key="nd5">fruit_factory</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00059/t00059.cc#L51</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n7" target="n1">
   <data key="ed0">constraint</data>
   <data key="ed2">TA</data>
  </edge>
  <edge id="e1" source="n7" target="n2">
   <data key="ed0">constraint</data>
   <data key="ed2">TO</data>
  </edge>
  <edge id="e2" source="n8" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n8" target="n6">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n8" target="n7">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n9" target="n4">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n9" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n9" target="n7">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n10" target="n8">
   <data key="ed0">aggregation</data>
   <data key="ed2">factory_1</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n10" target="n9">
   <data key="ed0">aggregation</data>
   <data key="ed2">factory_2</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n1" target="n0">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e11" source="n2" target="n0">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
 </graph>
</graphml>

```
