# t00054 - Test case for `together` layout hint in class diagram with rendered namespaces
## Config
```yaml
diagrams:
  t00054_class:
    type: class
    glob:
      - t00054.cc
    include:
      namespaces:
        - clanguml::t00054
    using_namespace: clanguml::t00054
    generate_packages: true
    layout:
      a:
        - together: [f]
      "detail::c":
        - together: [detail::e]
      A:
        - together: [B,G]
      "detail2::detail3::D":
        - together: [detail2::detail3::E]
      "detail4::h":
        - together: [detail4::i,detail4::j]
```
## Source code
File `tests/t00054/t00054.cc`
```cpp
namespace clanguml {
namespace t00054 {
struct a { };
struct b { };

namespace detail {
struct c { };
struct d { };
struct e { };
} // namespace detail
struct f { };
struct g { };

struct A { };
struct B { };

namespace detail2 {
struct C { };
namespace detail3 {
struct D { };
struct E { };
} // namespace detail3
struct F { };
} // namespace detail2
struct G { };

namespace detail4 {
enum class h { hhh };
enum class i { iii };
enum class j { jjj };
} // namespace detail4

}
}
```
## Generated PlantUML diagrams
![t00054_class](./t00054_class.svg "Test case for `together` layout hint in class diagram with rendered namespaces")
## Generated Mermaid diagrams
![t00054_class](./t00054_class_mermaid.svg "Test case for `together` layout hint in class diagram with rendered namespaces")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "a",
      "id": "9270950236024596515",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "a",
      "namespace": "clanguml::t00054",
      "source_location": {
        "column": 8,
        "file": "t00054.cc",
        "line": 3,
        "translation_unit": "t00054.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "b",
      "id": "2019335998445389750",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "b",
      "namespace": "clanguml::t00054",
      "source_location": {
        "column": 8,
        "file": "t00054.cc",
        "line": 4,
        "translation_unit": "t00054.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "display_name": "detail",
      "elements": [
        {
          "bases": [],
          "display_name": "c",
          "id": "9344254677301759712",
          "is_abstract": false,
          "is_nested": false,
          "is_struct": true,
          "is_template": false,
          "is_union": false,
          "members": [],
          "methods": [],
          "name": "c",
          "namespace": "clanguml::t00054::detail",
          "source_location": {
            "column": 8,
            "file": "t00054.cc",
            "line": 7,
            "translation_unit": "t00054.cc"
          },
          "template_parameters": [],
          "type": "class"
        },
        {
          "bases": [],
          "display_name": "d",
          "id": "12556476966260377269",
          "is_abstract": false,
          "is_nested": false,
          "is_struct": true,
          "is_template": false,
          "is_union": false,
          "members": [],
          "methods": [],
          "name": "d",
          "namespace": "clanguml::t00054::detail",
          "source_location": {
            "column": 8,
            "file": "t00054.cc",
            "line": 8,
            "translation_unit": "t00054.cc"
          },
          "template_parameters": [],
          "type": "class"
        },
        {
          "bases": [],
          "display_name": "e",
          "id": "16300406667702870622",
          "is_abstract": false,
          "is_nested": false,
          "is_struct": true,
          "is_template": false,
          "is_union": false,
          "members": [],
          "methods": [],
          "name": "e",
          "namespace": "clanguml::t00054::detail",
          "source_location": {
            "column": 8,
            "file": "t00054.cc",
            "line": 9,
            "translation_unit": "t00054.cc"
          },
          "template_parameters": [],
          "type": "class"
        }
      ],
      "name": "detail",
      "type": "namespace"
    },
    {
      "bases": [],
      "display_name": "f",
      "id": "16989011633586567505",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "f",
      "namespace": "clanguml::t00054",
      "source_location": {
        "column": 8,
        "file": "t00054.cc",
        "line": 11,
        "translation_unit": "t00054.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "g",
      "id": "4763958358723026560",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "g",
      "namespace": "clanguml::t00054",
      "source_location": {
        "column": 8,
        "file": "t00054.cc",
        "line": 12,
        "translation_unit": "t00054.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "7341254596028038438",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00054",
      "source_location": {
        "column": 8,
        "file": "t00054.cc",
        "line": 14,
        "translation_unit": "t00054.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "9886184362964504036",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00054",
      "source_location": {
        "column": 8,
        "file": "t00054.cc",
        "line": 15,
        "translation_unit": "t00054.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "display_name": "detail2",
      "elements": [
        {
          "bases": [],
          "display_name": "C",
          "id": "4320439640653423141",
          "is_abstract": false,
          "is_nested": false,
          "is_struct": true,
          "is_template": false,
          "is_union": false,
          "members": [],
          "methods": [],
          "name": "C",
          "namespace": "clanguml::t00054::detail2",
          "source_location": {
            "column": 8,
            "file": "t00054.cc",
            "line": 18,
            "translation_unit": "t00054.cc"
          },
          "template_parameters": [],
          "type": "class"
        },
        {
          "display_name": "detail3",
          "elements": [
            {
              "bases": [],
              "display_name": "D",
              "id": "10131121575562587828",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "D",
              "namespace": "clanguml::t00054::detail2::detail3",
              "source_location": {
                "column": 8,
                "file": "t00054.cc",
                "line": 20,
                "translation_unit": "t00054.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "E",
              "id": "1079425719858040844",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "E",
              "namespace": "clanguml::t00054::detail2::detail3",
              "source_location": {
                "column": 8,
                "file": "t00054.cc",
                "line": 21,
                "translation_unit": "t00054.cc"
              },
              "template_parameters": [],
              "type": "class"
            }
          ],
          "name": "detail3",
          "type": "namespace"
        },
        {
          "bases": [],
          "display_name": "F",
          "id": "3573557537207225693",
          "is_abstract": false,
          "is_nested": false,
          "is_struct": true,
          "is_template": false,
          "is_union": false,
          "members": [],
          "methods": [],
          "name": "F",
          "namespace": "clanguml::t00054::detail2",
          "source_location": {
            "column": 8,
            "file": "t00054.cc",
            "line": 23,
            "translation_unit": "t00054.cc"
          },
          "template_parameters": [],
          "type": "class"
        }
      ],
      "name": "detail2",
      "type": "namespace"
    },
    {
      "bases": [],
      "display_name": "G",
      "id": "10926522093371166825",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00054",
      "source_location": {
        "column": 8,
        "file": "t00054.cc",
        "line": 25,
        "translation_unit": "t00054.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "display_name": "detail4",
      "elements": [
        {
          "constants": [
            "hhh"
          ],
          "display_name": "h",
          "id": "12741423994147129467",
          "is_nested": false,
          "name": "h",
          "namespace": "clanguml::t00054::detail4",
          "source_location": {
            "column": 12,
            "file": "t00054.cc",
            "line": 28,
            "translation_unit": "t00054.cc"
          },
          "type": "enum"
        },
        {
          "constants": [
            "iii"
          ],
          "display_name": "i",
          "id": "3532170587121787176",
          "is_nested": false,
          "name": "i",
          "namespace": "clanguml::t00054::detail4",
          "source_location": {
            "column": 12,
            "file": "t00054.cc",
            "line": 29,
            "translation_unit": "t00054.cc"
          },
          "type": "enum"
        },
        {
          "constants": [
            "jjj"
          ],
          "display_name": "j",
          "id": "3994675475412698780",
          "is_nested": false,
          "name": "j",
          "namespace": "clanguml::t00054::detail4",
          "source_location": {
            "column": 12,
            "file": "t00054.cc",
            "line": 30,
            "translation_unit": "t00054.cc"
          },
          "type": "enum"
        }
      ],
      "name": "detail4",
      "type": "namespace"
    }
  ],
  "name": "t00054_class",
  "package_type": "namespace",
  "relationships": [],
  "using_namespace": "clanguml::t00054"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00054</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[a]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L3</data>
   <data key="nd5">a</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[b]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L4</data>
   <data key="nd5">b</data>
  </node>
  <node id="n2">
   <data key="nd2">detail</data>
   <data key="nd1">namespace</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n3">
     <data key="nd1">class</data>
     <data key="nd2"><![CDATA[c]]></data>
     <data key="nd6">false</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L7</data>
     <data key="nd5">c</data>
    </node>
    <node id="n4">
     <data key="nd1">class</data>
     <data key="nd2"><![CDATA[d]]></data>
     <data key="nd6">false</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L8</data>
     <data key="nd5">d</data>
    </node>
    <node id="n5">
     <data key="nd1">class</data>
     <data key="nd2"><![CDATA[e]]></data>
     <data key="nd6">false</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L9</data>
     <data key="nd5">e</data>
    </node>
   </graph>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[f]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L11</data>
   <data key="nd5">f</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[g]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L12</data>
   <data key="nd5">g</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L14</data>
   <data key="nd5">A</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L15</data>
   <data key="nd5">B</data>
  </node>
  <node id="n10">
   <data key="nd2">detail2</data>
   <data key="nd1">namespace</data>
   <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n11">
     <data key="nd1">class</data>
     <data key="nd2"><![CDATA[C]]></data>
     <data key="nd6">false</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L18</data>
     <data key="nd5">C</data>
    </node>
    <node id="n12">
     <data key="nd2">detail3</data>
     <data key="nd1">namespace</data>
     <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n13">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[D]]></data>
       <data key="nd6">false</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L20</data>
       <data key="nd5">D</data>
      </node>
      <node id="n14">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[E]]></data>
       <data key="nd6">false</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L21</data>
       <data key="nd5">E</data>
      </node>
     </graph>
    </node>
    <node id="n15">
     <data key="nd1">class</data>
     <data key="nd2"><![CDATA[F]]></data>
     <data key="nd6">false</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L23</data>
     <data key="nd5">F</data>
    </node>
   </graph>
  </node>
  <node id="n16">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L25</data>
   <data key="nd5">G</data>
  </node>
  <node id="n17">
   <data key="nd2">detail4</data>
   <data key="nd1">namespace</data>
   <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n18">
     <data key="nd1">enum</data>
     <data key="nd2"><![CDATA[h]]></data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L28</data>
     <data key="nd5">h</data>
    </node>
    <node id="n19">
     <data key="nd1">enum</data>
     <data key="nd2"><![CDATA[i]]></data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L29</data>
     <data key="nd5">i</data>
    </node>
    <node id="n20">
     <data key="nd1">enum</data>
     <data key="nd2"><![CDATA[j]]></data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00054/t00054.cc#L30</data>
     <data key="nd5">j</data>
    </node>
   </graph>
  </node>
 </graph>
</graphml>

```
