# t00052 - Test case for template methods rendering
## Config
```yaml
diagrams:
  t00052_class:
    type: class
    glob:
      - t00052.cc
    include:
      namespaces:
        - clanguml::t00052
    using_namespace: clanguml::t00052
```
## Source code
File `tests/t00052/t00052.cc`
```cpp
#include <cmath>

namespace clanguml {
namespace t00052 {

class A {
public:
    template <typename T> T a(T p) { return p; }

    template <typename F, typename Q> void aa(F &&f, Q q) { f(q); }
};

template <typename T> class B {
public:
    T b(T t) { return t; }

    template <typename F> T bb(F &&f, T t) { return f(t); }
};

template <typename T> class C {
    template <typename P> T c(P p) { return static_cast<T>(p); }
};

template <> template <> int C<int>::c<double>(double p)
{
    return std::floor(p);
}

struct R {
    A a;
    B<int> b;
    C<int> c;
};
}
}
```
## Generated PlantUML diagrams
![t00052_class](./t00052_class.svg "Test case for template methods rendering")
## Generated Mermaid diagrams
![t00052_class](./t00052_class_mermaid.svg "Test case for template methods rendering")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "17606824539677586172",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "a<T>",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "a",
          "parameters": [
            {
              "name": "p",
              "type": "T"
            }
          ],
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "T",
              "template_parameters": []
            }
          ],
          "type": "T"
        },
        {
          "access": "public",
          "display_name": "aa<F,Q>",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "aa",
          "parameters": [
            {
              "name": "f",
              "type": "F &&"
            },
            {
              "name": "q",
              "type": "Q"
            }
          ],
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "F",
              "template_parameters": []
            },
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "Q",
              "template_parameters": []
            }
          ],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00052",
      "source_location": {
        "column": 7,
        "file": "t00052.cc",
        "line": 6,
        "translation_unit": "t00052.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B<T>",
      "id": "13898350213798320518",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "b",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "b",
          "parameters": [
            {
              "name": "t",
              "type": "T"
            }
          ],
          "source_location": {
            "column": 7,
            "file": "t00052.cc",
            "line": 15,
            "translation_unit": "t00052.cc"
          },
          "template_parameters": [],
          "type": "T"
        },
        {
          "access": "public",
          "display_name": "bb<F>",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "bb",
          "parameters": [
            {
              "name": "f",
              "type": "F &&"
            },
            {
              "name": "t",
              "type": "T"
            }
          ],
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "F",
              "template_parameters": []
            }
          ],
          "type": "T"
        }
      ],
      "name": "B",
      "namespace": "clanguml::t00052",
      "source_location": {
        "column": 29,
        "file": "t00052.cc",
        "line": 13,
        "translation_unit": "t00052.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<T>",
      "id": "5502053119078660195",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "private",
          "display_name": "c<P>",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "c",
          "parameters": [
            {
              "name": "p",
              "type": "P"
            }
          ],
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "template_type",
              "name": "P",
              "template_parameters": []
            }
          ],
          "type": "T"
        }
      ],
      "name": "C",
      "namespace": "clanguml::t00052",
      "source_location": {
        "column": 29,
        "file": "t00052.cc",
        "line": 20,
        "translation_unit": "t00052.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B<int>",
      "id": "8344217782477406209",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00052",
      "source_location": {
        "column": 29,
        "file": "t00052.cc",
        "line": 13,
        "translation_unit": "t00052.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<int>",
      "id": "3943750700435505414",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00052",
      "source_location": {
        "column": 29,
        "file": "t00052.cc",
        "line": 20,
        "translation_unit": "t00052.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "9263829349466393810",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 7,
            "file": "t00052.cc",
            "line": 30,
            "translation_unit": "t00052.cc"
          },
          "type": "A"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 12,
            "file": "t00052.cc",
            "line": 31,
            "translation_unit": "t00052.cc"
          },
          "type": "B<int>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 12,
            "file": "t00052.cc",
            "line": 32,
            "translation_unit": "t00052.cc"
          },
          "type": "C<int>"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00052",
      "source_location": {
        "column": 8,
        "file": "t00052.cc",
        "line": 29,
        "translation_unit": "t00052.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00052_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "13898350213798320518",
      "source": "8344217782477406209",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "5502053119078660195",
      "source": "3943750700435505414",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "17606824539677586172",
      "label": "a",
      "source": "9263829349466393810",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "8344217782477406209",
      "label": "b",
      "source": "9263829349466393810",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "3943750700435505414",
      "label": "c",
      "source": "9263829349466393810",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00052"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00052</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00052/t00052.cc#L6</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00052/t00052.cc#L13</data>
   <data key="nd5">B</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00052/t00052.cc#L20</data>
   <data key="nd5">C</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B<int>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00052/t00052.cc#L13</data>
   <data key="nd5">B</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<int>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00052/t00052.cc#L20</data>
   <data key="nd5">C</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00052/t00052.cc#L29</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n3" target="n1">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n4" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n5" target="n0">
   <data key="ed0">aggregation</data>
   <data key="ed2">a</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n3">
   <data key="ed0">aggregation</data>
   <data key="ed2">b</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n5" target="n4">
   <data key="ed0">aggregation</data>
   <data key="ed2">c</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
