# t00050 - Test case for generating notes from comments using jinja templates
## Config
```yaml
diagrams:
  t00050_class:
    type: class
    glob:
      - t00050.cc
    comment_parser: clang
    include:
      namespaces:
        - clanguml::t00050
    using_namespace: clanguml::t00050
    plantuml:
      after:
        - >
          note left of {{ alias("NoSuchClass") }}
             {{ comment("NoSuchClass").formatted }}
          end note
        - >
          note left of {{ alias("A") }}
             {{ comment("clanguml::t00050::A").formatted }}
          end note
        - >
          note right of {{ element("clanguml::t00050::A").alias }}
             {% set e=element("clanguml::t00050::A") %} {{ e.comment.formatted }}          
          end note
        - >
          note left of {{ alias("C") }} #AABBCC                 
             {{ trim(comment("clanguml::t00050::C").text) }}          
          end note
        - >
          {% set cmt=comment("clanguml::t00050::G").paragraph %}
          note top of {{ alias("G") }}
             {{ trim(cmt.0) }}
          end note

          note right of {{ alias("G") }}
             {{ trim(cmt.1) }}
          end note

          note bottom of {{ alias("G") }}
             {{ trim(cmt.2) }}
          end note
        - >
          {# Render brief comments and todos, if any were written for an element #}
          {% for e in diagram.elements %}
          {% if existsIn(e, "comment") and existsIn(e.comment, "brief") %}
  
          note top of {{ e.alias }} {% if e.type == "class" %} #22AA22 {% else %} #2222AA {% endif %}
             {% set c=e.comment %} {{ c.brief.0 }}
          end note
          
          {% endif %}
          {% if existsIn(e, "comment") and existsIn(e.comment, "todo") %}
          {% set c=e.comment %} 
          {% for t in c.todo %}
          note top of {{ e.alias }} #882222           
             **TODO**
             {{ t }}
          end note
          
          {% endfor %}

          {% endif %}
          {# Render template parameters if any #}
          {% if existsIn(e, "comment") and existsIn(e.comment, "tparam") %}
          {% set c=e.comment %} 

          note top of {{ e.alias }} #AAAAFF           
             **Template parameters**
             {% for tp in c.tparam %}
             //{{ tp.name }}// {{ trim(tp.description) }}        
             {% endfor %}
          end note

          {% endif %}
          {% endfor %}
    mermaid:
      after:
        - |
          note for {{ alias("NoSuchClass") }} "{{ comment("NoSuchClass").formatted }}"
        - |
          note for {{ alias("A") }} "{{ comment("clanguml::t00050::A").formatted }}"
        - |
          note for {{ element("clanguml::t00050::A").alias }} {% set e=element("clanguml::t00050::A") %} "{{ e.comment.formatted }}"
          note for {{ alias("C") }} "{{ trim(comment("clanguml::t00050::C").text) }}"
          {% set cmt=comment("clanguml::t00050::G").paragraph %}
          note for {{ alias("G") }} "{{ trim(cmt.0) }}"
          note for {{ alias("G") }} "{{ trim(cmt.1) }}"
          note for {{ alias("G") }} "{{ trim(cmt.2) }}"
        - |
          {# Render brief comments and todos, if any were written for an element #}
          {% for e in diagram.elements %}
          {% if existsIn(e, "comment") and existsIn(e.comment, "brief") %}
          note for {{ e.alias }} {% set c=e.comment %} "{{ c.brief.0 }}"
          {% endif %}
          {% if existsIn(e, "comment") and existsIn(e.comment, "todo") %}
          {% set c=e.comment %}
          {% for t in c.todo %}
          note for {{ e.alias }} "**TODO** {{ t }}"
          {% endfor %}
          {% endif %}
          {% endfor %}

```
## Source code
File `tests/t00050/t00050.cc`
```cpp
namespace clanguml {

/// Vivamus integer non suscipit taciti mus
class A { };

namespace t00050 {

/// Lorem ipsum dolor sit
class A { };

/**
 * \brief Lorem ipsum
 *
 * Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis
 * vehicula class ultricies mollis dictumst, aenean non a in donec nulla.
 * Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,
 * integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora
 * tellus ligula porttitor metus.
 *
 * \todo 1. Write meaningful comment
 * \todo 2. Write tests
 * \todo 3. Implement
 */
class B { };

/// \brief Long comment example
///
/// Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis
/// vehicula class ultricies mollis dictumst, aenean non a in donec nulla.
/// Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,
/// integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora
/// tellus ligula porttitor metus.
///
/// Vivamus integer non suscipit taciti mus etiam at primis tempor sagittis sit,
/// euismod libero facilisi aptent elementum felis blandit cursus gravida sociis
/// erat ante, eleifend lectus nullam dapibus netus feugiat curae curabitur est
/// ad. Massa curae fringilla porttitor quam sollicitudin iaculis aptent leo
/// ligula euismod dictumst, orci penatibus mauris eros etiam praesent erat
/// volutpat posuere hac. Metus fringilla nec ullamcorper odio aliquam lacinia
/// conubia mauris tempor, etiam ultricies proin quisque lectus sociis id
/// tristique, integer phasellus taciti pretium adipiscing tortor sagittis
/// ligula.
///
/// Mollis pretium lorem primis senectus habitasse lectus scelerisque
/// donec, ultricies tortor suspendisse adipiscing fusce morbi volutpat
/// pellentesque, consectetur mi risus molestie curae malesuada cum. Dignissim
/// lacus convallis massa mauris enim ad mattis magnis senectus montes, mollis
/// taciti phasellus accumsan bibendum semper blandit suspendisse faucibus nibh
/// est, metus lobortis morbi cras magna vivamus per risus fermentum. Dapibus
/// imperdiet praesent magnis ridiculus congue gravida curabitur dictum
/// sagittis, enim et magna sit inceptos sodales parturient pharetra mollis,
/// aenean vel nostra tellus commodo pretium sapien sociosqu.
class C { };

/// Mollis pretium lorem primis
namespace utils {

/// Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis
/// vehicula class ultricies mollis dictumst, aenean non a in donec nulla.
/// Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,
/// integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora
/// tellus ligula porttitor metus.
///
/// \todo Implement...
class D { };

} // namespace utils

/// Mollis pretium lorem primis
enum class E { E1, E2, E3 };

/// \brief Simple array wrapper.
///
/// This class is just for testing tparam parsing, it serves no other
/// purpose.
///
/// \tparam T Type of array elements.
/// \tparam V Type of regular element.
/// \tparam N Size of T array.
///
template <typename T, typename V, int N> class F {
    T t[N];
    V v;

    /// \brief Set value of v
    ///
    /// \param v_ New value for v
    V set_value(V v_) const { return v = v_; }
};

/// This is a short description of class G.
///
/// This is an intermediate description of class G.
///
/// This is a long description of class G.
class G { };

class NoComment { };

} // namespace t00050
} // namespace clanguml
```
## Generated PlantUML diagrams
![t00050_class](./t00050_class.svg "Test case for generating notes from comments using jinja templates")
## Generated Mermaid diagrams
![t00050_class](./t00050_class_mermaid.svg "Test case for generating notes from comments using jinja templates")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "comment": {
        "formatted": "Lorem ipsum dolor sit",
        "paragraph": [
          " Lorem ipsum dolor sit\n"
        ],
        "raw": "/// Lorem ipsum dolor sit",
        "text": "\n Lorem ipsum dolor sit\n"
      },
      "display_name": "A",
      "id": "15084505707181941399",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00050",
      "source_location": {
        "column": 7,
        "file": "t00050.cc",
        "line": 9,
        "translation_unit": "t00050.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "comment": {
        "brief": [
          " Lorem ipsum\n"
        ],
        "formatted": "\n \\brief Lorem ipsum\n\n Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n tellus ligula porttitor metus.\n\n \\todo 1. Write meaningful comment\n \\todo 2. Write tests\n \\todo 3. Implement\n ",
        "paragraph": [
          " \n",
          " Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n tellus ligula porttitor metus.\n",
          " \n"
        ],
        "raw": "/**\n * \\brief Lorem ipsum\n *\n * Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n * vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n * Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n * integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n * tellus ligula porttitor metus.\n *\n * \\todo 1. Write meaningful comment\n * \\todo 2. Write tests\n * \\todo 3. Implement\n */",
        "text": "\n \n\n Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n tellus ligula porttitor metus.\n\n \n",
        "todo": [
          " 1. Write meaningful comment\n \n",
          " 2. Write tests\n \n",
          " 3. Implement\n"
        ]
      },
      "display_name": "B",
      "id": "4002096787278689954",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00050",
      "source_location": {
        "column": 7,
        "file": "t00050.cc",
        "line": 24,
        "translation_unit": "t00050.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "comment": {
        "brief": [
          " Long comment example\n"
        ],
        "formatted": "\\brief Long comment example\n\nLorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\nvehicula class ultricies mollis dictumst, aenean non a in donec nulla.\nPhasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\ninteger placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\ntellus ligula porttitor metus.\n\nVivamus integer non suscipit taciti mus etiam at primis tempor sagittis sit,\neuismod libero facilisi aptent elementum felis blandit cursus gravida sociis\nerat ante, eleifend lectus nullam dapibus netus feugiat curae curabitur est\nad. Massa curae fringilla porttitor quam sollicitudin iaculis aptent leo\nligula euismod dictumst, orci penatibus mauris eros etiam praesent erat\nvolutpat posuere hac. Metus fringilla nec ullamcorper odio aliquam lacinia\nconubia mauris tempor, etiam ultricies proin quisque lectus sociis id\ntristique, integer phasellus taciti pretium adipiscing tortor sagittis\nligula.\n\nMollis pretium lorem primis senectus habitasse lectus scelerisque\ndonec, ultricies tortor suspendisse adipiscing fusce morbi volutpat\npellentesque, consectetur mi risus molestie curae malesuada cum. Dignissim\nlacus convallis massa mauris enim ad mattis magnis senectus montes, mollis\ntaciti phasellus accumsan bibendum semper blandit suspendisse faucibus nibh\nest, metus lobortis morbi cras magna vivamus per risus fermentum. Dapibus\nimperdiet praesent magnis ridiculus congue gravida curabitur dictum\nsagittis, enim et magna sit inceptos sodales parturient pharetra mollis,\naenean vel nostra tellus commodo pretium sapien sociosqu.",
        "paragraph": [
          " \n",
          " Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n tellus ligula porttitor metus.\n",
          " Vivamus integer non suscipit taciti mus etiam at primis tempor sagittis sit,\n euismod libero facilisi aptent elementum felis blandit cursus gravida sociis\n erat ante, eleifend lectus nullam dapibus netus feugiat curae curabitur est\n ad. Massa curae fringilla porttitor quam sollicitudin iaculis aptent leo\n ligula euismod dictumst, orci penatibus mauris eros etiam praesent erat\n volutpat posuere hac. Metus fringilla nec ullamcorper odio aliquam lacinia\n conubia mauris tempor, etiam ultricies proin quisque lectus sociis id\n tristique, integer phasellus taciti pretium adipiscing tortor sagittis\n ligula.\n",
          " Mollis pretium lorem primis senectus habitasse lectus scelerisque\n donec, ultricies tortor suspendisse adipiscing fusce morbi volutpat\n pellentesque, consectetur mi risus molestie curae malesuada cum. Dignissim\n lacus convallis massa mauris enim ad mattis magnis senectus montes, mollis\n taciti phasellus accumsan bibendum semper blandit suspendisse faucibus nibh\n est, metus lobortis morbi cras magna vivamus per risus fermentum. Dapibus\n imperdiet praesent magnis ridiculus congue gravida curabitur dictum\n sagittis, enim et magna sit inceptos sodales parturient pharetra mollis,\n aenean vel nostra tellus commodo pretium sapien sociosqu.\n"
        ],
        "raw": "/// \\brief Long comment example\n///\n/// Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n/// vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n/// Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n/// integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n/// tellus ligula porttitor metus.\n///\n/// Vivamus integer non suscipit taciti mus etiam at primis tempor sagittis sit,\n/// euismod libero facilisi aptent elementum felis blandit cursus gravida sociis\n/// erat ante, eleifend lectus nullam dapibus netus feugiat curae curabitur est\n/// ad. Massa curae fringilla porttitor quam sollicitudin iaculis aptent leo\n/// ligula euismod dictumst, orci penatibus mauris eros etiam praesent erat\n/// volutpat posuere hac. Metus fringilla nec ullamcorper odio aliquam lacinia\n/// conubia mauris tempor, etiam ultricies proin quisque lectus sociis id\n/// tristique, integer phasellus taciti pretium adipiscing tortor sagittis\n/// ligula.\n///\n/// Mollis pretium lorem primis senectus habitasse lectus scelerisque\n/// donec, ultricies tortor suspendisse adipiscing fusce morbi volutpat\n/// pellentesque, consectetur mi risus molestie curae malesuada cum. Dignissim\n/// lacus convallis massa mauris enim ad mattis magnis senectus montes, mollis\n/// taciti phasellus accumsan bibendum semper blandit suspendisse faucibus nibh\n/// est, metus lobortis morbi cras magna vivamus per risus fermentum. Dapibus\n/// imperdiet praesent magnis ridiculus congue gravida curabitur dictum\n/// sagittis, enim et magna sit inceptos sodales parturient pharetra mollis,\n/// aenean vel nostra tellus commodo pretium sapien sociosqu.",
        "text": "\n \n\n Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n tellus ligula porttitor metus.\n\n Vivamus integer non suscipit taciti mus etiam at primis tempor sagittis sit,\n euismod libero facilisi aptent elementum felis blandit cursus gravida sociis\n erat ante, eleifend lectus nullam dapibus netus feugiat curae curabitur est\n ad. Massa curae fringilla porttitor quam sollicitudin iaculis aptent leo\n ligula euismod dictumst, orci penatibus mauris eros etiam praesent erat\n volutpat posuere hac. Metus fringilla nec ullamcorper odio aliquam lacinia\n conubia mauris tempor, etiam ultricies proin quisque lectus sociis id\n tristique, integer phasellus taciti pretium adipiscing tortor sagittis\n ligula.\n\n Mollis pretium lorem primis senectus habitasse lectus scelerisque\n donec, ultricies tortor suspendisse adipiscing fusce morbi volutpat\n pellentesque, consectetur mi risus molestie curae malesuada cum. Dignissim\n lacus convallis massa mauris enim ad mattis magnis senectus montes, mollis\n taciti phasellus accumsan bibendum semper blandit suspendisse faucibus nibh\n est, metus lobortis morbi cras magna vivamus per risus fermentum. Dapibus\n imperdiet praesent magnis ridiculus congue gravida curabitur dictum\n sagittis, enim et magna sit inceptos sodales parturient pharetra mollis,\n aenean vel nostra tellus commodo pretium sapien sociosqu.\n"
      },
      "display_name": "C",
      "id": "13304653229368631380",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00050",
      "source_location": {
        "column": 7,
        "file": "t00050.cc",
        "line": 53,
        "translation_unit": "t00050.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "comment": {
        "formatted": "Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\nvehicula class ultricies mollis dictumst, aenean non a in donec nulla.\nPhasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\ninteger placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\ntellus ligula porttitor metus.\n\n\\todo Implement...",
        "paragraph": [
          " Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n tellus ligula porttitor metus.\n",
          " \n"
        ],
        "raw": "/// Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n/// vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n/// Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n/// integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n/// tellus ligula porttitor metus.\n///\n/// \\todo Implement...",
        "text": "\n Lorem ipsum dolor sit amet consectetur adipiscing elit, urna consequat felis\n vehicula class ultricies mollis dictumst, aenean non a in donec nulla.\n Phasellus ante pellentesque erat cum risus consequat imperdiet aliquam,\n integer placerat et turpis mi eros nec lobortis taciti, vehicula nisl litora\n tellus ligula porttitor metus.\n\n \n",
        "todo": [
          " Implement...\n"
        ]
      },
      "display_name": "utils::D",
      "id": "11940116532816154397",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00050::utils",
      "source_location": {
        "column": 7,
        "file": "t00050.cc",
        "line": 65,
        "translation_unit": "t00050.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "comment": {
        "formatted": "Mollis pretium lorem primis",
        "paragraph": [
          " Mollis pretium lorem primis\n"
        ],
        "raw": "/// Mollis pretium lorem primis",
        "text": "\n Mollis pretium lorem primis\n"
      },
      "constants": [
        "E1",
        "E2",
        "E3"
      ],
      "display_name": "E",
      "id": "16218752252560943986",
      "is_nested": false,
      "name": "E",
      "namespace": "clanguml::t00050",
      "source_location": {
        "column": 12,
        "file": "t00050.cc",
        "line": 70,
        "translation_unit": "t00050.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "comment": {
        "brief": [
          " Simple array wrapper.\n"
        ],
        "formatted": "\\brief Simple array wrapper.\n\nThis class is just for testing tparam parsing, it serves no other\npurpose.\n\n\\tparam T Type of array elements.\n\\tparam V Type of regular element.\n\\tparam N Size of T array.",
        "paragraph": [
          " \n",
          " This class is just for testing tparam parsing, it serves no other\n purpose.\n",
          " \n"
        ],
        "raw": "/// \\brief Simple array wrapper.\n///\n/// This class is just for testing tparam parsing, it serves no other\n/// purpose.\n///\n/// \\tparam T Type of array elements.\n/// \\tparam V Type of regular element.\n/// \\tparam N Size of T array.\n///",
        "text": "\n \n\n This class is just for testing tparam parsing, it serves no other\n purpose.\n\n \n",
        "tparam": [
          {
            "description": "Type of array elements.",
            "name": "T"
          },
          {
            "description": "Type of regular element.",
            "name": "V"
          },
          {
            "description": "Size of T array.",
            "name": "N"
          }
        ]
      },
      "display_name": "F<T,V,int N>",
      "id": "6349587286791676739",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "t",
          "source_location": {
            "column": 7,
            "file": "t00050.cc",
            "line": 82,
            "translation_unit": "t00050.cc"
          },
          "type": "T[]"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "v",
          "source_location": {
            "column": 7,
            "file": "t00050.cc",
            "line": 83,
            "translation_unit": "t00050.cc"
          },
          "type": "V"
        }
      ],
      "methods": [
        {
          "access": "private",
          "comment": {
            "brief": [
              " Set value of v\n"
            ],
            "formatted": "\\brief Set value of v\n\n\\param v_ New value for v",
            "paragraph": [
              " \n",
              " \n"
            ],
            "param": [
              {
                "description": "New value for v",
                "name": "v_"
              }
            ],
            "raw": "/// \\brief Set value of v\n    ///\n    /// \\param v_ New value for v",
            "text": "\n \n\n \n"
          },
          "display_name": "set_value",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "set_value",
          "parameters": [
            {
              "name": "v_",
              "type": "V"
            }
          ],
          "source_location": {
            "column": 7,
            "file": "t00050.cc",
            "line": 88,
            "translation_unit": "t00050.cc"
          },
          "template_parameters": [],
          "type": "V"
        }
      ],
      "name": "F",
      "namespace": "clanguml::t00050",
      "source_location": {
        "column": 48,
        "file": "t00050.cc",
        "line": 81,
        "translation_unit": "t00050.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "V",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "non_type_template",
          "name": "N",
          "template_parameters": [],
          "type": "int"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "comment": {
        "formatted": "This is a short description of class G.\n\nThis is an intermediate description of class G.\n\nThis is a long description of class G.",
        "paragraph": [
          " This is a short description of class G.\n",
          " This is an intermediate description of class G.\n",
          " This is a long description of class G.\n"
        ],
        "raw": "/// This is a short description of class G.\n///\n/// This is an intermediate description of class G.\n///\n/// This is a long description of class G.",
        "text": "\n This is a short description of class G.\n\n This is an intermediate description of class G.\n\n This is a long description of class G.\n"
      },
      "display_name": "G",
      "id": "3595881236250399534",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00050",
      "source_location": {
        "column": 7,
        "file": "t00050.cc",
        "line": 96,
        "translation_unit": "t00050.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "NoComment",
      "id": "14661550394863975460",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "NoComment",
      "namespace": "clanguml::t00050",
      "source_location": {
        "column": 7,
        "file": "t00050.cc",
        "line": 98,
        "translation_unit": "t00050.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00050_class",
  "package_type": "namespace",
  "relationships": [],
  "using_namespace": "clanguml::t00050"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00050</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L9</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L24</data>
   <data key="nd5">Lorem ipsum</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L53</data>
   <data key="nd5">Long comment example</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[utils::D]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L65</data>
   <data key="nd5">D</data>
  </node>
  <node id="n4">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[E]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L70</data>
   <data key="nd5">E</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[F<T,V,int N>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L81</data>
   <data key="nd5">Simple array wrapper.</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L96</data>
   <data key="nd5">G</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[NoComment]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00050/t00050.cc#L98</data>
   <data key="nd5">NoComment</data>
  </node>
 </graph>
</graphml>

```
