# t00049 - Test case configurable type aliases
## Config
```yaml
diagrams:
  t00049_class:
    type: class
    using_namespace: clanguml::t00049
    type_aliases:
      "std::basic_string<char>": thestring
      "std::string": thestring
      "std::vector<std::string>": string_vector
      "std::vector<thestring>": string_vector
      "std::map<int,int>": intmap
    glob:
      - t00049.cc
    include:
      namespaces:
        - clanguml::t00049
```
## Source code
File `tests/t00049/t00049.cc`
```cpp
#include <map>
#include <string>
#include <vector>

namespace clanguml {
namespace t00049 {
template <typename T> struct A {
    T a;

    T &get_a() { return a; }
};

struct R {
    A<std::basic_string<char>> a_string;
    A<std::vector<std::string>> a_vector_string;
    A<std::map<int, int>> a_int_map;

    A<std::map<int, int>> get_int_map() { return a_int_map; }

    void set_int_map(A<std::map<int, int>> &&int_map) { a_int_map = int_map; }
};
} // namespace t00049
} // namespace clanguml
```
## Generated PlantUML diagrams
![t00049_class](./t00049_class.svg "Test case configurable type aliases")
## Generated Mermaid diagrams
![t00049_class](./t00049_class_mermaid.svg "Test case configurable type aliases")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A<T>",
      "id": "2983774156134972621",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 7,
            "file": "t00049.cc",
            "line": 8,
            "translation_unit": "t00049.cc"
          },
          "type": "T"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "get_a",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_a",
          "parameters": [],
          "source_location": {
            "column": 8,
            "file": "t00049.cc",
            "line": 10,
            "translation_unit": "t00049.cc"
          },
          "template_parameters": [],
          "type": "T &"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00049",
      "source_location": {
        "column": 30,
        "file": "t00049.cc",
        "line": 7,
        "translation_unit": "t00049.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<intmap>",
      "id": "5238634827090307546",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00049",
      "source_location": {
        "column": 30,
        "file": "t00049.cc",
        "line": 7,
        "translation_unit": "t00049.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "intmap"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<thestring>",
      "id": "7784466046534755756",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00049",
      "source_location": {
        "column": 30,
        "file": "t00049.cc",
        "line": 7,
        "translation_unit": "t00049.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "thestring"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<string_vector>",
      "id": "4496598810482416085",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00049",
      "source_location": {
        "column": 30,
        "file": "t00049.cc",
        "line": 7,
        "translation_unit": "t00049.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "string_vector"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "18304192584424729815",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a_string",
          "source_location": {
            "column": 32,
            "file": "t00049.cc",
            "line": 14,
            "translation_unit": "t00049.cc"
          },
          "type": "A<thestring>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "a_vector_string",
          "source_location": {
            "column": 33,
            "file": "t00049.cc",
            "line": 15,
            "translation_unit": "t00049.cc"
          },
          "type": "A<string_vector>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "a_int_map",
          "source_location": {
            "column": 27,
            "file": "t00049.cc",
            "line": 16,
            "translation_unit": "t00049.cc"
          },
          "type": "A<intmap>"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "get_int_map",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_int_map",
          "parameters": [],
          "source_location": {
            "column": 27,
            "file": "t00049.cc",
            "line": 18,
            "translation_unit": "t00049.cc"
          },
          "template_parameters": [],
          "type": "clanguml::t00049::A<intmap>"
        },
        {
          "access": "public",
          "display_name": "set_int_map",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "set_int_map",
          "parameters": [
            {
              "name": "int_map",
              "type": "clanguml::t00049::A<std::map<int,int>> &&"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00049.cc",
            "line": 20,
            "translation_unit": "t00049.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "R",
      "namespace": "clanguml::t00049",
      "source_location": {
        "column": 8,
        "file": "t00049.cc",
        "line": 13,
        "translation_unit": "t00049.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00049_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "2983774156134972621",
      "source": "5238634827090307546",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "2983774156134972621",
      "source": "7784466046534755756",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "2983774156134972621",
      "source": "4496598810482416085",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "2983774156134972621",
      "source": "18304192584424729815",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "7784466046534755756",
      "label": "a_string",
      "source": "18304192584424729815",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "4496598810482416085",
      "label": "a_vector_string",
      "source": "18304192584424729815",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "5238634827090307546",
      "label": "a_int_map",
      "source": "18304192584424729815",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00049"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00049</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00049/t00049.cc#L7</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<intmap>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00049/t00049.cc#L7</data>
   <data key="nd5">A</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<thestring>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00049/t00049.cc#L7</data>
   <data key="nd5">A</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<string_vector>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00049/t00049.cc#L7</data>
   <data key="nd5">A</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00049/t00049.cc#L13</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n3" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n4" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n4" target="n2">
   <data key="ed0">aggregation</data>
   <data key="ed2">a_string</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n4" target="n3">
   <data key="ed0">aggregation</data>
   <data key="ed2">a_vector_string</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n4" target="n1">
   <data key="ed0">aggregation</data>
   <data key="ed2">a_int_map</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
