# t00047 - Test case for recursive variadic template
## Config
```yaml
diagrams:
  t00047_class:
    type: class
    glob:
      - t00047.cc
    using_namespace: clanguml::t00047
    plantuml:
      style:
        instantiation: up
    include:
      namespaces:
        - clanguml::t00047
```
## Source code
File `tests/t00047/t00047.cc`
```cpp
#include <type_traits>

namespace clanguml {
namespace t00047 {

template <typename... Ts> struct conditional_t;

template <typename Else> struct conditional_t<Else> {
    using type = Else;
};

template <typename Result, typename... Tail>
struct conditional_t<std::true_type, Result, Tail...> {
    using type = Result;
};

template <typename Result, typename... Tail>
struct conditional_t<std::false_type, Result, Tail...> {
    using type = typename conditional_t<Tail...>::type;
};

template <typename... Ts>
using conditional = typename conditional_t<Ts...>::type;

} // namespace t00047
} // namespace clanguml
```
## Generated PlantUML diagrams
![t00047_class](./t00047_class.svg "Test case for recursive variadic template")
## Generated Mermaid diagrams
![t00047_class](./t00047_class_mermaid.svg "Test case for recursive variadic template")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "conditional_t<Else>",
      "id": "379154246597001066",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "conditional_t",
      "namespace": "clanguml::t00047",
      "source_location": {
        "column": 33,
        "file": "t00047.cc",
        "line": 8,
        "translation_unit": "t00047.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "Else",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "conditional_t<std::true_type,Result,Tail...>",
      "id": "4798257275118206478",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "conditional_t",
      "namespace": "clanguml::t00047",
      "source_location": {
        "column": 8,
        "file": "t00047.cc",
        "line": 13,
        "translation_unit": "t00047.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::true_type"
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "Result",
          "template_parameters": []
        },
        {
          "is_variadic": true,
          "kind": "template_type",
          "name": "Tail...",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "conditional_t<std::false_type,Result,Tail...>",
      "id": "6599505553474916091",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "conditional_t",
      "namespace": "clanguml::t00047",
      "source_location": {
        "column": 8,
        "file": "t00047.cc",
        "line": 18,
        "translation_unit": "t00047.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::false_type"
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "Result",
          "template_parameters": []
        },
        {
          "is_variadic": true,
          "kind": "template_type",
          "name": "Tail...",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "conditional_t<Ts...>",
      "id": "13389543941136699317",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "conditional_t",
      "namespace": "clanguml::t00047",
      "source_location": {
        "column": 34,
        "file": "t00047.cc",
        "line": 6,
        "translation_unit": "t00047.cc"
      },
      "template_parameters": [
        {
          "is_variadic": true,
          "kind": "template_type",
          "name": "Ts...",
          "template_parameters": []
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00047_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "13389543941136699317",
      "source": "379154246597001066",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13389543941136699317",
      "source": "4798257275118206478",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13389543941136699317",
      "source": "6599505553474916091",
      "type": "instantiation"
    }
  ],
  "using_namespace": "clanguml::t00047"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00047</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[conditional_t<Else>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00047/t00047.cc#L8</data>
   <data key="nd5">conditional_t</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[conditional_t<std::true_type,Result,Tail...>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00047/t00047.cc#L13</data>
   <data key="nd5">conditional_t</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[conditional_t<std::false_type,Result,Tail...>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00047/t00047.cc#L18</data>
   <data key="nd5">conditional_t</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[conditional_t<Ts...>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00047/t00047.cc#L6</data>
   <data key="nd5">conditional_t</data>
  </node>
  <edge id="e0" source="n0" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n1" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n2" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
