# t00039 - Subclass class diagram filter test
## Config
```yaml
diagrams:
  t00039_class:
    type: class
    generate_packages: false
    glob:
      - t00039.cc
    using_namespace: clanguml::t00039
    include:
      subclasses:
        - clanguml::t00039::A
        - clanguml::t00039::C
        - clanguml::t00039::D
        - clanguml::t00039::E
        - clanguml::t00039::ns3::F<T>
      relationships:
        - inheritance
    exclude:
      namespaces:
        - std
        - clanguml::t00039::detail
        - clanguml::t00039::ns3::detail
```
## Source code
File `tests/t00039/t00039.cc`
```cpp
#include <string>

namespace clanguml::t00039 {
struct B { };

struct C { };

struct D { };

struct E { };

namespace ns1 {
struct BB : public B { };
} // namespace ns1

struct CD : public C, public D { };

struct DE : public D, public E { };

struct CDE : public C, public D, public E { };

struct A { };

struct AA : public A { };

struct AAA : public AA {
    B *b;
};

namespace ns2 {
struct AAAA : public virtual AAA { };
} // namespace ns2

namespace detail {
struct AA : public A { };
} // namespace detail

namespace ns3 {
template <typename T> struct F {
    T *t;
};

template <typename T, typename M> struct FF : public F<T> {
    M *m;
};

template <typename T, typename M> struct FE : public F<T> {
    M *m;
};

template <typename T, typename M, typename N> struct FFF : public FF<T, M> {
    N *n;
};

} // namespace ns3
} // namespace clanguml::t00039

```
## Generated PlantUML diagrams
![t00039_class](./t00039_class.svg "Subclass class diagram filter test")
## Generated Mermaid diagrams
![t00039_class](./t00039_class_mermaid.svg "Subclass class diagram filter test")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "C",
      "id": "1929879816262895494",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 6,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "15801497117276934278",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 8,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E",
      "id": "15673049474775122911",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 10,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "1929879816262895494",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "15801497117276934278",
          "is_virtual": false
        }
      ],
      "display_name": "CD",
      "id": "6803868980223975432",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "CD",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 16,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "15801497117276934278",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "15673049474775122911",
          "is_virtual": false
        }
      ],
      "display_name": "DE",
      "id": "10528178466429449283",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "DE",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 18,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "1929879816262895494",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "15801497117276934278",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "15673049474775122911",
          "is_virtual": false
        }
      ],
      "display_name": "CDE",
      "id": "15019897156758195721",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "CDE",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 20,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "8409372207574078607",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 22,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "8409372207574078607",
          "is_virtual": false
        }
      ],
      "display_name": "AA",
      "id": "14095754188805440104",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "AA",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 24,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "14095754188805440104",
          "is_virtual": false
        }
      ],
      "display_name": "AAA",
      "id": "17267865950737182436",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 8,
            "file": "t00039.cc",
            "line": 27,
            "translation_unit": "t00039.cc"
          },
          "type": "B *"
        }
      ],
      "methods": [],
      "name": "AAA",
      "namespace": "clanguml::t00039",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 26,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "17267865950737182436",
          "is_virtual": true
        }
      ],
      "display_name": "ns2::AAAA",
      "id": "14858359049414529239",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "AAAA",
      "namespace": "clanguml::t00039::ns2",
      "source_location": {
        "column": 8,
        "file": "t00039.cc",
        "line": 31,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "ns3::F<T>",
      "id": "7646283164798158442",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "t",
          "source_location": {
            "column": 8,
            "file": "t00039.cc",
            "line": 40,
            "translation_unit": "t00039.cc"
          },
          "type": "T *"
        }
      ],
      "methods": [],
      "name": "F",
      "namespace": "clanguml::t00039::ns3",
      "source_location": {
        "column": 30,
        "file": "t00039.cc",
        "line": 39,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "7646283164798158442",
          "is_virtual": false
        }
      ],
      "display_name": "ns3::FF<T,M>",
      "id": "10575975104540250434",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "m",
          "source_location": {
            "column": 8,
            "file": "t00039.cc",
            "line": 44,
            "translation_unit": "t00039.cc"
          },
          "type": "M *"
        }
      ],
      "methods": [],
      "name": "FF",
      "namespace": "clanguml::t00039::ns3",
      "source_location": {
        "column": 42,
        "file": "t00039.cc",
        "line": 43,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "M",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "7646283164798158442",
          "is_virtual": false
        }
      ],
      "display_name": "ns3::FE<T,M>",
      "id": "16064445863049039396",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "m",
          "source_location": {
            "column": 8,
            "file": "t00039.cc",
            "line": 48,
            "translation_unit": "t00039.cc"
          },
          "type": "M *"
        }
      ],
      "methods": [],
      "name": "FE",
      "namespace": "clanguml::t00039::ns3",
      "source_location": {
        "column": 42,
        "file": "t00039.cc",
        "line": 47,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "M",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "10575975104540250434",
          "is_virtual": false
        }
      ],
      "display_name": "ns3::FFF<T,M,N>",
      "id": "12939646725895352313",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "n",
          "source_location": {
            "column": 8,
            "file": "t00039.cc",
            "line": 52,
            "translation_unit": "t00039.cc"
          },
          "type": "N *"
        }
      ],
      "methods": [],
      "name": "FFF",
      "namespace": "clanguml::t00039::ns3",
      "source_location": {
        "column": 54,
        "file": "t00039.cc",
        "line": 51,
        "translation_unit": "t00039.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "M",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "N",
          "template_parameters": []
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00039_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "1929879816262895494",
      "source": "6803868980223975432",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15801497117276934278",
      "source": "6803868980223975432",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15801497117276934278",
      "source": "10528178466429449283",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15673049474775122911",
      "source": "10528178466429449283",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "1929879816262895494",
      "source": "15019897156758195721",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15801497117276934278",
      "source": "15019897156758195721",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15673049474775122911",
      "source": "15019897156758195721",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "8409372207574078607",
      "source": "14095754188805440104",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "14095754188805440104",
      "source": "17267865950737182436",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "17267865950737182436",
      "source": "14858359049414529239",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "7646283164798158442",
      "source": "10575975104540250434",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "7646283164798158442",
      "source": "16064445863049039396",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "10575975104540250434",
      "source": "12939646725895352313",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00039"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00039</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L6</data>
   <data key="nd5">C</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L8</data>
   <data key="nd5">D</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L10</data>
   <data key="nd5">E</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[CD]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L16</data>
   <data key="nd5">CD</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[DE]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L18</data>
   <data key="nd5">DE</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[CDE]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L20</data>
   <data key="nd5">CDE</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L22</data>
   <data key="nd5">A</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L24</data>
   <data key="nd5">AA</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AAA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L26</data>
   <data key="nd5">AAA</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ns2::AAAA]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L31</data>
   <data key="nd5">AAAA</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ns3::F<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L39</data>
   <data key="nd5">F</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ns3::FF<T,M>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L43</data>
   <data key="nd5">FF</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ns3::FE<T,M>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L47</data>
   <data key="nd5">FE</data>
  </node>
  <node id="n13">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ns3::FFF<T,M,N>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00039/t00039.cc#L51</data>
   <data key="nd5">FFF</data>
  </node>
  <edge id="e0" source="n3" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n3" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n4" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n4" target="n2">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n5" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n5" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n5" target="n2">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n7" target="n6">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n8" target="n7">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n9" target="n8">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n11" target="n10">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n12" target="n10">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n13" target="n11">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
