# t00038 - Template instantiation with unexposed nested templates
## Config
```yaml
diagrams:
  t00038_class:
    type: class
    generate_packages: false
    glob:
      - t00038.cc
    using_namespace: clanguml::t00038
    include:
      namespaces:
        - clanguml::t00038
        - thirdparty::ns1
```
## Source code
File `tests/t00038/t00038.cc`
```cpp
#include <map>
#include <string>
#include <type_traits>
#include <vector>

namespace thirdparty {
namespace ns1 {
enum class color_t { red, green, blue };

struct E { };
} // namespace ns1
namespace ns2 {
struct F { };
} // namespace ns2
} // namespace thirdparty

namespace clanguml {
namespace t00038 {

enum class property_t { property_a, property_b, property_c };

struct A { };
struct B { };
struct C { };

struct key_t {
    std::string key;
};

template <typename T> struct map { };

using namespace thirdparty::ns1;

template <> struct map<std::integral_constant<color_t, color_t::red>> : E { };

template <>
struct map<std::integral_constant<clanguml::t00038::property_t,
    clanguml::t00038::property_t::property_a>> : A { };

template <>
struct map<std::vector<
    std::integral_constant<t00038::property_t, t00038::property_t::property_b>>>
    : B { };

template <>
struct map<std::map<key_t,
    std::vector<std::integral_constant<property_t, property_t::property_c>>>>
    : C { };

} // namespace t00038
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00038_class](./t00038_class.svg "Template instantiation with unexposed nested templates")
## Generated Mermaid diagrams
![t00038_class](./t00038_class_mermaid.svg "Template instantiation with unexposed nested templates")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "constants": [
        "red",
        "green",
        "blue"
      ],
      "display_name": "thirdparty::ns1::color_t",
      "id": "4534259198854950093",
      "is_nested": false,
      "name": "color_t",
      "namespace": "thirdparty::ns1",
      "source_location": {
        "column": 12,
        "file": "t00038.cc",
        "line": 8,
        "translation_unit": "t00038.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "thirdparty::ns1::E",
      "id": "13137781750087048118",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "thirdparty::ns1",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 10,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "property_a",
        "property_b",
        "property_c"
      ],
      "display_name": "property_t",
      "id": "59015610482086632",
      "is_nested": false,
      "name": "property_t",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 12,
        "file": "t00038.cc",
        "line": 20,
        "translation_unit": "t00038.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "6320323459313380897",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 22,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "10367760551260501522",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 23,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C",
      "id": "1236082894237447868",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 24,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "key_t",
      "id": "1097309469100232298",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "key",
          "source_location": {
            "column": 17,
            "file": "t00038.cc",
            "line": 27,
            "translation_unit": "t00038.cc"
          },
          "type": "std::string"
        }
      ],
      "methods": [],
      "name": "key_t",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 26,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "map<T>",
      "id": "15340485825059586404",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "map",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 30,
        "file": "t00038.cc",
        "line": 30,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "13137781750087048118",
          "is_virtual": false
        }
      ],
      "display_name": "map<std::integral_constant<thirdparty::ns1::color_t,thirdparty::ns1::color_t::red>>",
      "id": "13312176378487129629",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "map",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 20,
        "file": "t00038.cc",
        "line": 34,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "thirdparty::ns1::color_t"
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "thirdparty::ns1::color_t::red"
            }
          ],
          "type": "std::integral_constant"
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "6320323459313380897",
          "is_virtual": false
        }
      ],
      "display_name": "map<std::integral_constant<property_t,property_t::property_a>>",
      "id": "2461606408364286670",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "map",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 37,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "clanguml::t00038::property_t"
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "clanguml::t00038::property_t::property_a"
            }
          ],
          "type": "std::integral_constant"
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "10367760551260501522",
          "is_virtual": false
        }
      ],
      "display_name": "map<std::vector<std::integral_constant<property_t,property_t::property_b>>>",
      "id": "4385852227339873533",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "map",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 41,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "clanguml::t00038::property_t"
                },
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "clanguml::t00038::property_t::property_b"
                }
              ],
              "type": "std::integral_constant"
            }
          ],
          "type": "std::vector"
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "1236082894237447868",
          "is_virtual": false
        }
      ],
      "display_name": "map<std::map<key_t,std::vector<std::integral_constant<property_t,property_t::property_c>>>>",
      "id": "12081603216949648046",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "map",
      "namespace": "clanguml::t00038",
      "source_location": {
        "column": 8,
        "file": "t00038.cc",
        "line": 46,
        "translation_unit": "t00038.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "clanguml::t00038::key_t"
            },
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [
                    {
                      "is_variadic": false,
                      "kind": "argument",
                      "template_parameters": [],
                      "type": "clanguml::t00038::property_t"
                    },
                    {
                      "is_variadic": false,
                      "kind": "argument",
                      "template_parameters": [],
                      "type": "clanguml::t00038::property_t::property_c"
                    }
                  ],
                  "type": "std::integral_constant"
                }
              ],
              "type": "std::vector"
            }
          ],
          "type": "std::map"
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00038_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "4534259198854950093",
      "source": "13312176378487129629",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "15340485825059586404",
      "source": "13312176378487129629",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13137781750087048118",
      "source": "13312176378487129629",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "59015610482086632",
      "source": "2461606408364286670",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "15340485825059586404",
      "source": "2461606408364286670",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "6320323459313380897",
      "source": "2461606408364286670",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "59015610482086632",
      "source": "4385852227339873533",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "15340485825059586404",
      "source": "4385852227339873533",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "10367760551260501522",
      "source": "4385852227339873533",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "1097309469100232298",
      "source": "12081603216949648046",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "59015610482086632",
      "source": "12081603216949648046",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "15340485825059586404",
      "source": "12081603216949648046",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "1236082894237447868",
      "source": "12081603216949648046",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00038"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00038</data>
  <node id="n0">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[thirdparty::ns1::color_t]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L8</data>
   <data key="nd5">color_t</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[thirdparty::ns1::E]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L10</data>
   <data key="nd5">E</data>
  </node>
  <node id="n2">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[property_t]]></data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L20</data>
   <data key="nd5">property_t</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L22</data>
   <data key="nd5">A</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L23</data>
   <data key="nd5">B</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L24</data>
   <data key="nd5">C</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[key_t]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L26</data>
   <data key="nd5">key_t</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[map<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L30</data>
   <data key="nd5">map</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[map<std::integral_constant<thirdparty::ns1::color_t,thirdparty::ns1::color_t::red>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L34</data>
   <data key="nd5">map</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[map<std::integral_constant<property_t,property_t::property_a>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L37</data>
   <data key="nd5">map</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[map<std::vector<std::integral_constant<property_t,property_t::property_b>>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L41</data>
   <data key="nd5">map</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[map<std::map<key_t,std::vector<std::integral_constant<property_t,property_t::property_c>>>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00038/t00038.cc#L46</data>
   <data key="nd5">map</data>
  </node>
  <edge id="e0" source="n8" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n8" target="n7">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n8" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n9" target="n2">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n9" target="n7">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n9" target="n3">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n10" target="n2">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n10" target="n7">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n10" target="n4">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n11" target="n6">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n11" target="n2">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n11" target="n7">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n11" target="n5">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
