# t00036 - Class diagram with namespaces generated as packages
## Config
```yaml
diagrams:
  t00036_class:
    type: class
    generate_packages: true
    glob:
      - t00036.cc
    using_namespace: clanguml::t00036
    include:
      namespaces:
        - clanguml::t00036
    exclude:
      subclasses:
        - clanguml::t00036::ns2::ns22::D
```
## Source code
File `tests/t00036/t00036.cc`
```cpp
namespace clanguml {
namespace t00036 {

namespace ns1 {

enum class E { blue, yellow };

namespace ns11 {

template <typename T> struct A {
    T a;
};

namespace ns111 {

struct B {
    A<int> a_int;
};

} // namespace ns111
} // namespace ns11
} // namespace ns1

namespace ns2 {
namespace ns22 {

// TODO: Fix for incomplete struct C declaration "struct C;"
struct C { };

struct D { };

} // namespace ns22
} // namespace ns2

namespace ns3 {
namespace ns33 {
namespace detail {
struct DImpl : public ns2::ns22::D { };
}
} // namespace ns33
} // namespace ns3

} // namespace t00036
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00036_class](./t00036_class.svg "Class diagram with namespaces generated as packages")
## Generated Mermaid diagrams
![t00036_class](./t00036_class_mermaid.svg "Class diagram with namespaces generated as packages")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "display_name": "ns1",
      "elements": [
        {
          "constants": [
            "blue",
            "yellow"
          ],
          "display_name": "E",
          "id": "17158095624393267824",
          "is_nested": false,
          "name": "E",
          "namespace": "clanguml::t00036::ns1",
          "source_location": {
            "column": 12,
            "file": "t00036.cc",
            "line": 6,
            "translation_unit": "t00036.cc"
          },
          "type": "enum"
        },
        {
          "display_name": "ns11",
          "elements": [
            {
              "bases": [],
              "display_name": "A<T>",
              "id": "4572586445217559573",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": true,
              "is_union": false,
              "members": [
                {
                  "access": "public",
                  "is_static": false,
                  "name": "a",
                  "source_location": {
                    "column": 7,
                    "file": "t00036.cc",
                    "line": 11,
                    "translation_unit": "t00036.cc"
                  },
                  "type": "T"
                }
              ],
              "methods": [],
              "name": "A",
              "namespace": "clanguml::t00036::ns1::ns11",
              "source_location": {
                "column": 30,
                "file": "t00036.cc",
                "line": 10,
                "translation_unit": "t00036.cc"
              },
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "template_type",
                  "name": "T",
                  "template_parameters": []
                }
              ],
              "type": "class"
            },
            {
              "display_name": "ns111",
              "elements": [
                {
                  "bases": [],
                  "display_name": "B",
                  "id": "15712255468508859011",
                  "is_abstract": false,
                  "is_nested": false,
                  "is_struct": true,
                  "is_template": false,
                  "is_union": false,
                  "members": [
                    {
                      "access": "public",
                      "is_static": false,
                      "name": "a_int",
                      "source_location": {
                        "column": 12,
                        "file": "t00036.cc",
                        "line": 17,
                        "translation_unit": "t00036.cc"
                      },
                      "type": "A<int>"
                    }
                  ],
                  "methods": [],
                  "name": "B",
                  "namespace": "clanguml::t00036::ns1::ns11::ns111",
                  "source_location": {
                    "column": 8,
                    "file": "t00036.cc",
                    "line": 16,
                    "translation_unit": "t00036.cc"
                  },
                  "template_parameters": [],
                  "type": "class"
                }
              ],
              "name": "ns111",
              "type": "namespace"
            },
            {
              "bases": [],
              "display_name": "A<int>",
              "id": "14661683419698558378",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": true,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "A",
              "namespace": "clanguml::t00036::ns1::ns11",
              "source_location": {
                "column": 30,
                "file": "t00036.cc",
                "line": 10,
                "translation_unit": "t00036.cc"
              },
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "int"
                }
              ],
              "type": "class"
            }
          ],
          "name": "ns11",
          "type": "namespace"
        }
      ],
      "name": "ns1",
      "type": "namespace"
    },
    {
      "display_name": "ns2",
      "elements": [
        {
          "display_name": "ns22",
          "elements": [
            {
              "bases": [],
              "display_name": "C",
              "id": "16311655056529324727",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "C",
              "namespace": "clanguml::t00036::ns2::ns22",
              "source_location": {
                "column": 8,
                "file": "t00036.cc",
                "line": 28,
                "translation_unit": "t00036.cc"
              },
              "template_parameters": [],
              "type": "class"
            }
          ],
          "name": "ns22",
          "type": "namespace"
        }
      ],
      "name": "ns2",
      "type": "namespace"
    }
  ],
  "name": "t00036_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "14661683419698558378",
      "label": "a_int",
      "source": "15712255468508859011",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "4572586445217559573",
      "source": "14661683419698558378",
      "type": "instantiation"
    }
  ],
  "using_namespace": "clanguml::t00036"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00036</data>
  <node id="n0">
   <data key="nd2">ns1</data>
   <data key="nd1">namespace</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd1">enum</data>
     <data key="nd2"><![CDATA[E]]></data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00036/t00036.cc#L6</data>
     <data key="nd5">E</data>
    </node>
    <node id="n2">
     <data key="nd2">ns11</data>
     <data key="nd1">namespace</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n3">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[A<T>]]></data>
       <data key="nd6">true</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00036/t00036.cc#L10</data>
       <data key="nd5">A</data>
      </node>
      <node id="n4">
       <data key="nd2">ns111</data>
       <data key="nd1">namespace</data>
       <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
        <node id="n5">
         <data key="nd1">class</data>
         <data key="nd2"><![CDATA[B]]></data>
         <data key="nd6">false</data>
         <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00036/t00036.cc#L16</data>
         <data key="nd5">B</data>
        </node>
       </graph>
      </node>
      <node id="n6">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[A<int>]]></data>
       <data key="nd6">true</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00036/t00036.cc#L10</data>
       <data key="nd5">A</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <node id="n7">
   <data key="nd2">ns2</data>
   <data key="nd1">namespace</data>
   <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n8">
     <data key="nd2">ns22</data>
     <data key="nd1">namespace</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n9">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[C]]></data>
       <data key="nd6">false</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00036/t00036.cc#L28</data>
       <data key="nd5">C</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <edge id="e0" source="n6" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n5" target="n6">
   <data key="ed0">aggregation</data>
   <data key="ed2">a_int</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
