# t00034 - Template metaprogramming type function test case
## Config
```yaml
diagrams:
  t00034_class:
    type: class
    glob:
      - t00034.cc
    using_namespace: clanguml::t00034
    include:
      namespaces:
        - clanguml::t00034
    plantuml:
      after:
        - "@A(R) --> @A(A) : +la"

```
## Source code
File `tests/t00034/t00034.cc`
```cpp
#include <type_traits>

namespace clanguml {
//
// Based on https://github.com/facebook/folly/blob/master/folly/Unit.h
//
namespace t00034 {

struct Void {
    constexpr bool operator==(const Void & /* unused */) const { return true; }
    constexpr bool operator!=(const Void & /* unused */) const { return false; }
};

constexpr Void void_t{};

template <typename T> struct lift_void {
    using type = T;
};

template <> struct lift_void<void> {
    using type = Void;
};

//
// TODO: This is a shortcoming of libclang which parses the type of lift_void_t
// alias as unexposed, i.e. no actual reference to T can be inferred without
// manually parsing the string 'typename lift_void<T>::type'
// For now, this test validates that the visitor does not crash, the reference
// between R and A has to be provided in the configuration file
//
template <typename T> using lift_void_t = typename lift_void<T>::type;

template <typename T> struct drop_void {
    using type = T;
};

template <> struct drop_void<Void> {
    using type = void;
};

template <typename T> using drop_void_t = typename drop_void<T>::type;

struct A { };

struct R {
    lift_void_t<A> *la;
    lift_void_t<void> *lv;
};

} // namespace t00034
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00034_class](./t00034_class.svg "Template metaprogramming type function test case")
## Generated Mermaid diagrams
![t00034_class](./t00034_class_mermaid.svg "Template metaprogramming type function test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "Void",
      "id": "13635651921686985707",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "operator==",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": true,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "operator==",
          "parameters": [
            {
              "name": "",
              "type": "const Void &"
            }
          ],
          "source_location": {
            "column": 20,
            "file": "t00034.cc",
            "line": 10,
            "translation_unit": "t00034.cc"
          },
          "template_parameters": [],
          "type": "bool"
        },
        {
          "access": "public",
          "display_name": "operator!=",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": true,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "operator!=",
          "parameters": [
            {
              "name": "",
              "type": "const Void &"
            }
          ],
          "source_location": {
            "column": 20,
            "file": "t00034.cc",
            "line": 11,
            "translation_unit": "t00034.cc"
          },
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "name": "Void",
      "namespace": "clanguml::t00034",
      "source_location": {
        "column": 8,
        "file": "t00034.cc",
        "line": 9,
        "translation_unit": "t00034.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "lift_void<T>",
      "id": "6939779543973482532",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "lift_void",
      "namespace": "clanguml::t00034",
      "source_location": {
        "column": 30,
        "file": "t00034.cc",
        "line": 16,
        "translation_unit": "t00034.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "lift_void<void>",
      "id": "1011606897809577916",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "lift_void",
      "namespace": "clanguml::t00034",
      "source_location": {
        "column": 20,
        "file": "t00034.cc",
        "line": 20,
        "translation_unit": "t00034.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "void"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "drop_void<T>",
      "id": "12629966528802701651",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "drop_void",
      "namespace": "clanguml::t00034",
      "source_location": {
        "column": 30,
        "file": "t00034.cc",
        "line": 33,
        "translation_unit": "t00034.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "drop_void<Void>",
      "id": "14798689076032600924",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "drop_void",
      "namespace": "clanguml::t00034",
      "source_location": {
        "column": 20,
        "file": "t00034.cc",
        "line": 37,
        "translation_unit": "t00034.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "Void"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "11071303263077510616",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00034",
      "source_location": {
        "column": 8,
        "file": "t00034.cc",
        "line": 43,
        "translation_unit": "t00034.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "13711933885930122474",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "la",
          "source_location": {
            "column": 21,
            "file": "t00034.cc",
            "line": 46,
            "translation_unit": "t00034.cc"
          },
          "type": "lift_void_t<A> *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "lv",
          "source_location": {
            "column": 24,
            "file": "t00034.cc",
            "line": 47,
            "translation_unit": "t00034.cc"
          },
          "type": "lift_void_t<void> *"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00034",
      "source_location": {
        "column": 8,
        "file": "t00034.cc",
        "line": 45,
        "translation_unit": "t00034.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00034_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "6939779543973482532",
      "source": "1011606897809577916",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13635651921686985707",
      "source": "14798689076032600924",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "12629966528802701651",
      "source": "14798689076032600924",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "11071303263077510616",
      "label": "la",
      "source": "13711933885930122474",
      "type": "association"
    }
  ],
  "using_namespace": "clanguml::t00034"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00034</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Void]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00034/t00034.cc#L9</data>
   <data key="nd5">Void</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[lift_void<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00034/t00034.cc#L16</data>
   <data key="nd5">lift_void</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[lift_void<void>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00034/t00034.cc#L20</data>
   <data key="nd5">lift_void</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[drop_void<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00034/t00034.cc#L33</data>
   <data key="nd5">drop_void</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[drop_void<Void>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00034/t00034.cc#L37</data>
   <data key="nd5">drop_void</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00034/t00034.cc#L43</data>
   <data key="nd5">A</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00034/t00034.cc#L45</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n2" target="n1">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n4" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n4" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n6" target="n5">
   <data key="ed0">association</data>
   <data key="ed2">la</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
