# t00022 - Template method pattern
## Config
```yaml
diagrams:
  t00022_class:
    type: class
    glob:
      - t00022.cc
    using_namespace: clanguml::t00022
    include:
      namespaces:
        - clanguml::t00022

```
## Source code
File `tests/t00022/t00022.cc`
```cpp
#include <memory>

namespace clanguml {
namespace t00022 {

class A {
public:
    void template_method()
    {
        method1();
        method2();
    }

protected:
    virtual void method1() = 0;
    virtual void method2() = 0;
};

class A1 : public A {
protected:
    void method1() override { }
    void method2() override { }
};

class A2 : public A {
protected:
    void method1() override { }
    void method2() override { }
};
} // namespace t00022
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00022_class](./t00022_class.svg "Template method pattern")
## Generated Mermaid diagrams
![t00022_class](./t00022_class_mermaid.svg "Template method pattern")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "16099487147056550046",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "template_method",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "template_method",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00022.cc",
            "line": 8,
            "translation_unit": "t00022.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "protected",
          "display_name": "method1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "method1",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00022.cc",
            "line": 15,
            "translation_unit": "t00022.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "protected",
          "display_name": "method2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "method2",
          "parameters": [],
          "source_location": {
            "column": 18,
            "file": "t00022.cc",
            "line": 16,
            "translation_unit": "t00022.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00022",
      "source_location": {
        "column": 7,
        "file": "t00022.cc",
        "line": 6,
        "translation_unit": "t00022.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "16099487147056550046",
          "is_virtual": false
        }
      ],
      "display_name": "A1",
      "id": "18256491411048619579",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "protected",
          "display_name": "method1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "method1",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00022.cc",
            "line": 21,
            "translation_unit": "t00022.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "protected",
          "display_name": "method2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "method2",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00022.cc",
            "line": 22,
            "translation_unit": "t00022.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A1",
      "namespace": "clanguml::t00022",
      "source_location": {
        "column": 7,
        "file": "t00022.cc",
        "line": 19,
        "translation_unit": "t00022.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "16099487147056550046",
          "is_virtual": false
        }
      ],
      "display_name": "A2",
      "id": "1270558903333372307",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "protected",
          "display_name": "method1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "method1",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00022.cc",
            "line": 27,
            "translation_unit": "t00022.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "protected",
          "display_name": "method2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "method2",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00022.cc",
            "line": 28,
            "translation_unit": "t00022.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A2",
      "namespace": "clanguml::t00022",
      "source_location": {
        "column": 7,
        "file": "t00022.cc",
        "line": 25,
        "translation_unit": "t00022.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00022_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "16099487147056550046",
      "source": "18256491411048619579",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "16099487147056550046",
      "source": "1270558903333372307",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00022"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00022</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00022/t00022.cc#L6</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A1]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00022/t00022.cc#L19</data>
   <data key="nd5">A1</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A2]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00022/t00022.cc#L25</data>
   <data key="nd5">A2</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
