# t00020 - Abstract factory pattern
## Config
```yaml
diagrams:
  t00020_class:
    type: class
    glob:
      - t00020.cc
    using_namespace: clanguml::t00020
    include:
      namespaces:
        - clanguml::t00020
    plantuml:
      after:
        - '@A(Factory1) ..> @A(ProductA1)'
        - '@A(Factory1) ..> @A(ProductB1)'
        - '{{ alias("Factory2") }} ..> {{ alias("ProductA2") }}'
        - '{{ alias("Factory2") }} ..> {{ alias("ProductB2") }}'
    mermaid:
      after:
        - '@A(Factory1) ..> @A(ProductA1)'
        - '@A(Factory1) ..> @A(ProductB1)'
        - '{{ alias("Factory2") }} ..> {{ alias("ProductA2") }}'
        - '{{ alias("Factory2") }} ..> {{ alias("ProductB2") }}'
```
## Source code
File `tests/t00020/t00020.cc`
```cpp
#include <memory>

namespace clanguml {
namespace t00020 {

class ProductA {
public:
    virtual ~ProductA() = default;
    virtual bool sell(int price) const = 0;
};

class ProductA1 : public ProductA {
public:
    bool sell(int price) const override { return price > 1000; }
};

class ProductA2 : public ProductA {
public:
    bool sell(int price) const override { return price > 2000; }
};

class ProductB {
public:
    virtual ~ProductB() = default;
    virtual bool buy(int price) const = 0;
};

class ProductB1 : public ProductB {
public:
    bool buy(int price) const override { return price < 1000; }
};

class ProductB2 : public ProductB {
public:
    bool buy(int price) const override { return price < 2000; }
};

class AbstractFactory {
public:
    virtual std::unique_ptr<ProductA> make_a() const = 0;
    virtual std::unique_ptr<ProductB> make_b() const = 0;
};

class Factory1 : public AbstractFactory {
public:
    std::unique_ptr<ProductA> make_a() const override
    {
        return std::make_unique<ProductA1>();
    }

    std::unique_ptr<ProductB> make_b() const override
    {
        return std::make_unique<ProductB1>();
    }
};

class Factory2 : public AbstractFactory {
public:
    std::unique_ptr<ProductA> make_a() const override
    {
        return std::make_unique<ProductA2>();
    }

    std::unique_ptr<ProductB> make_b() const override
    {
        return std::make_unique<ProductB2>();
    }
};
} // namespace t00020
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00020_class](./t00020_class.svg "Abstract factory pattern")
## Generated Mermaid diagrams
![t00020_class](./t00020_class_mermaid.svg "Abstract factory pattern")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "ProductA",
      "id": "3402137837275719558",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "~ProductA",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "~ProductA",
          "parameters": [],
          "source_location": {
            "column": 13,
            "file": "t00020.cc",
            "line": 8,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "sell",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "sell",
          "parameters": [
            {
              "name": "price",
              "type": "int"
            }
          ],
          "source_location": {
            "column": 18,
            "file": "t00020.cc",
            "line": 9,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "name": "ProductA",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 6,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "3402137837275719558",
          "is_virtual": false
        }
      ],
      "display_name": "ProductA1",
      "id": "14051968238382913662",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "sell",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "sell",
          "parameters": [
            {
              "name": "price",
              "type": "int"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00020.cc",
            "line": 14,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "name": "ProductA1",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 12,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "3402137837275719558",
          "is_virtual": false
        }
      ],
      "display_name": "ProductA2",
      "id": "12253668743081735855",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "sell",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "sell",
          "parameters": [
            {
              "name": "price",
              "type": "int"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00020.cc",
            "line": 19,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "name": "ProductA2",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 17,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "ProductB",
      "id": "17886072050998926742",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "~ProductB",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "~ProductB",
          "parameters": [],
          "source_location": {
            "column": 13,
            "file": "t00020.cc",
            "line": 24,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "buy",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "buy",
          "parameters": [
            {
              "name": "price",
              "type": "int"
            }
          ],
          "source_location": {
            "column": 18,
            "file": "t00020.cc",
            "line": 25,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "name": "ProductB",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 22,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "17886072050998926742",
          "is_virtual": false
        }
      ],
      "display_name": "ProductB1",
      "id": "11723944193865790765",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "buy",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "buy",
          "parameters": [
            {
              "name": "price",
              "type": "int"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00020.cc",
            "line": 30,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "name": "ProductB1",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 28,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "17886072050998926742",
          "is_virtual": false
        }
      ],
      "display_name": "ProductB2",
      "id": "17237324498960462969",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "buy",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "buy",
          "parameters": [
            {
              "name": "price",
              "type": "int"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00020.cc",
            "line": 35,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "name": "ProductB2",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 33,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "AbstractFactory",
      "id": "13644371753751691404",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "make_a",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "make_a",
          "parameters": [],
          "source_location": {
            "column": 39,
            "file": "t00020.cc",
            "line": 40,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "std::unique_ptr<ProductA>"
        },
        {
          "access": "public",
          "display_name": "make_b",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "make_b",
          "parameters": [],
          "source_location": {
            "column": 39,
            "file": "t00020.cc",
            "line": 41,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "std::unique_ptr<ProductB>"
        }
      ],
      "name": "AbstractFactory",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 38,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "13644371753751691404",
          "is_virtual": false
        }
      ],
      "display_name": "Factory1",
      "id": "5538774787878832856",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "make_a",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "make_a",
          "parameters": [],
          "source_location": {
            "column": 31,
            "file": "t00020.cc",
            "line": 46,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "std::unique_ptr<ProductA>"
        },
        {
          "access": "public",
          "display_name": "make_b",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "make_b",
          "parameters": [],
          "source_location": {
            "column": 31,
            "file": "t00020.cc",
            "line": 51,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "std::unique_ptr<ProductB>"
        }
      ],
      "name": "Factory1",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 44,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "13644371753751691404",
          "is_virtual": false
        }
      ],
      "display_name": "Factory2",
      "id": "12530606966440104191",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "make_a",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "make_a",
          "parameters": [],
          "source_location": {
            "column": 31,
            "file": "t00020.cc",
            "line": 59,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "std::unique_ptr<ProductA>"
        },
        {
          "access": "public",
          "display_name": "make_b",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "make_b",
          "parameters": [],
          "source_location": {
            "column": 31,
            "file": "t00020.cc",
            "line": 64,
            "translation_unit": "t00020.cc"
          },
          "template_parameters": [],
          "type": "std::unique_ptr<ProductB>"
        }
      ],
      "name": "Factory2",
      "namespace": "clanguml::t00020",
      "source_location": {
        "column": 7,
        "file": "t00020.cc",
        "line": 57,
        "translation_unit": "t00020.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00020_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "3402137837275719558",
      "source": "14051968238382913662",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "3402137837275719558",
      "source": "12253668743081735855",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "17886072050998926742",
      "source": "11723944193865790765",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "17886072050998926742",
      "source": "17237324498960462969",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "3402137837275719558",
      "source": "13644371753751691404",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "17886072050998926742",
      "source": "13644371753751691404",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "3402137837275719558",
      "source": "5538774787878832856",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "17886072050998926742",
      "source": "5538774787878832856",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "13644371753751691404",
      "source": "5538774787878832856",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "3402137837275719558",
      "source": "12530606966440104191",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "17886072050998926742",
      "source": "12530606966440104191",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "13644371753751691404",
      "source": "12530606966440104191",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00020"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00020</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ProductA]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L6</data>
   <data key="nd5">ProductA</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ProductA1]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L12</data>
   <data key="nd5">ProductA1</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ProductA2]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L17</data>
   <data key="nd5">ProductA2</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ProductB]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L22</data>
   <data key="nd5">ProductB</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ProductB1]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L28</data>
   <data key="nd5">ProductB1</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[ProductB2]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L33</data>
   <data key="nd5">ProductB2</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AbstractFactory]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L38</data>
   <data key="nd5">AbstractFactory</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Factory1]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L44</data>
   <data key="nd5">Factory1</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Factory2]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00020/t00020.cc#L57</data>
   <data key="nd5">Factory2</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n4" target="n3">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n3">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n6" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n6" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n7" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n7" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n7" target="n6">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n8" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n8" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n8" target="n6">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
