# t00019 - Layercake pattern
## Config
```yaml
diagrams:
  t00019_class:
    type: class
    glob:
      - "*.cc"
    generate_template_argument_dependencies: false
    using_namespace: clanguml::t00019
    plantuml:
      style:
        instantiation: up
    include:
      namespaces:
        - clanguml::t00019

```
## Source code
File `tests/t00019/t00019_layer1.h`
```cpp
#pragma once

#include <iostream>
#include <string>

namespace clanguml {
namespace t00019 {

template <typename LowerLayer> class Layer1 : public LowerLayer {

    using LowerLayer::LowerLayer;

    int m1() override
    {
        std::cout << "m1 called\n";
        return LowerLayer::m1();
    }

    std::string m2() override
    {
        std::cout << "m2 called\n";
        return LowerLayer::m2();
    }
};
}
}

```
File `tests/t00019/t00019.cc`
```cpp
#include "t00019_base.h"
#include "t00019_layer1.h"
#include "t00019_layer2.h"
#include "t00019_layer3.h"

#include <memory>

namespace clanguml {
namespace t00019 {

class A {
public:
    std::unique_ptr<Layer1<Layer2<Layer3<Base>>>> layers;
};
}
}

```
File `tests/t00019/t00019_layer2.h`
```cpp
#pragma once

namespace clanguml {
namespace t00019 {

template <typename LowerLayer> class Layer2 : public LowerLayer {

    using LowerLayer::LowerLayer;

    using LowerLayer::m1;

    using LowerLayer::m2;

    int all_calls_count() const
    {
        return LowerLayer::m1_calls() + LowerLayer::m2_calls();
    }
};
}
}

```
File `tests/t00019/t00019_layer3.h`
```cpp
#pragma once

#include <string>

namespace clanguml {
namespace t00019 {

template <typename LowerLayer> class Layer3 : public LowerLayer {

    using LowerLayer::LowerLayer;

    virtual int m1() override
    {
        m_m1_calls++;
        return LowerLayer::m1();
    }

    virtual std::string m2() override
    {
        m_m2_calls++;
        return LowerLayer::m2();
    }

    int m1_calls() const { return m_m1_calls; }

    int m2_calls() const { return m_m2_calls; }

private:
    int m_m1_calls{};
    int m_m2_calls{};
};
}
}

```
File `tests/t00019/t00019_base.h`
```cpp
#pragma once

#include <string>

namespace clanguml {
namespace t00019 {

class Base {

    Base() = default;

    virtual ~Base() = default;

    virtual int m1() { return 2; }

    virtual std::string m2() { return "two"; }
};
}
}

```
## Generated PlantUML diagrams
![t00019_class](./t00019_class.svg "Layercake pattern")
## Generated Mermaid diagrams
![t00019_class](./t00019_class_mermaid.svg "Layercake pattern")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "Base",
      "id": "2093347899813072991",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "private",
          "display_name": "Base",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": true,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "Base",
          "parameters": [],
          "source_location": {
            "column": 5,
            "file": "t00019_base.h",
            "line": 10,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "private",
          "display_name": "~Base",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "~Base",
          "parameters": [],
          "source_location": {
            "column": 13,
            "file": "t00019_base.h",
            "line": 12,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "private",
          "display_name": "m1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m1",
          "parameters": [],
          "source_location": {
            "column": 17,
            "file": "t00019_base.h",
            "line": 14,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "private",
          "display_name": "m2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m2",
          "parameters": [],
          "source_location": {
            "column": 25,
            "file": "t00019_base.h",
            "line": 16,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "name": "Base",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 7,
        "file": "t00019_base.h",
        "line": 8,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Layer1<LowerLayer>",
      "id": "7221050388300154171",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "private",
          "display_name": "m1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "m1",
          "parameters": [],
          "source_location": {
            "column": 9,
            "file": "t00019_layer1.h",
            "line": 13,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "private",
          "display_name": "m2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "m2",
          "parameters": [],
          "source_location": {
            "column": 17,
            "file": "t00019_layer1.h",
            "line": 19,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "name": "Layer1",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 38,
        "file": "t00019_layer1.h",
        "line": 9,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "LowerLayer",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Layer2<LowerLayer>",
      "id": "8921207402420645183",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "private",
          "display_name": "all_calls_count",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "all_calls_count",
          "parameters": [],
          "source_location": {
            "column": 9,
            "file": "t00019_layer2.h",
            "line": 14,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "int"
        }
      ],
      "name": "Layer2",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 38,
        "file": "t00019_layer2.h",
        "line": 6,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "LowerLayer",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Layer3<LowerLayer>",
      "id": "14827284480590839565",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "m_m1_calls",
          "source_location": {
            "column": 9,
            "file": "t00019_layer3.h",
            "line": 29,
            "translation_unit": "t00019.cc"
          },
          "type": "int"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "m_m2_calls",
          "source_location": {
            "column": 9,
            "file": "t00019_layer3.h",
            "line": 30,
            "translation_unit": "t00019.cc"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "private",
          "display_name": "m1",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m1",
          "parameters": [],
          "source_location": {
            "column": 17,
            "file": "t00019_layer3.h",
            "line": 12,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "private",
          "display_name": "m2",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "m2",
          "parameters": [],
          "source_location": {
            "column": 25,
            "file": "t00019_layer3.h",
            "line": 18,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "std::string"
        },
        {
          "access": "private",
          "display_name": "m1_calls",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "m1_calls",
          "parameters": [],
          "source_location": {
            "column": 9,
            "file": "t00019_layer3.h",
            "line": 24,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "int"
        },
        {
          "access": "private",
          "display_name": "m2_calls",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "m2_calls",
          "parameters": [],
          "source_location": {
            "column": 9,
            "file": "t00019_layer3.h",
            "line": 26,
            "translation_unit": "t00019.cc"
          },
          "template_parameters": [],
          "type": "int"
        }
      ],
      "name": "Layer3",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 38,
        "file": "t00019_layer3.h",
        "line": 8,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "LowerLayer",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "2093347899813072991",
          "is_virtual": false
        }
      ],
      "display_name": "Layer3<Base>",
      "id": "7783123365946242556",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Layer3",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 11,
        "file": "",
        "line": 271,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "Base"
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "7783123365946242556",
          "is_virtual": false
        }
      ],
      "display_name": "Layer2<Layer3<Base>>",
      "id": "1038279998935990962",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Layer2",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 11,
        "file": "",
        "line": 271,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "clanguml::t00019::Base"
            }
          ],
          "type": "Layer3"
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "1038279998935990962",
          "is_virtual": false
        }
      ],
      "display_name": "Layer1<Layer2<Layer3<Base>>>",
      "id": "5272608466605309667",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Layer1",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 11,
        "file": "",
        "line": 271,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "clanguml::t00019::Base"
                }
              ],
              "type": "clanguml::t00019::Layer3"
            }
          ],
          "type": "Layer2"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "8121319990296713582",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "layers",
          "source_location": {
            "column": 51,
            "file": "t00019.cc",
            "line": 13,
            "translation_unit": "t00019.cc"
          },
          "type": "std::unique_ptr<Layer1<Layer2<Layer3<Base>>>>"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00019",
      "source_location": {
        "column": 7,
        "file": "t00019.cc",
        "line": 11,
        "translation_unit": "t00019.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00019_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "2093347899813072991",
      "source": "7783123365946242556",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "14827284480590839565",
      "source": "7783123365946242556",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "7783123365946242556",
      "source": "1038279998935990962",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "8921207402420645183",
      "source": "1038279998935990962",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "1038279998935990962",
      "source": "5272608466605309667",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "7221050388300154171",
      "source": "5272608466605309667",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "5272608466605309667",
      "label": "layers",
      "source": "8121319990296713582",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00019"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00019</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Base]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00019/t00019_base.h#L8</data>
   <data key="nd5">Base</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Layer1<LowerLayer>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00019/t00019_layer1.h#L9</data>
   <data key="nd5">Layer1</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Layer2<LowerLayer>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00019/t00019_layer2.h#L6</data>
   <data key="nd5">Layer2</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Layer3<LowerLayer>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00019/t00019_layer3.h#L8</data>
   <data key="nd5">Layer3</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Layer3<Base>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Layer2<Layer3<Base>>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Layer1<Layer2<Layer3<Base>>>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00019/t00019.cc#L11</data>
   <data key="nd5">A</data>
  </node>
  <edge id="e0" source="n4" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n4" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n5" target="n4">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n6" target="n5">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n6" target="n1">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n7" target="n6">
   <data key="ed0">aggregation</data>
   <data key="ed2">layers</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
