# t00014 - Alias template instantiation
## Config
```yaml
diagrams:
  t00014_class:
    type: class
    glob:
      - t00014.cc
    using_namespace: clanguml::t00014
    include:
      namespaces:
        - clanguml::t00014
    plantuml:
      before:
        - left to right direction
    mermaid:
      before:
        - direction LR
```
## Source code
File `tests/t00014/t00014.cc`
```cpp
#include <functional>
#include <map>
#include <memory>
#include <string>
#include <variant>
#include <vector>

/**
 * These should not be include as they are not
 * in ns clanguml::t00014
 */
template <typename T> struct clanguml_t00014_A {
    T value;
};

using clanguml_t00014_AString = clanguml_t00014_A<std::string>;

namespace clanguml {
namespace t00014 {

template <typename T, typename P> struct A {
    T t;
    P p;
};

struct B {
    std::string value;
};

template <typename T> using AString = A<T, std::string>;
template <typename T> using AStringPtr = A<T, std::unique_ptr<std::string>>;

template <typename T>
using PairPairBA = std::pair<std::pair<B, A<long, T>>, long>;

template <class T> using VectorPtr = std::unique_ptr<std::vector<T>>;
template <class T> using APtr = std::unique_ptr<A<double, T>>;
template <class T> using ASharedPtr = std::shared_ptr<A<double, T>>;

template <class T, class U>
using AAPtr = std::unique_ptr<std::pair<A<double, T>, A<long, U>>>;

template <typename T> using SimpleCallback = std::function<void(T, int)>;
template <typename... T> using GenericCallback = std::function<void(T..., int)>;
using VoidCallback = GenericCallback<void *>;

using BVector = std::vector<B>;
using BVector2 = BVector;

using AIntString = AString<int>;
using ACharString = AString<char>;

using AStringString = AString<std::string>;
using BStringString = AStringString;

template <typename T> class R {
    using AWCharString = AString<wchar_t>;

    PairPairBA<bool> bapair;

    APtr<bool> abool;
    AAPtr<bool, float> aboolfloat;
    ASharedPtr<float> afloat;
    A<bool, std::string> boolstring;
    AStringPtr<float> floatstring;
    AIntString intstring;
    AStringString stringstring;
    BStringString bstringstring;
    AAPtr<T, float> atfloat;

protected:
    BVector bs;

public:
    BVector2 bs2;
    SimpleCallback<ACharString> cb;
    GenericCallback<AWCharString> gcb;
    VoidCallback vcb;
    VectorPtr<B> vps;
};
} // namespace t00014
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00014_class](./t00014_class.svg "Alias template instantiation")
## Generated Mermaid diagrams
![t00014_class](./t00014_class_mermaid.svg "Alias template instantiation")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A<T,P>",
      "id": "6127124633338685220",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "t",
          "source_location": {
            "column": 7,
            "file": "t00014.cc",
            "line": 22,
            "translation_unit": "t00014.cc"
          },
          "type": "T"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "p",
          "source_location": {
            "column": 7,
            "file": "t00014.cc",
            "line": 23,
            "translation_unit": "t00014.cc"
          },
          "type": "P"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 42,
        "file": "t00014.cc",
        "line": 21,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "P",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "7473088098336348050",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "value",
          "source_location": {
            "column": 17,
            "file": "t00014.cc",
            "line": 27,
            "translation_unit": "t00014.cc"
          },
          "type": "std::string"
        }
      ],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 8,
        "file": "t00014.cc",
        "line": 26,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<T,std::string>",
      "id": "17491102824696068567",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 23,
        "file": "t00014.cc",
        "line": 30,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<T,std::unique_ptr<std::string>>",
      "id": "7578341869927946377",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 23,
        "file": "t00014.cc",
        "line": 31,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "std::string"
            }
          ],
          "type": "std::unique_ptr"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<long,T>",
      "id": "13600051123955725337",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 1,
        "file": "t00014.cc",
        "line": 34,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "long"
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<double,T>",
      "id": "16141324540142825631",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 20,
        "file": "t00014.cc",
        "line": 37,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "double"
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<long,U>",
      "id": "7252458562105886987",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 1,
        "file": "t00014.cc",
        "line": 41,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "long"
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "U",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<long,bool>",
      "id": "3031184166627445092",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 1,
        "file": "t00014.cc",
        "line": 34,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "long"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<double,bool>",
      "id": "16656107004201043317",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 20,
        "file": "t00014.cc",
        "line": 37,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "double"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "bool"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<long,float>",
      "id": "415827946341273846",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 1,
        "file": "t00014.cc",
        "line": 41,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "long"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "float"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<double,float>",
      "id": "1582154030263692708",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 20,
        "file": "t00014.cc",
        "line": 38,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "double"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "float"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<bool,std::string>",
      "id": "7167525692531209473",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 42,
        "file": "t00014.cc",
        "line": 21,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "bool"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<float,std::unique_ptr<std::string>>",
      "id": "14013861000085937293",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 23,
        "file": "t00014.cc",
        "line": 31,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "float"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [],
              "type": "std::string"
            }
          ],
          "type": "std::unique_ptr"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<int,std::string>",
      "id": "7096971529686780666",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 23,
        "file": "t00014.cc",
        "line": 30,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<std::string,std::string>",
      "id": "8955619965084495806",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 23,
        "file": "t00014.cc",
        "line": 30,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<char,std::string>",
      "id": "2724496792509139121",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 11,
        "file": "",
        "line": 111,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "char"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<wchar_t,std::string>",
      "id": "11111017193279157322",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 11,
        "file": "",
        "line": 111,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "wchar_t"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R<T>",
      "id": "14065705372679465152",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "bapair",
          "source_location": {
            "column": 22,
            "file": "t00014.cc",
            "line": 59,
            "translation_unit": "t00014.cc"
          },
          "type": "PairPairBA<bool>"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "abool",
          "source_location": {
            "column": 16,
            "file": "t00014.cc",
            "line": 61,
            "translation_unit": "t00014.cc"
          },
          "type": "APtr<bool>"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "aboolfloat",
          "source_location": {
            "column": 24,
            "file": "t00014.cc",
            "line": 62,
            "translation_unit": "t00014.cc"
          },
          "type": "AAPtr<bool,float>"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "afloat",
          "source_location": {
            "column": 23,
            "file": "t00014.cc",
            "line": 63,
            "translation_unit": "t00014.cc"
          },
          "type": "ASharedPtr<float>"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "boolstring",
          "source_location": {
            "column": 26,
            "file": "t00014.cc",
            "line": 64,
            "translation_unit": "t00014.cc"
          },
          "type": "A<bool,std::string>"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "floatstring",
          "source_location": {
            "column": 23,
            "file": "t00014.cc",
            "line": 65,
            "translation_unit": "t00014.cc"
          },
          "type": "AStringPtr<float>"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "intstring",
          "source_location": {
            "column": 16,
            "file": "t00014.cc",
            "line": 66,
            "translation_unit": "t00014.cc"
          },
          "type": "AIntString"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "stringstring",
          "source_location": {
            "column": 19,
            "file": "t00014.cc",
            "line": 67,
            "translation_unit": "t00014.cc"
          },
          "type": "AStringString"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "bstringstring",
          "source_location": {
            "column": 19,
            "file": "t00014.cc",
            "line": 68,
            "translation_unit": "t00014.cc"
          },
          "type": "BStringString"
        },
        {
          "access": "private",
          "is_static": false,
          "name": "atfloat",
          "source_location": {
            "column": 21,
            "file": "t00014.cc",
            "line": 69,
            "translation_unit": "t00014.cc"
          },
          "type": "AAPtr<T,float>"
        },
        {
          "access": "protected",
          "is_static": false,
          "name": "bs",
          "source_location": {
            "column": 13,
            "file": "t00014.cc",
            "line": 72,
            "translation_unit": "t00014.cc"
          },
          "type": "BVector"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "bs2",
          "source_location": {
            "column": 14,
            "file": "t00014.cc",
            "line": 75,
            "translation_unit": "t00014.cc"
          },
          "type": "BVector2"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "cb",
          "source_location": {
            "column": 33,
            "file": "t00014.cc",
            "line": 76,
            "translation_unit": "t00014.cc"
          },
          "type": "SimpleCallback<ACharString>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "gcb",
          "source_location": {
            "column": 35,
            "file": "t00014.cc",
            "line": 77,
            "translation_unit": "t00014.cc"
          },
          "type": "GenericCallback<AWCharString>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "vcb",
          "source_location": {
            "column": 18,
            "file": "t00014.cc",
            "line": 78,
            "translation_unit": "t00014.cc"
          },
          "type": "VoidCallback"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "vps",
          "source_location": {
            "column": 18,
            "file": "t00014.cc",
            "line": 79,
            "translation_unit": "t00014.cc"
          },
          "type": "VectorPtr<B>"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00014",
      "source_location": {
        "column": 29,
        "file": "t00014.cc",
        "line": 56,
        "translation_unit": "t00014.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00014_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "6127124633338685220",
      "source": "17491102824696068567",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "6127124633338685220",
      "source": "7578341869927946377",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "6127124633338685220",
      "source": "13600051123955725337",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "6127124633338685220",
      "source": "16141324540142825631",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13600051123955725337",
      "source": "7252458562105886987",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13600051123955725337",
      "source": "3031184166627445092",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "16141324540142825631",
      "source": "16656107004201043317",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13600051123955725337",
      "source": "415827946341273846",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "16141324540142825631",
      "source": "1582154030263692708",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "17491102824696068567",
      "source": "7167525692531209473",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "7578341869927946377",
      "source": "14013861000085937293",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "17491102824696068567",
      "source": "7096971529686780666",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "17491102824696068567",
      "source": "8955619965084495806",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "17491102824696068567",
      "source": "2724496792509139121",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "17491102824696068567",
      "source": "11111017193279157322",
      "type": "instantiation"
    },
    {
      "access": "private",
      "destination": "7473088098336348050",
      "label": "bapair",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "3031184166627445092",
      "label": "bapair",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "16656107004201043317",
      "label": "abool",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "16656107004201043317",
      "label": "aboolfloat",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "415827946341273846",
      "label": "aboolfloat",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "1582154030263692708",
      "label": "afloat",
      "source": "14065705372679465152",
      "type": "association"
    },
    {
      "access": "private",
      "destination": "7167525692531209473",
      "label": "boolstring",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "14013861000085937293",
      "label": "floatstring",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "7096971529686780666",
      "label": "intstring",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "8955619965084495806",
      "label": "stringstring",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "8955619965084495806",
      "label": "bstringstring",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "16141324540142825631",
      "label": "atfloat",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "private",
      "destination": "415827946341273846",
      "label": "atfloat",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "protected",
      "destination": "7473088098336348050",
      "label": "bs",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "7473088098336348050",
      "label": "bs2",
      "source": "14065705372679465152",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "2724496792509139121",
      "source": "14065705372679465152",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "2724496792509139121",
      "label": "cb",
      "source": "14065705372679465152",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11111017193279157322",
      "source": "14065705372679465152",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11111017193279157322",
      "label": "gcb",
      "source": "14065705372679465152",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "7473088098336348050",
      "label": "vps",
      "source": "14065705372679465152",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00014"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00014</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<T,P>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L21</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L26</data>
   <data key="nd5">B</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<T,std::string>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L30</data>
   <data key="nd5">A</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<T,std::unique_ptr<std::string>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L31</data>
   <data key="nd5">A</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<long,T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L34</data>
   <data key="nd5">A</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<double,T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L37</data>
   <data key="nd5">A</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<long,U>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L41</data>
   <data key="nd5">A</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<long,bool>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L34</data>
   <data key="nd5">A</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<double,bool>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L37</data>
   <data key="nd5">A</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<long,float>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L41</data>
   <data key="nd5">A</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<double,float>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L38</data>
   <data key="nd5">A</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<bool,std::string>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L21</data>
   <data key="nd5">A</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<float,std::unique_ptr<std::string>>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L31</data>
   <data key="nd5">A</data>
  </node>
  <node id="n13">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<int,std::string>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L30</data>
   <data key="nd5">A</data>
  </node>
  <node id="n14">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<std::string,std::string>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L30</data>
   <data key="nd5">A</data>
  </node>
  <node id="n15">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<char,std::string>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n16">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<wchar_t,std::string>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n17">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00014/t00014.cc#L56</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n2" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n3" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n4" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n6" target="n4">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n7" target="n4">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n8" target="n5">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n9" target="n4">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n10" target="n5">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n11" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n12" target="n3">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n13" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n14" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e13" source="n15" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e14" source="n16" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e15" source="n17" target="n1">
   <data key="ed0">aggregation</data>
   <data key="ed2">bapair</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e16" source="n17" target="n7">
   <data key="ed0">aggregation</data>
   <data key="ed2">bapair</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e17" source="n17" target="n8">
   <data key="ed0">aggregation</data>
   <data key="ed2">abool</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e18" source="n17" target="n8">
   <data key="ed0">aggregation</data>
   <data key="ed2">aboolfloat</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e19" source="n17" target="n9">
   <data key="ed0">aggregation</data>
   <data key="ed2">aboolfloat</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e20" source="n17" target="n10">
   <data key="ed0">association</data>
   <data key="ed2">afloat</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e21" source="n17" target="n11">
   <data key="ed0">aggregation</data>
   <data key="ed2">boolstring</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e22" source="n17" target="n12">
   <data key="ed0">aggregation</data>
   <data key="ed2">floatstring</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e23" source="n17" target="n13">
   <data key="ed0">aggregation</data>
   <data key="ed2">intstring</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e24" source="n17" target="n14">
   <data key="ed0">aggregation</data>
   <data key="ed2">stringstring</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e25" source="n17" target="n14">
   <data key="ed0">aggregation</data>
   <data key="ed2">bstringstring</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e26" source="n17" target="n5">
   <data key="ed0">aggregation</data>
   <data key="ed2">atfloat</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e27" source="n17" target="n9">
   <data key="ed0">aggregation</data>
   <data key="ed2">atfloat</data>
   <data key="ed1">private</data>
  </edge>
  <edge id="e28" source="n17" target="n1">
   <data key="ed0">aggregation</data>
   <data key="ed2">bs</data>
   <data key="ed1">protected</data>
  </edge>
  <edge id="e29" source="n17" target="n1">
   <data key="ed0">aggregation</data>
   <data key="ed2">bs2</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e30" source="n17" target="n15">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e31" source="n17" target="n15">
   <data key="ed0">dependency</data>
   <data key="ed2">cb</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e32" source="n17" target="n16">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e33" source="n17" target="n16">
   <data key="ed0">dependency</data>
   <data key="ed2">gcb</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e34" source="n17" target="n1">
   <data key="ed0">aggregation</data>
   <data key="ed2">vps</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
