# t00006 - Class field relationships inferred from templates
## Config
```yaml
diagrams:
  t00006_class:
    type: class
    glob:
      - t00006.cc
    using_namespace: clanguml::t00006
    include:
      namespaces:
        - clanguml::t00006

```
## Source code
File `tests/t00006/t00006.cc`
```cpp
#include <array>
#include <map>
#include <vector>

namespace clanguml {
namespace t00006 {
class A { };

class B { };

class C { };

class D { };

class E { };

class F { };

class G { };

class H { };

class I { };

class J { };

class K { };

class L { };

class M { };

class N { };

class NN { };

class NNN { };

template <typename T> class custom_container {
public:
    std::vector<T> data;
};

class R {
public:
    std::vector<A> a;
    std::vector<B *> b;

    std::map<int, C> c;
    std::map<int, D *> d;

    custom_container<E> e;

    std::vector<std::vector<F>> f;
    std::map<int, std::vector<G *>> g;

    std::array<H, 10> h;
    std::array<I *, 5> i;

    J j[10];
    K *k[20];

    std::vector<std::pair<L, M>> lm;

    std::tuple<N, NN, NNN> ns;
};
} // namespace t00006
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00006_class](./t00006_class.svg "Class field relationships inferred from templates")
## Generated Mermaid diagrams
![t00006_class](./t00006_class_mermaid.svg "Class field relationships inferred from templates")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "7912762435557379205",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 7,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "5186282081960042491",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 9,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C",
      "id": "2586434664058382197",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 11,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "8055299192349067940",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 13,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E",
      "id": "8740403152164631827",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 15,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "F",
      "id": "7723190094486257891",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "F",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 17,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G",
      "id": "14117856007096243716",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 19,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "H",
      "id": "13354284798700417170",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "H",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 21,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "I",
      "id": "17878004788792003021",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "I",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 23,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "J",
      "id": "10687469195003722956",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "J",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 25,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "K",
      "id": "12825522918912640984",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "K",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 27,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "L",
      "id": "2443897907266560370",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "L",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 29,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "M",
      "id": "13317956099389786204",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "M",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 31,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "N",
      "id": "7601680158337220805",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "N",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 33,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "NN",
      "id": "13298797887197809793",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "NN",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 35,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "NNN",
      "id": "15705160603852798870",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "NNN",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 37,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "custom_container<T>",
      "id": "7331041535639501055",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "data",
          "source_location": {
            "column": 20,
            "file": "t00006.cc",
            "line": 41,
            "translation_unit": "t00006.cc"
          },
          "type": "std::vector<T>"
        }
      ],
      "methods": [],
      "name": "custom_container",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 29,
        "file": "t00006.cc",
        "line": 39,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "custom_container<E>",
      "id": "401224904659478871",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "custom_container",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 29,
        "file": "t00006.cc",
        "line": 39,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "E"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "2424204488135060211",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 20,
            "file": "t00006.cc",
            "line": 46,
            "translation_unit": "t00006.cc"
          },
          "type": "std::vector<A>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 22,
            "file": "t00006.cc",
            "line": 47,
            "translation_unit": "t00006.cc"
          },
          "type": "std::vector<B *>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 22,
            "file": "t00006.cc",
            "line": 49,
            "translation_unit": "t00006.cc"
          },
          "type": "std::map<int,C>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "d",
          "source_location": {
            "column": 24,
            "file": "t00006.cc",
            "line": 50,
            "translation_unit": "t00006.cc"
          },
          "type": "std::map<int,D *>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "e",
          "source_location": {
            "column": 25,
            "file": "t00006.cc",
            "line": 52,
            "translation_unit": "t00006.cc"
          },
          "type": "custom_container<E>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "f",
          "source_location": {
            "column": 33,
            "file": "t00006.cc",
            "line": 54,
            "translation_unit": "t00006.cc"
          },
          "type": "std::vector<std::vector<F>>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "g",
          "source_location": {
            "column": 37,
            "file": "t00006.cc",
            "line": 55,
            "translation_unit": "t00006.cc"
          },
          "type": "std::map<int,std::vector<G *>>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "h",
          "source_location": {
            "column": 23,
            "file": "t00006.cc",
            "line": 57,
            "translation_unit": "t00006.cc"
          },
          "type": "std::array<H,10>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "i",
          "source_location": {
            "column": 24,
            "file": "t00006.cc",
            "line": 58,
            "translation_unit": "t00006.cc"
          },
          "type": "std::array<I *,5>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "j",
          "source_location": {
            "column": 7,
            "file": "t00006.cc",
            "line": 60,
            "translation_unit": "t00006.cc"
          },
          "type": "J[10]"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "k",
          "source_location": {
            "column": 8,
            "file": "t00006.cc",
            "line": 61,
            "translation_unit": "t00006.cc"
          },
          "type": "K *[20]"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "lm",
          "source_location": {
            "column": 34,
            "file": "t00006.cc",
            "line": 63,
            "translation_unit": "t00006.cc"
          },
          "type": "std::vector<std::pair<L,M>>"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "ns",
          "source_location": {
            "column": 28,
            "file": "t00006.cc",
            "line": 65,
            "translation_unit": "t00006.cc"
          },
          "type": "std::tuple<N,NN,NNN>"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00006",
      "source_location": {
        "column": 7,
        "file": "t00006.cc",
        "line": 44,
        "translation_unit": "t00006.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00006_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "8740403152164631827",
      "source": "401224904659478871",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "7331041535639501055",
      "source": "401224904659478871",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "7912762435557379205",
      "label": "a",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "5186282081960042491",
      "label": "b",
      "source": "2424204488135060211",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "2586434664058382197",
      "label": "c",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "8055299192349067940",
      "label": "d",
      "source": "2424204488135060211",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "401224904659478871",
      "label": "e",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "7723190094486257891",
      "label": "f",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "14117856007096243716",
      "label": "g",
      "source": "2424204488135060211",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "13354284798700417170",
      "label": "h",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "17878004788792003021",
      "label": "i",
      "source": "2424204488135060211",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "10687469195003722956",
      "label": "j",
      "multiplicity_destination": "10",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "12825522918912640984",
      "label": "k",
      "multiplicity_destination": "20",
      "source": "2424204488135060211",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "2443897907266560370",
      "label": "lm",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "13317956099389786204",
      "label": "lm",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "7601680158337220805",
      "label": "ns",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "13298797887197809793",
      "label": "ns",
      "source": "2424204488135060211",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "15705160603852798870",
      "label": "ns",
      "source": "2424204488135060211",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00006"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00006</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L7</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L9</data>
   <data key="nd5">B</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L11</data>
   <data key="nd5">C</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L13</data>
   <data key="nd5">D</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L15</data>
   <data key="nd5">E</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[F]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L17</data>
   <data key="nd5">F</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L19</data>
   <data key="nd5">G</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[H]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L21</data>
   <data key="nd5">H</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[I]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L23</data>
   <data key="nd5">I</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[J]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L25</data>
   <data key="nd5">J</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[K]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L27</data>
   <data key="nd5">K</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[L]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L29</data>
   <data key="nd5">L</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[M]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L31</data>
   <data key="nd5">M</data>
  </node>
  <node id="n13">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[N]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L33</data>
   <data key="nd5">N</data>
  </node>
  <node id="n14">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[NN]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L35</data>
   <data key="nd5">NN</data>
  </node>
  <node id="n15">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[NNN]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L37</data>
   <data key="nd5">NNN</data>
  </node>
  <node id="n16">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[custom_container<T>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L39</data>
   <data key="nd5">custom_container</data>
  </node>
  <node id="n17">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[custom_container<E>]]></data>
   <data key="nd6">true</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L39</data>
   <data key="nd5">custom_container</data>
  </node>
  <node id="n18">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00006/t00006.cc#L44</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n17" target="n4">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n17" target="n16">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n18" target="n0">
   <data key="ed0">aggregation</data>
   <data key="ed2">a</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n18" target="n1">
   <data key="ed0">association</data>
   <data key="ed2">b</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n18" target="n2">
   <data key="ed0">aggregation</data>
   <data key="ed2">c</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n18" target="n3">
   <data key="ed0">association</data>
   <data key="ed2">d</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n18" target="n17">
   <data key="ed0">aggregation</data>
   <data key="ed2">e</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n18" target="n5">
   <data key="ed0">aggregation</data>
   <data key="ed2">f</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n18" target="n6">
   <data key="ed0">association</data>
   <data key="ed2">g</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n18" target="n7">
   <data key="ed0">aggregation</data>
   <data key="ed2">h</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n18" target="n8">
   <data key="ed0">association</data>
   <data key="ed2">i</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n18" target="n9">
   <data key="ed0">aggregation</data>
   <data key="ed2">j</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n18" target="n10">
   <data key="ed0">association</data>
   <data key="ed2">k</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e13" source="n18" target="n11">
   <data key="ed0">aggregation</data>
   <data key="ed2">lm</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e14" source="n18" target="n12">
   <data key="ed0">aggregation</data>
   <data key="ed2">lm</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e15" source="n18" target="n13">
   <data key="ed0">aggregation</data>
   <data key="ed2">ns</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e16" source="n18" target="n14">
   <data key="ed0">aggregation</data>
   <data key="ed2">ns</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e17" source="n18" target="n15">
   <data key="ed0">aggregation</data>
   <data key="ed2">ns</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
