# t00005 - Basic class field relationships
## Config
```yaml
diagrams:
  t00005_class:
    type: class
    glob:
      - t00005.cc
    using_namespace: clanguml::t00005
    include:
      namespaces:
        - clanguml::t00005

```
## Source code
File `tests/t00005/t00005.cc`
```cpp
namespace clanguml {
namespace t00005 {
class A { };

class B { };

class C { };

class D { };

class E { };

class F { };

class G { };

class H { };

class I { };

class J { };

class K { };

class R {
public:
    int some_int;
    int *some_int_pointer;
    int **some_int_pointer_pointer;
    int &some_int_reference;
    A a;
    B *b;
    C &c;
    const D *d;
    const E &e{};
    F &&f;
    G **g;
    H ***h;
    I *&i;
    volatile J *j;
    mutable K *k;
};
} // namespace t00005
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00005_class](./t00005_class.svg "Basic class field relationships")
## Generated Mermaid diagrams
![t00005_class](./t00005_class_mermaid.svg "Basic class field relationships")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "770847151166242555",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 3,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "15275406858672700331",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 5,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C",
      "id": "7745411075680519262",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 7,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "13884796726689493544",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 9,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E",
      "id": "7103681095374757269",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 11,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "F",
      "id": "6181754862849854182",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "F",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 13,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G",
      "id": "7833183087077891503",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 15,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "H",
      "id": "11525386408433893405",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "H",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 17,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "I",
      "id": "877453852400691446",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "I",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 19,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "J",
      "id": "2706640095757202600",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "J",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 21,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "K",
      "id": "17432955118643460073",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "K",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 23,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "5045539258985153690",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "some_int",
          "source_location": {
            "column": 9,
            "file": "t00005.cc",
            "line": 27,
            "translation_unit": "t00005.cc"
          },
          "type": "int"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "some_int_pointer",
          "source_location": {
            "column": 10,
            "file": "t00005.cc",
            "line": 28,
            "translation_unit": "t00005.cc"
          },
          "type": "int *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "some_int_pointer_pointer",
          "source_location": {
            "column": 11,
            "file": "t00005.cc",
            "line": 29,
            "translation_unit": "t00005.cc"
          },
          "type": "int **"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "some_int_reference",
          "source_location": {
            "column": 10,
            "file": "t00005.cc",
            "line": 30,
            "translation_unit": "t00005.cc"
          },
          "type": "int &"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 7,
            "file": "t00005.cc",
            "line": 31,
            "translation_unit": "t00005.cc"
          },
          "type": "A"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 8,
            "file": "t00005.cc",
            "line": 32,
            "translation_unit": "t00005.cc"
          },
          "type": "B *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "c",
          "source_location": {
            "column": 8,
            "file": "t00005.cc",
            "line": 33,
            "translation_unit": "t00005.cc"
          },
          "type": "C &"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "d",
          "source_location": {
            "column": 14,
            "file": "t00005.cc",
            "line": 34,
            "translation_unit": "t00005.cc"
          },
          "type": "const D *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "e",
          "source_location": {
            "column": 14,
            "file": "t00005.cc",
            "line": 35,
            "translation_unit": "t00005.cc"
          },
          "type": "const E &"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "f",
          "source_location": {
            "column": 9,
            "file": "t00005.cc",
            "line": 36,
            "translation_unit": "t00005.cc"
          },
          "type": "F &&"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "g",
          "source_location": {
            "column": 9,
            "file": "t00005.cc",
            "line": 37,
            "translation_unit": "t00005.cc"
          },
          "type": "G **"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "h",
          "source_location": {
            "column": 10,
            "file": "t00005.cc",
            "line": 38,
            "translation_unit": "t00005.cc"
          },
          "type": "H ***"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "i",
          "source_location": {
            "column": 9,
            "file": "t00005.cc",
            "line": 39,
            "translation_unit": "t00005.cc"
          },
          "type": "I *&"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "j",
          "source_location": {
            "column": 17,
            "file": "t00005.cc",
            "line": 40,
            "translation_unit": "t00005.cc"
          },
          "type": "volatile J *"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "k",
          "source_location": {
            "column": 16,
            "file": "t00005.cc",
            "line": 41,
            "translation_unit": "t00005.cc"
          },
          "type": "K *"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00005",
      "source_location": {
        "column": 7,
        "file": "t00005.cc",
        "line": 25,
        "translation_unit": "t00005.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00005_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "770847151166242555",
      "label": "a",
      "source": "5045539258985153690",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "15275406858672700331",
      "label": "b",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "7745411075680519262",
      "label": "c",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "13884796726689493544",
      "label": "d",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "7103681095374757269",
      "label": "e",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "6181754862849854182",
      "label": "f",
      "source": "5045539258985153690",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "7833183087077891503",
      "label": "g",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "11525386408433893405",
      "label": "h",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "877453852400691446",
      "label": "i",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "2706640095757202600",
      "label": "j",
      "source": "5045539258985153690",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "17432955118643460073",
      "label": "k",
      "source": "5045539258985153690",
      "type": "association"
    }
  ],
  "using_namespace": "clanguml::t00005"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00005</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L3</data>
   <data key="nd5">A</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L5</data>
   <data key="nd5">B</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L7</data>
   <data key="nd5">C</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L9</data>
   <data key="nd5">D</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L11</data>
   <data key="nd5">E</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[F]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L13</data>
   <data key="nd5">F</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L15</data>
   <data key="nd5">G</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[H]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L17</data>
   <data key="nd5">H</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[I]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L19</data>
   <data key="nd5">I</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[J]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L21</data>
   <data key="nd5">J</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[K]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L23</data>
   <data key="nd5">K</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t00005/t00005.cc#L25</data>
   <data key="nd5">R</data>
  </node>
  <edge id="e0" source="n11" target="n0">
   <data key="ed0">aggregation</data>
   <data key="ed2">a</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n11" target="n1">
   <data key="ed0">association</data>
   <data key="ed2">b</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n11" target="n2">
   <data key="ed0">association</data>
   <data key="ed2">c</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n11" target="n3">
   <data key="ed0">association</data>
   <data key="ed2">d</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n11" target="n4">
   <data key="ed0">association</data>
   <data key="ed2">e</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n11" target="n5">
   <data key="ed0">aggregation</data>
   <data key="ed2">f</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n11" target="n6">
   <data key="ed0">association</data>
   <data key="ed2">g</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n11" target="n7">
   <data key="ed0">association</data>
   <data key="ed2">h</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n11" target="n8">
   <data key="ed0">association</data>
   <data key="ed2">i</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n11" target="n9">
   <data key="ed0">association</data>
   <data key="ed2">j</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n11" target="n10">
   <data key="ed0">association</data>
   <data key="ed2">k</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
