namespace Passwordless.Common.EventLog.Enums;

public enum EventType
{
    Unknown = 0,
    ApiAuthUserRegistered = 1000,
    ApiAuthPasskeyRegistrationBegan = 1001,
    ApiAuthPasskeyRegistrationCompleted = 1002,
    ApiAuthInvalidSecretKeyUsed = 1003,
    ApiAuthInvalidPublicKeyUsed = 1004,
    ApiAuthDisabledSecretKeyUsed = 1005,
    ApiAuthDisabledPublicKeyUsed = 1006,
    ApiUserSetAliases = 1100,
    ApiUserDeleteCredential = 1101,
    ApiUserSignInBegan = 1102,
    ApiUserSignInCompleted = 1103,
    ApiUserSignInVerified = 1104,
    ApiUserDeleted = 1105,
    ApiUserSigninTokenCreated = 1106,
    ApiUserMagicLinkCreated = 1107,
    ApiManagementAppMarkedForDeletion = 1200,
    ApiManagementAppDeletionCancelled = 1201,
    ApiManagementAppCreated = 1202,
    ApiManagementAppFrozen = 1203,
    ApiManagementAppUnfrozen = 1204,
    ApiAuthenticatorsAllowlisted = 1300,
    ApiAuthenticatorsBlacklisted = 1301,
    ApiAuthenticatorsDelisted = 1302,
    ApiAuthenticationConfigurationCreated = 1400,
    ApiAuthenticationConfigurationUpdated = 1401,
    ApiAuthenticationConfigurationDeleted = 1402,
    AdminOrganizationCreated = 7000,
    AdminSendAdminInvite = 7001,
    AdminMagicLinkLogin = 7002,
    AdminDeleteAdmin = 7003,
    AdminCancelAdminInvite = 7004,
    AdminInvalidInviteUsed = 7005,
    AdminAcceptedInvite = 7006,
    AdminSignInTokenVerified = 7007,
    AdminApiKeyCreated = 7008,
    AdminApiKeyDeleted = 7009,
    AdminApiKeyLocked = 7010,
    AdminApiKeyUnlocked = 7011,
    AdminApiKeysEnumerated = 7012,
    AdminGenerateSignInTokenEndpointEnabled = 7013,
    AdminGenerateSignInTokenEndpointDisabled = 7014,
    AdminMagicLinksEnabled = 7015,
    AdminMagicLinksDisabled = 7016,
}