using Microsoft.AspNetCore.Razor.TagHelpers;

namespace Passwordless.AdminConsole.TagHelpers.Icons;

[HtmlTargetElement(HtmlTag)]
public sealed class InfoAlertIcon : BaseAlertIcon
{
    public const string HtmlTag = "info-alert-icon";

    public InfoAlertIcon()
    {
        Variant = ColorVariant.Info;
    }

    public override void Process(TagHelperContext context, TagHelperOutput output)
    {
        base.Process(context, output);
        output.Content.AppendHtml(@"<path fill-rule=""evenodd"" d=""M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a.75.75 0 000 1.5h.253a.25.25 0 01.244.304l-.459 2.066A1.75 1.75 0 0010.747 15H11a.75.75 0 000-1.5h-.253a.25.25 0 01-.244-.304l.459-2.066A1.75 1.75 0 009.253 9H9z"" clip-rule=""evenodd"" />");
    }
}