# Awesome AI List Guide

 人工智能AI（也叫深度学习、机器学习）相关的清单向导！让你可以从清单开始找到你需要的！

 **所有排名不分先后！！！**

 欢迎PR！ 

[English](README.md) | [中文](README_ch.md)

# 目录

- [教程](#教程)
- [CV](#CV)
- [NLP](#NLP)
- [Speech](#Speech)
- [Others](#Others)



## 教程

[awesome-for-beginners](https://github.com/MunGell/awesome-for-beginners)![](https://img.shields.io/github/stars/MunGell/awesome-for-beginners.svg?style=social):  很棒的适合初学者入门的项目列表。

[Awesome production machine learning](https://github.com/EthicalML/awesome-production-machine-learning.git): 精选的开源库列表，用于部署、监控、版本和扩展您的机器学习 。

[awesome-ai-infrastructures](https://github.com/1duo/awesome-ai-infrastructures) :  用于机器/深度学习训练和/或**生产**推理的真实 AI 基础架构**列表** 。 

[Production-Level-Deep-Learning](https://github.com/alirezadir/Production-Level-Deep-Learning): 构建实际生产级深度学习系统以部署到实际应用中的指南。

[competition_baselines](https://github.com/LogicJake/competition_baselines) : 开源的各大比赛baseline 

[competition-baseline](https://github.com/datawhalechina/competition-baseline) :  数据科学竞赛知识、代码、思路 

[paper-reproduction-tutorials](https://github.com/PaddleEdu/paper-reproduction-tutorials) ： 论文复现技巧与PaddlePaddle优秀复现项目分享 

[awesome-mlops](https://github.com/visenger/awesome-mlops) :关于机器学习模型操作管理（建模全流程）的一个很棒的参考列表

[awesome-machine-learning](https://github.com/josephmisiti/awesome-machine-learning) ：精心策划的机器学习框架、库和软件列表。

[Learn-Data-Science-For-Free](https://github.com/therealsreehari/Learn-Data-Science-For-Free) ：这个仓库是分散在互联网上的不同资源的组合。制作这样一个存储库的原因是以顺序的方式组合所有有价值的资源，以便帮助每一个为数据科学寻找免费、结构化学习资源的初学者。

[best-of-ml-python](https://github.com/ml-tooling/best-of-ml-python) ： 🏆 一个很棒的机器学习Python库的排名列表。每周更新一次。 

[build-your-own-x](https://github.com/danistefanovic/build-your-own-x) :  🤓 构建自己的X

[tensorflow_practice](https://github.com/princewen/tensorflow_practice) :  tensorflow实战练习，包括强化学习、推荐系统、nlp等 

[awesome-courses](https://github.com/prakhar1989/awesome-courses) :  📚 学习计算机科学的优秀大学课程列表！

[MT-Reading-List](https://github.com/THUNLP-MT/MT-Reading-List) :  清华自然语言处理集团维护的机器翻译阅读列表

[cs-video-courses](https://github.com/Developer-Y/cs-video-courses) :  计算机科学课程和视频讲座列表。

[machine-learning-surveys](https://github.com/metrofun/machine-learning-surveys) :  一份精心策划的机器学习调查、教程和书籍清单。

[data-science-blogs](https://github.com/rushter/data-science-blogs) :  精心策划的数据科学博客列表

[awesome-tensorflow](https://github.com/jtoy/awesome-tensorflow) :  TensorFlow - 精心策划的专用资源清单

[ds-cheatsheets](https://github.com/FavioVazquez/ds-cheatsheets) :  List of Data Science Cheatsheets to rule the world 

[awesome-R](https://github.com/qinwf/awesome-R) :  一份精心策划的令人敬畏的R语言软件包、框架和软件清单。

[awesome-youtubers](https://github.com/JoseDeFreitas/awesome-youtubers) :  ▶️ 这是一个很棒的列表，里面有很多很棒的教授科技的YouTube。关于网络开发、计算机科学、机器学习、游戏开发、网络安全等的教程。

[Book_List](https://github.com/mukeshmithrakumar/Book_List) :  Python、机器学习、深度学习和数据科学书籍 

[awesome-deep-learning](https://github.com/ChristosChristofidis/awesome-deep-learning) :  精心策划的深度学习教程、项目和社区列表

[awesome-artificial-intelligence](https://github.com/owainlewis/awesome-artificial-intelligence) :  人工智能（AI）课程、书籍、视频讲座和论文的策划清单。

[awesome-project-ideas](https://github.com/NirantK/awesome-project-ideas) :  机器学习、NLP、愿景、推荐系统项目理念策划清单

[awesome-datascience](https://github.com/academic/awesome-datascience) :  📝 这是一个很棒的数据科学知识库，用于学习和解决真实世界的问题。

[awesome-machine-learning-cn](https://github.com/jobbole/awesome-machine-learning-cn) :  机器学习资源大全中文版，包括机器学习领域的框架、库以及软件 

[Awesome-PyTorch-Chinese](https://github.com/INTERMT/Awesome-PyTorch-Chinese) :  【干货】史上最全的PyTorch学习资源汇总 

[awesome-AI-books](https://github.com/zslucky/awesome-AI-books) :  一些很棒的人工智能相关书籍和PDF供学习和下载，还应用一些娱乐模型进行学习 

[awesome-ml-courses](https://github.com/luspr/awesome-ml-courses) :  很棒的免费机器学习和AI课程，视频讲座。 

[awesome-ai-ml-dl](https://github.com/neomatrix369/awesome-ai-ml-dl) :  很棒的人工智能、机器学习和深度学习。研究笔记和这些主题的很棒的资源列表。

[Awesome-Noah](https://github.com/AI-Sphere/Awesome-Noah) :   AI圈Noah plan-AI数据竞赛Top可复现解决方案  

[my-awesome-AI-bookmarks](https://github.com/goodrahstar/my-awesome-AI-bookmarks) : 我的阅读、实现和人工智能、深度学习、机器学习的核心概念的精选列表，由世界上最优秀的人撰写。 

[awesome-DeepLearning](https://github.com/PaddlePaddle/awesome-DeepLearning) :  深度学习入门课、资深课、特色课、学术案例、产业实践案例、深度学习知识百科及面试题库The course, case and knowledge of Deep Learning and AI 

[Machine-Learning-Collection](https://github.com/aladdinpersson/Machine-Learning-Collection) :  关于机器学习和深度学习的学习资源 

[DeepLearningSystem](https://github.com/chenzomi12/DeepLearningSystem) :  深度学习系统的核心原理：AI框架核心技术、AI编译器原理、推理系统、AI芯片。

[free-programming-books](https://github.com/EbookFoundation/free-programming-books) :  📚 免费的编程书籍

[research-method](https://github.com/secdr/research-method) :   论文写作与资料分享



## CV

[awesome-hand-pose-estimation](https://github.com/xinghaochen/awesome-hand-pose-estimation):  手部姿势估计/跟踪方面的出色工作 

[CV-Backbones](https://github.com/huawei-noah/CV-Backbones) : 由华为诺亚方舟实验室开发的 CV 骨干网，包括 GhostNet、TinyNet 和 TNT。 

[SceneTextPapers](https://github.com/Jyouhou/SceneTextPapers.git): 跟踪场景文本检测和识别的最新进展：必读的高价值论文。

[Awesome-GANs](https://github.com/kozistr/Awesome-GANs) :  tensorflow的很棒的生成性对抗网络

[OCR_DataSet](https://github.com/WenmuZhou/OCR_DataSet) :  收集并整理有关OCR的数据集并统一标注格式，以便实验需要 

[awesome-ocr](https://github.com/wanghaisheng/awesome-ocr) :  一份精心策划的有保证的OCR资源清单 

[Awesome-Table-Recognition](https://github.com/cv-small-snails/Awesome-Table-Recognition) :  专门用于表格识别的精心策划的资源列表 

[awesome-object-detection](https://github.com/amusi/awesome-object-detection) : 基于handong1587 github的超棒的目标检测 

[deep_learning_object_detection](https://github.com/hoya012/deep_learning_object_detection) :  使用深度学习的目标检测的论文列表。

[awesome-captcha](https://github.com/ZYSzys/awesome-captcha) :  🔑 精心策划的超赞验证码库和破解工具列表。

[image-to-image-papers](https://github.com/lzhbrian/image-to-image-papers) :  🦓<->🦒 🌃<->🌆 带有代码（不断更新）的图像到图像相关论文的集合

[Deep-Learning-Papers-Reading-Roadmap](https://github.com/floodsung/Deep-Learning-Papers-Reading-Roadmap) :  为那些想学习深度学习的朋友提供一个论文阅读！

[benchmark_results](https://github.com/foolwood/benchmark_results) :  视觉跟踪论文清单

[awesome_3DReconstruction_list](https://github.com/openMVG/awesome_3DReconstruction_list) :  图像三维重建相关的论文和资源。

[the-gan-zoo](https://github.com/hindupuravinash/the-gan-zoo) :  A list of all named GANs! 

[awesome-computer-vision](https://github.com/jbhuang0604/awesome-computer-vision) :  一份精心策划的优秀计算机视觉资源列表 

[multi-object-tracking-paper-list](https://github.com/SpyderXu/multi-object-tracking-paper-list) :  用于多目标跟踪的论文列表和源代码 

[awesome-deep-vision](https://github.com/kjw0612/awesome-deep-vision) :  一份精心策划的计算机视觉深度学习资源清单 

[AdversarialNetsPapers](https://github.com/zhangqianhui/AdversarialNetsPapers) :  非常棒的关于生成性对抗网络的论文和代码清单 (gan)

[awesome-lane-detection](https://github.com/amusi/awesome-lane-detection) :  车道检测的论文列表。 

[Paper_Reading_List](https://github.com/ArcherFMY/Paper_Reading_List) :   推荐的论文：计算机视觉和模式识别、人工智能、机器学习

[awesome-network-embedding](https://github.com/chihming/awesome-network-embedding) :  一份精心策划的神经网络embedding技术的清单。

[gans-awesome-applications](https://github.com/nashory/gans-awesome-applications) :  精心策划的GAN应用和演示列表

[WeakSupervisedSegmentationList](https://github.com/JackieZhangdx/WeakSupervisedSegmentationList) :  该存储库包含state-of-art弱监督语义分割工作的列表

[awesome-action-recognition](https://github.com/jinwchoi/awesome-action-recognition) :  行动识别和相关领域资源的策划清单 

[really-awesome-gan](https://github.com/nightrome/really-awesome-gan) : 关于生成性对抗（神经）网络的论文列表 

[awesome-panoptic-segmentation](https://github.com/Angzz/awesome-panoptic-segmentation) :  全景分割资源列表 

[Pedestrian-Attribute-Recognition-Paper-List](https://github.com/wangxiao5791509/Pedestrian-Attribute-Recognition-Paper-List) :  关于行人属性识别（PAR）和相关任务（模式识别2021）的论文列表 

[awesome-vqa](https://github.com/chingyaoc/awesome-vqa) :  视觉问答阅读清单 

[3D-Shape-Analysis-Paper-List](https://github.com/yinyunie/3D-Shape-Analysis-Paper-List) :  关于3D形状/场景分析的最新论文、库和数据集列表（按主题、更新）。

[awesome-semantic-segmentation](https://github.com/mrgloom/awesome-semantic-segmentation) ：很棒的语义分割

[Awesome-Crowd-Counting](https://github.com/gjy3035/Awesome-Crowd-Counting) :  很棒的人群计数

[awesome-Face_Recognition](https://github.com/ChanChiChoi/awesome-Face_Recognition) :  关于人脸检测的论文；面部对齐；人脸识别、人脸识别、人脸验证和人脸表示；面部重建；人脸跟踪；面部超分辨率和面部去模糊；人脸生成与人脸合成；面部转移；人脸反欺骗；人脸检索；

[AWESOME-FER](https://github.com/EvelynFan/AWESOME-FER) :  关注面部表情识别（FER）/面部动作单元（FAU）的顶级会议和期刊

[Awesome-Gaze-Estimation](https://github.com/cvlab-uob/Awesome-Gaze-Estimation) :  很棒的人眼视线评估论文列表

[awesome-ai-art-image-synthesis](https://github.com/altryne/awesome-ai-art-image-synthesis) :   一系列很棒的工具、想法、提示工程工具、colab、模型和助手，供提示设计师使用 aiArt 和图像合成。涵盖 Dalle2、MidJourney、StableDiffusion 和开源工具。

[Diffusion-Models-Papers-Survey-Taxonomy](https://github.com/YangLing0818/Diffusion-Models-Papers-Survey-Taxonomy) :  扩散模型的论文、调研和分类法  

[A-Survey-on-Generative-Diffusion-Model](https://github.com/chq1155/A-Survey-on-Generative-Diffusion-Model) :  扩散生成模型的精选列表，来自于一篇survey论文

[Awesome-Face-Restoration](https://github.com/TaoWangzj/Awesome-Face-Restoration) :  关于面部恢复（人脸重建）方法的资源（论文、存储库等）的综合列表。

[awesome-point-cloud-analysis](https://github.com/Yochengliu/awesome-point-cloud-analysis) :  点云分析（处理）

[awesome-ai-painting](https://github.com/hua1995116/awesome-ai-painting) :   AI绘画资料合集（包含国内外可使用平台、使用教程、参数教程、部署教程、业界新闻等等） 

[awesome-aigc](https://github.com/gongminmin/awesome-aigc) :  很棒的AIGC作品列表

[awesome-llm-and-aigc](https://github.com/codingonion/awesome-llm-and-aigc) :  关于大型语言模型、视觉基础模型和人工智能生成内容的一些很棒的公共项目的集合。

[awesome-text-to-video](https://github.com/jianzhnie/awesome-text-to-video) : 文本到视频生成/合成综述。

[Awesome-AIGC-Tutorials](https://github.com/luban-agi/Awesome-AIGC-Tutorials) :  为大型语言模型、人工智能绘画等策划教程和资源。

[Awesome-AIGC](https://github.com/wshzd/Awesome-AIGC) :  AIGC资料汇总学习，持续更新...... 



## NLP

[nlp-tutorial](https://github.com/graykode/nlp-tutorial) :  面向深度学习研究人员的自然语言处理教程 

[language-resources](https://github.com/google/language-resources) :  初级自然语言处理的数据集和工具. 

[Summarization-Papers](https://github.com/xcfcode/Summarization-Papers) ：摘要任务的paper合集

[CLUEDatasetSearch](https://github.com/CLUEbenchmark/CLUEDatasetSearch) ： 搜索所有中文NLP数据集，附常用英文NLP数据集。

[nlpdemo-ch-wordlib](https://github.com/MrLi008/nlpdemo-ch-wordlib) :  中文各种词库 

[ChineseNLP](https://github.com/didi/ChineseNLP) :  中文自然语言处理各领域的数据集、SOTA结果

[ChineseNLPCorpus](https://github.com/InsaneLife/ChineseNLPCorpus) :  中文自然语言处理数据集，平时做做实验的材料。

[Chinese-Word-Vectors](https://github.com/Embedding/Chinese-Word-Vectors) :  100+ Chinese Word Vectors 上百种预训练中文词向量

[ChineseNlpCorpus](https://github.com/SophonPlus/ChineseNlpCorpus) :  搜集、整理、发布 中文 自然语言处理 语料/数据集，与 有志之士 共同 促进 中文 自然语言处理 的 发展。

[nlp-competitions-list-review](https://github.com/zhpmatrix/nlp-competitions-list-review) :  复盘所有NLP比赛的TOP方案，只关注NLP比赛，持续更新中！

[funNLP](https://github.com/fighting41love/funNLP) :  中英文敏感词、语言检测、中外手机/电话归属地/运营商查询、名字推断性别、手机号抽取、身份证抽取、邮箱抽取、中日文人名库、中文缩写库、拆字词典、词汇情感值、停用词、反动词表、暴恐词表、繁简体转换、英文模拟中文发音、汪峰歌词生成器、职业名称词库、同义词库、反义词库、否定词库、汽车品牌词库、汽车零件词库、连续英文切割、各种中文词向量、公司名字大全、古诗词库、IT词库、财经词库、成语词库、地名词库、历史名人词库、诗词词库、医学词库、饮食词库、法律词库、汽车词库、动物词库、中文聊天语料、中文谣言数据、百度中文问答数据集、句子相似度匹配算法集合、bert资源、文本生成&摘要相关工具、cocoNLP信息抽取工具、国内电话号码正则匹配、清华大学XLORE:中英文跨语言百科知识图谱、清华大学人工智能技术… 

[nlp_chinese_corpus](https://github.com/brightmart/nlp_chinese_corpus) :  大规模中文自然语言处理语料 Large Scale Chinese Corpus for NLP 

[awesome-2vec](https://github.com/MaxwellRebo/awesome-2vec) :  精心策划的向量化的embedding models列表 

[chatbot-list](https://github.com/lizhe2004/chatbot-list) :  行业内关于智能客服、聊天机器人的应用和架构、算法分享和介绍 

[awesome-chatbot-list](https://github.com/aceimnorstuvwxz/awesome-chatbot-list) :  深度学习聊天机器人资源集合 Awesome chatbot resource list 

[nmt-list](https://github.com/jonsafari/nmt-list) :  神经机器翻译相关实现的列表 

[Question-Generation-Paper-List](https://github.com/teacherpeterpan/Question-Generation-Paper-List) :  神经问题生成（NQG）必读论文汇总

[awesome-nlp](https://github.com/keon/awesome-nlp) :  📖 一份精心策划的自然语言处理（NLP）资源清单

[Style-Transfer-in-Text](https://github.com/fuzhenxin/Style-Transfer-in-Text) :  用于在文本中传输样式的论文列表 

[TG-Reading-List](https://github.com/THUNLP-MT/TG-Reading-List) :  清华自然语言处理团队维护的文本生成阅读列表。

[awesome-sentence-embedding](https://github.com/Separius/awesome-sentence-embedding) :  一份精心策划的预训练句子和单词嵌入embedding模型列表

[Awesome-Chinese-NLP](https://github.com/crownpku/Awesome-Chinese-NLP) :  A curated list of resources for Chinese NLP 中文自然语言处理相关资料 

[*awesome*_Chinese_medical_*NLP*](https://github.com/GanjinZero/awesome_Chinese_medical_NLP) :  中文医学NLP公开资源整理：术语集/语料库/词向量/预训练模型/知识图谱/命名实体识别/QA/信息抽取/模型/论文/etc 

[awesome-dl4nlp](https://github.com/brianspiering/awesome-dl4nlp) :  一份精心策划的自然语言处理资源深度学习清单

[Awesome-Korean-NLP](https://github.com/datanada/Awesome-Korean-NLP) :  韩语自然语言处理（NLP）资源的精选列表  

[awesome-bert-nlp](https://github.com/cedrickchee/awesome-bert-nlp) :  一份精心策划的NLP资源清单，重点介绍了BERT、注意机制、转换网络和迁移学习。

[awesome-knowledge-graph](https://github.com/husthuke/awesome-knowledge-graph) :  整理知识图谱相关学习资料 

[Task-Oriented-Dialogue-Research-Progress-Survey](https://github.com/AtmaHou/Task-Oriented-Dialogue-Research-Progress-Survey) :   关于面向任务的对话的数据集和方法调查，包括最近的数据集和 SOTA 排行榜。 

[Text_Classification](https://github.com/kk7nc/Text_Classification) : 文本分类算法综述

[awesome-punctuator](https://github.com/bigcash/awesome-punctuator) :  很棒的标点重建的精选列表

[text-classification-surveys](https://github.com/xiaoqian19940510/text-classification-surveys) :  文本分类资源汇总，包括深度学习文本分类模型 

[awesome_Chinese_medical_NLP](https://github.com/GanjinZero/awesome_Chinese_medical_NLP) :  中文医学NLP公开资源整理：术语集/语料库/词向量/预训练模型/知识图谱/命名实体识别/QA/信息抽取/模型/论文/etc 

[Awesome-LLM](https://github.com/Hannibal046/Awesome-LLM) :  Awesome-LLM: 大语言模型列表

[Prompt-Engineering-Guide](https://github.com/dair-ai/Prompt-Engineering-Guide) : 提示工程向导、论文、教程和资源

[PromptPapers](https://github.com/thunlp/PromptPapers) :  必读的关于预先训练的语言模型的基于提示的调优的论文。 

[awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts) :  ChatGPT提示策略

[awesome-chatgpt-prompts-zh](https://github.com/PlexPt/awesome-chatgpt-prompts-zh) :  ChatGPT 中文调教指南。各种场景使用指南。学习怎么让它听你的话。 

[awesome-gpt3](https://github.com/elyase/awesome-gpt3) :  Awesome GPT-3 是[OpenAI GPT-3 API](https://openai.com/blog/openai-api/)的一系列的样例演示和文章。

[Awesome-ChatGPT](https://github.com/dalinvip/Awesome-ChatGPT) :  ChatGPT资料汇总学习，持续更新...... 

[awesome-open-gpt](https://github.com/EwingYangs/awesome-open-gpt) :  Collection of Open Source Projects Related to GPT，GPT相关开源项目合集🚀、精选🔥🔥 

[awesome-chatgpt](https://github.com/humanloop/awesome-chatgpt) :  为ChatGPT和GPT-3编写的很棒的工具、演示和文档列表

[awesome-gpt4](https://github.com/radi-cho/awesome-gpt4) :  有关GPT-4语言模型的提示、工具和资源的精心策划的列表。

[Awesome-ChatGPT](https://github.com/runningcheese/Awesome-ChatGPT) :  奶酪清单！ChatGPT相关知识 

[awesome-gpt](https://github.com/formulahendry/awesome-gpt) :  与GPT、ChatGPT、OpenAI、LLM等相关的精彩项目和资源的列表。

[awesome-instruction-dataset](https://github.com/yaodongC/awesome-instruction-dataset) :  一个开源数据集的集合，用于训练LLM之后的指令微调（ChatGPT、LLaMA、Alpaca） 

[LLMSurvey](https://github.com/RUCAIBox/LLMSurvey) :  调查论文“大型语言模型调查”的官方GitHub页面。

[awesome-langchain](https://github.com/kyrolabs/awesome-langchain) :  很棒的工具和项目列表与很棒的LangChain框架

[awesome-pretrained-chinese-nlp-models](https://github.com/lonePatient/awesome-pretrained-chinese-nlp-models) :  高质量中文预训练模型&大模型&多模态模型&大语言模型集合 

[Awesome-Multimodal-Large-Language-Models](https://github.com/BradyFU/Awesome-Multimodal-Large-Language-Models) : 关于多模态大语言模型的最新论文和数据集及其评估。 

[awesome-LLMs-In-China](https://github.com/wgwang/awesome-LLMs-In-China) : 中国大模型

[awesome-open-foundation-models](https://github.com/wgwang/awesome-open-foundation-models) :  开源开放的基础大模型列表

[awesome-LLM-benchmarks](https://github.com/wgwang/awesome-LLM-benchmarks) :   大模型评测数据集和工具大全，涵盖文本、代码、图像、声音、视频以及跨模态等。 

[Awesome-Chinese-LLM](https://github.com/HqWu-HITCS/Awesome-Chinese-LLM) :  整理开源的中文大语言模型，以规模较小、可私有化部署、训练成本较低的模型为主，包括底座模型，垂直领域微调及应用，数据集与教程等。 

[Awesome-Domain-LLM](https://github.com/luban-agi/Awesome-Domain-LLM) :  收集和梳理垂直领域的开源模型、数据集及评测基准。 

[DecryptPrompt](https://github.com/DSXiangLi/DecryptPrompt) :  总结Prompt&LLM论文，开源数据&模型，AIGC应用 

[Awesome-Open-domain-Dialogue-Models](https://github.com/cingtiye/Awesome-Open-domain-Dialogue-Models) :  Awesome Open-domain Dialogue Models，高质量开放域对话模型集合 

[LLMDataHub](https://github.com/Zjh-819/LLMDataHub) :  趋势指令微调数据集（LLM的SFT数据集、PT数据集、RLHF数据集）的快速指南

[NLPer-Arsenal](https://github.com/TingFree/NLPer-Arsenal) :  收录NLP竞赛策略实现、各任务baseline、相关竞赛经验贴（当前赛事、往期赛事、训练赛）、NLP会议时间、常用自媒体、GPU推荐等 

[awesome-llm-apps](https://github.com/Shubhamsaboo/awesome-llm-apps) :  使用OpenAI、Anthropic、Gemini和开源模型的RAG的出色LLM应用程序集合。

[llm-app](https://github.com/pathwaycom/llm-app) :  企业级动态RAG。已准备好使用Docker运行，⚡与Sharepoint、Google Drive、S3、Kafka、PostgreSQL、实时数据API等同步。

[Awesome-LLM-RAG-Application](https://github.com/lizhe2004/Awesome-LLM-RAG-Application) :  基于RAG的LLM应用资源

[Awesome-Text2SQL](https://github.com/eosphoros-ai/Awesome-Text2SQL) :   这里收集了针对大型语言模型、Text2SQL、[Text2DSL](https://github.com/eosphoros-ai/Awesome-Text2SQL/blob/main/Text2DSL.md)、 [Text2API](https://github.com/eosphoros-ai/Awesome-Text2SQL/blob/main/Text2API.md)、 [Text2Vis](https://github.com/eosphoros-ai/Awesome-Text2SQL/blob/main/Text2Vis.md) 等的精选教程和资源。 

[NL2SQL](https://github.com/yechens/NL2SQL) :  Text2SQL 语义解析数据集、解决方案、paper资源整合项目 

[awesome-chatgpt-dataset](https://github.com/voidful/awesome-chatgpt-dataset) :  释放LLM的力量：探索这些数据集来训练你自己的ChatGPT！ 

[Awesome-LLM-Reasoning](https://github.com/atfortes/Awesome-LLM-Reasoning) :  大语言模型中的reasoning ：论文和资源，包括思维链和 OpenAI o1 🍓 

[Awesome-LLM-Strawberry](https://github.com/hijkzzz/Awesome-LLM-Strawberry) :  大语言模型LLM的论文、博客和项目的集合，重点关注OpenAI o1和 reasoning 技术。

[Awesome-LLMOps](https://github.com/tensorchord/Awesome-LLMOps) :  为开发人员精心策划的最佳LLMOps部署推理运维工具列表 

[awesome-LLM-resourses](https://github.com/WangRongsheng/awesome-LLM-resourses) :  🧑‍🚀 全世界最好的LLM资料总结 | Summary of the world's best LLM resources. 

[Awesome-LLM-Robotics](https://github.com/GT-RIPL/Awesome-LLM-Robotics) :  使用大型语言/多模态模型进行机器人/强化学习RL的论文综合列表，包括论文、代码和相关网站 

[Awesome-LLM-Inference](https://github.com/DefTruth/Awesome-LLM-Inference) :  📖精选的Awesome LLM推理论文列表，包括代码、TensorRT LLM、vLLM、流式LLM、AWQ、SmoothQuant、WINT8/4、连续批处理、FlashAttention、PagedAttention等。

[Awesome-LLM-RAG](https://github.com/jxzhangjhu/Awesome-LLM-RAG) :  Awesome LLM RAG：大型语言模型中高级检索增强生成（RAG）的精选列表

[Awesome-LLM-Compression](https://github.com/HuangOwen/Awesome-LLM-Compression) :  很棒的LLM模型压缩研究论文和工具。 

[Awesome-LLMs-on-device](https://github.com/NexaAI/Awesome-LLMs-on-device) :  端侧设备上出色的LLMs：综合调查 

[Awesome-LLMs-Datasets](https://github.com/lmmlzn/Awesome-LLMs-Datasets) :  总结现有的代表性LLM文本数据集。

[awesome-ml](https://github.com/underlines/awesome-ml) :  有用的LLM/分析/数据科学资源精选列表 

[awesome-llm-security](https://github.com/corca-ai/awesome-llm-security) :  一系列关于LLM Security大模型安全的出色工具、文档和项目。

[Awesome-LLM4AD](https://github.com/Thinklab-SJTU/Awesome-LLM4AD) :  精心策划的自动驾驶大模型LLM资源列表

[awesome-llm-powered-agent](https://github.com/hyp1231/awesome-llm-powered-agent) :  关于LLM驱动的Agent的很棒的列表：论文/转载/博客 

[awesome-llm-json](https://github.com/imaurer/awesome-llm-json) :  通过函数调用、工具、CFG使用LLM生成JSON的资源列表。图书馆、模型、笔记本等。

[Awesome-Code-LLM](https://github.com/codefuse-ai/Awesome-Code-LLM) : 代码和相关数据集的大语言建模研究精选列表。 

[awesome-llm-interpretability](https://github.com/JShollaj/awesome-llm-interpretability) :  大型语言模型（LLM）可解释性资源的精选列表。

[Awesome-Graph-LLM](https://github.com/XiaoxinHe/Awesome-Graph-LLM) :  关于图相关LLM的一系列精彩内容。 

[Awesome-GPT-Agents](https://github.com/fr0gger/Awesome-GPT-Agents) :  精心策划的网络安全的大模型GPT Agent列表

[LLM4Rec-Awesome-Papers](https://github.com/WLiK/LLM4Rec-Awesome-Papers) : 大型语言模型推荐系统（LLM）的优秀论文和资源列表。

[Awesome-LLM-KG](https://github.com/RManLuo/Awesome-LLM-KG) :  关于整合大语言模型LLM和知识图谱的精彩论文 

[awesome_LLMs_interview_notes](https://github.com/jackaduma/awesome_LLMs_interview_notes) :  LLMs interview notes and answers:该仓库主要记录大模型（LLMs）算法工程师相关的面试题和参考答案



## Speech

[awesome-speech-recognition-speech-synthesis-papers](https://github.com/zzw922cn/awesome-speech-recognition-speech-synthesis-papers) ： 自动语音识别（ASR）、说话人确认、语音合成、文本到语音（TTS）、语言建模、歌唱语音合成（SVS）、语音转换（VC）

 [Speech-Separation-Paper-Tutorial](https://github.com/JusperLee/Speech-Separation-Paper-Tutorial) ： 基于神经网络的语音分离的必读论文 

[speech-recognition-papers](https://github.com/wenet-e2e/speech-recognition-papers):  面向工业端到端语音识别的热点方向 

[awesome-data-augmentation](https://github.com/CrazyVertigo/awesome-data-augmentation)![](https://img.shields.io/github/stars/CrazyVertigo/awesome-data-augmentation.svg?style=social)： 这是一个关于数据增强的很棒的方法列表。 

[Awesome-SLP](https://github.com/BenSaunders27/Awesome-SLP.git):  精选的手语产品工作清单 。

 [Awesome-SLU-Survey](https://github.com/yizhen20133868/Awesome-SLU-Survey) ：口语理解研究综述：最新进展和新前沿

[speech_dataset](https://github.com/double22a/speech_dataset):  语音识别数据集 

[awesome_OpenSetRecognition_list](https://github.com/iCGY96/awesome_OpenSetRecognition_list):  开放集识别、 分布外 (OoD) 泛化 、 开放集域适应和 开放世界识别 相关的论文和资源的策划列表

[Awesome-Speech-Enhancement](https://github.com/nanahou/Awesome-Speech-Enhancement) ：为语音增强研究人员和实践者提供的教程。本项目的目的是整理全世界用于语音增强的资源，使其普遍可用。

[awesome-speech-enhancement](https://github.com/WenzheLiu-Speech/awesome-speech-enhancement) :  语音增强，语音分离，声源定位

[speech_data_augment](https://github.com/zzpDapeng/speech_data_augment) : 语音数据增强算法总结

[wer_are_we](https://github.com/syhw/wer_are_we) : 尝试跟踪语音识别的最新研究成果（参考文献）。

[awesome-diarization](https://github.com/wq2012/awesome-diarization) :  这是一份精心策划的说话人分割聚类（也叫声纹分割聚类、说话人日志）列表，包括论文、库、数据集和其他资源。

[awesome-audio-visualization](https://github.com/willianjusten/awesome-audio-visualization) :  关于音频可视化的策划列表。

[awesome-deep-learning-music](https://github.com/ybayle/awesome-deep-learning-music) :  关于音乐领域的深度学习相关的文章列表

[speech-language-processing](https://github.com/edobashira/speech-language-processing) :  语音和自然语言处理资源的精选列表

[speech-synthesis-paper](https://github.com/wenet-e2e/speech-synthesis-paper) :  语音合成论文列表。 

[SpeechAlgorithms](https://github.com/Ryuk17/SpeechAlgorithms) :  语音算法集合 

[awesome-vad](https://github.com/bigcash/awesome-vad) : 语音端点检测

[SER-datasets](https://github.com/SuperKogito/SER-datasets) :  用于语音中情绪识别/检测的数据集集合。

[awesome-openai-whisper](https://github.com/ancs21/awesome-openai-whisper) : OpenAI's Whisper的ASR语音识别相关的精彩集合 

[Tutorial_Separation](https://github.com/gemengtju/Tutorial_Separation) :  总结了语音分离和说话人抽取任务的教程、数据集、论文、代码和工具。

[open-speech-corpora](https://github.com/coqui-ai/open-speech-corpora) :  💎ASR、TTS和其他语音技术的可访问的语音语料库、语音数据集列表

[awesome-vits](https://github.com/34j/awesome-vits) :  VITS相关的代码库

[Awesome-Text-to-Speech-TTS](https://github.com/TouchSky-Lab/Awesome-Text-to-Speech-TTS) :  TTS

[awesome-tts-samples](https://github.com/seungwonpark/awesome-tts-samples) :  TTS相关的论文或代码库

[awesome-disfluency-detection](https://github.com/pariajm/awesome-disfluency-detection) :  非常棒的文本不流畅检测，包括代码和论文，可以对ASR的结果结果进行文本流畅处理。

[WeDataset](https://github.com/wenet-e2e/wenet/issues/2094): 开源语音数据集列表+爬虫资源列表



## Others

[anomaly-detection-resources](https://github.com/yzhao062/anomaly-detection-resources) : 异常检测相关书籍、论文、视频和工具箱

[awesome-anomaly-detection](https://github.com/hoya012/awesome-anomaly-detection) :  精心策划的异常检测资源列表

[Surface-Defect-Detection](https://github.com/Charmve/Surface-Defect-Detection) :   不断总结开源数据集和表面缺陷研究领域的重要论文。

[Awesome-Meta-Learning](https://github.com/sudharsan13296/Awesome-Meta-Learning) :  元学习（学习如何去学习）相关的论文、代码、书籍、博客、视频、数据集和其他资源的策划列表。

[GitHub-Chinese-Top-Charts](https://github.com/GrowingGit/GitHub-Chinese-Top-Charts) :  🇨🇳 GitHub中文排行榜，各语言分离设置「软件 / 资料」榜单，精准定位中文好项目。各取所需，互不干扰，高效学习。

[state-of-the-art-result-for-machine-learning-problems](https://github.com/RedditSota/state-of-the-art-result-for-machine-learning-problems) :  该存储库为所有机器学习问题提供最先进的（SoTA）结果。我们尽最大努力使此存储库保持最新。如果您发现某个问题的SoTA结果已过期或缺失，请将其作为问题提出，或提交谷歌表格（包含以下信息：研究论文名称、数据集、指标、源代码和年份）。

[PyTorchTricks](https://github.com/lartpang/PyTorchTricks) :  pytorch的一些技巧... ⭐ 

[Awesome-pytorch-list-CNVersion](https://github.com/xavier-zy/Awesome-pytorch-list-CNVersion) : 厉害的Pytorch项目，翻译工作进行中...... 

[Awesome-pytorch-list](https://github.com/bharathgs/Awesome-pytorch-list) :  github上pytorch相关内容的综合列表，如不同的模型、实现、帮助库、教程等。

[deeplearning-models](https://github.com/rasbt/deeplearning-models) :  各种深度学习架构、模型和技巧的集合

[awesome-data-labeling](https://github.com/heartexlabs/awesome-data-labeling) :  精心策划的优秀数据标注工具列表 

[Awesome-Learning-with-Label-Noise](https://github.com/subeeshvasu/Awesome-Learning-with-Label-Noise) :  一份精心策划的有噪声标注数据集下模型如何学习训练的资源清单

[awesome-music-production](https://github.com/ad-si/awesome-music-production.git):  用于创建和分发音乐的软件、服务和资源的精选列表。 

[leetcode-master](https://github.com/youngyangyang04/leetcode-master) ： 《代码随想录》LeetCode 刷题攻略：200道经典题目刷题顺序，共60w字的详细图解，视频难点剖析，50余张思维导图，支持C++，Java，Python，Go，JavaScript等多语言版本，从此算法学习不再迷茫！🔥🔥 来看看，你会发现相见恨晚！🚀 

[awesome-python-login-model](https://github.com/Kr1s77/awesome-python-login-model) ： 😮python模拟登陆一些大型网站，还有一些简单的爬虫， 

[awesome-spider](https://github.com/facert/awesome-spider) :  爬虫集合 

[awesome-python](https://github.com/vinta/awesome-python) :  一份精心策划的优秀Python框架、库、软件和资源列表 

[awesome-remote-job](https://github.com/lukasz-madon/awesome-remote-job) :  精心策划的远程工作和资源列表。 

[public-apis](https://github.com/public-apis/public-apis) :  免费API的集合列表

[Public-APIs](https://github.com/n0shake/Public-APIs) :  📚 来自网络的API公开列表。

[public-api-lists](https://github.com/public-api-lists/public-api-lists) : 用于软件和web开发的免费API的集合列表🚀 

[lists](https://github.com/jnv/lists) :   在 GitHub 上整理的有用的、搞笑的和很棒的列表。  

[interview](https://github.com/Olshansk/interview) :  准备技术面试所需的一切

[A-to-Z-Resources-for-Students](https://github.com/dipakkr/A-to-Z-Resources-for-Students) :  ✅ 为大学生策划的资源清单 

[awesome-math](https://github.com/rossant/awesome-math) :  一份精心策划的数学资源清单

[awesome-raspberry-pi](https://github.com/thibmaek/awesome-raspberry-pi) :  📝 这是一份精心策划的列表，其中包括很棒的树莓派工具、项目、图像和资源 

[science-based-games-list](https://github.com/stared/science-based-games-list) :  基于科学的游戏-合作列表 

[awesome-SLAM-list](https://github.com/OpenSLAM/awesome-SLAM-list) :  awesome-SLAM-list 

[awesome-slam](https://github.com/kanster/awesome-slam) :  一份精心策划的很棒的SLAM教程、项目和社区列表。 

[SLAM-All-In-One](https://github.com/zhouyong1234/SLAM-All-In-One) :  SLAM汇总，包括多传感器融合建图、定位、VIO系列、常用工具包、开源代码注释和公式推导、文章综述 

[awesome-robotics](https://github.com/kiloreux/awesome-robotics) :  非常棒的机器人资源列表

[TopDeepLearning](https://github.com/aymericdamien/TopDeepLearning) :  深度学习相关的热门github项目列表

[awesome-ai-residency](https://github.com/dangkhoasdc/awesome-ai-residency) :  AI实习计划列表清单

[ICRA2020-paper-list](https://github.com/PaoPaoRobot/ICRA2020-paper-list) :  ICRA2020：2020年IEEE机器人与自动化国际会议。

[RSPapers](https://github.com/hongleizhang/RSPapers) :  推荐系统的必读论文策划清单。

[Awesome-Embedded](https://github.com/nhivp/Awesome-Embedded) :  一份精心策划的优秀嵌入式编程列表。 

[useful-computer-vision-phd-resources](https://github.com/hassony2/useful-computer-vision-phd-resources) :  对我的计算机视觉博士学位有用的资源列表 

[spatio-temporal-paper-list](https://github.com/Eilene/spatio-temporal-paper-list) :  Spatio-temporal modeling 论文列表（主要是graph convolution相关) 

[awesome-self-supervised-learning](https://github.com/jason718/awesome-self-supervised-learning) :  精心策划的自监督方法列表

[medical-imaging-datasets](https://github.com/sfikas/medical-imaging-datasets) :  医疗成像数据集列表。

[awesome-roadmaps](https://github.com/liuchong/awesome-roadmaps) : 一份精心策划的学习路线图清单。

[EEG-Datasets](https://github.com/meagmohit/EEG-Datasets) :  所有公共脑电图数据集的列表

[MARL-Papers](https://github.com/LantaoYu/MARL-Papers) :  多智能体强化学习（MARL）论文列表

[awesome-multimodal-ml](https://github.com/pliang279/awesome-multimodal-ml) :  多模态机器学习研究主题阅读清单

[Awesome-Multimodal-Research](https://github.com/Eurus-Holmes/Awesome-Multimodal-Research) :  多模态相关研究的策划清单。 

[deep-reinforcement-learning-papers](https://github.com/junhyukoh/deep-reinforcement-learning-papers) :  关于深度强化学习的最新论文列表

[awesome-machine-learning-interpretability](https://github.com/jphall663/awesome-machine-learning-interpretability) :  精心策划的机器学习可解释性资源列表。

[awesome-fast-attention](https://github.com/Separius/awesome-fast-attention) : 高效注意力模块列表

[deeplearning-biology](https://github.com/hussius/deeplearning-biology) :  生物学深度学习实现相关的清单

[FreeML](https://github.com/Shujian2015/FreeML) :  数据科学/机器学习资源列表（大部分免费）

[Paper-List](https://github.com/ConanCui/Paper-List) :  每天维护的在读论文的清单

[awesome-jupyter](https://github.com/markusschanta/awesome-jupyter) :  精心策划的优秀Jupyter项目、图书馆和资源列表 

[the-incredible-pytorch](https://github.com/ritchieng/the-incredible-pytorch) :  不可思议的PyTorch：一份精心策划的关于PyTorch的教程、论文、项目、社区和更多内容的列表。

[awesome-quant](https://github.com/wilsonfreitas/awesome-quant) :  为量化金融（Quant Finance）策划了一份非常棒的库、软件包和资源列表

[awesome-quant](https://github.com/thuquant/awesome-quant) :  中国的Quant相关资源索引 

[awesome-community-detection](https://github.com/benedekrozemberczki/awesome-community-detection) :  一份经过策划的社区检测研究论文清单及其实现。

[awesome-robotics-libraries](https://github.com/jslee02/awesome-robotics-libraries) :  😎 一份精心策划的机器人技术库和软件列表 

[awesome_time_series_in_python](https://github.com/MaxBenChrist/awesome_time_series_in_python) :  这个精心策划的列表包含用于时间序列分析的python包

[awesome-rnn](https://github.com/kjw0612/awesome-rnn) : 递归神经网络——专门用于RNN的精心策划的资源列表 

[awesome-random-forest](https://github.com/kjw0612/awesome-random-forest) :  随机森林——关于随机森林的精选资源列表

[awesome-adversarial-machine-learning](https://github.com/yenchenlin/awesome-adversarial-machine-learning) :  一份精心策划的很棒的对抗性机器学习资源列表

[awesome-awesome](https://github.com/emijrp/awesome-awesome) :  这是一份精心策划的清单，里面有很多精彩的主题。

[VR-Awesome](https://github.com/Vytek/VR-Awesome) :  很棒的VR相关列表 

[machine-learning-surveys](https://github.com/metrofun/machine-learning-surveys) :  一份精心策划的机器学习调查、综述、教程和书籍清单。 

[awesome-rl](https://github.com/aikorea/awesome-rl) :  强化学习资源列表 

[awesome-knowledge-distillation](https://github.com/dkozlov/awesome-knowledge-distillation) : 很棒的知识蒸馏

[Awesome-Incremental-Learning](https://github.com/xialeiliu/Awesome-Incremental-Learning) :  很棒的增量学习/终身学习 

[awesome-graph-classification](https://github.com/benedekrozemberczki/awesome-graph-classification) :  一系列重要的图形嵌入、分类和表示学习论文及其实现。

[Awesome-Transformer-Attention](https://github.com/cmhungsteve/Awesome-Transformer-Attention) ： Vision Transformer/注意力的最终综合论文列表，包括论文、代码和相关网站

[awesome-public-datasets](https://github.com/awesomedata/awesome-public-datasets) :  高质量的公开数据集列表。

[awesome-ai-in-finance](https://github.com/georgezouq/awesome-ai-in-finance) :  🔬 金融领域中很棒的机器学习策略和工具。

[Awesome-explainable-AI](https://github.com/wangyongjie-ntu/Awesome-explainable-AI) :  可解释AI/ML研究材料集

[Awesome-Federated-Learning](https://github.com/chaoyanghe/Awesome-Federated-Learning) :  很棒的联邦学习列表

[Awesome-AI-Security](https://github.com/DeepSpaceHarbor/Awesome-AI-Security) :  人工智能安全资源精选列表，灵感来自于 [awesome-adversarial-machine-learning](https://github.com/yenchenlin/awesome-adversarial-machine-learning) & [awesome-ml-for-cybersecurity](https://github.com/jivoi/awesome-ml-for-cybersecurity). 

[awesome-deep-rl](https://github.com/tigerneil/awesome-deep-rl) :  深度强化学习和人工智能的未来。

[awesome-fashion-ai](https://github.com/ayushidalmia/awesome-fashion-ai) :  一个存储库，用于整理和总结与时尚和电子商务相关的研究论文

[awesome-blockchain-ai](https://github.com/steven2358/awesome-blockchain-ai) :   人工智能和机器学习的区块链项目精选列表 

[awesome-starcraftAI](https://github.com/SKTBrain/awesome-starcraftAI) :  专门用于星际争霸 AI 的精选资源列表。 

[awesome-game-ai](https://github.com/datamllab/awesome-game-ai) :  很棒的多智能体强化学习的游戏AI素材 

[awesome-feature-engineering](https://github.com/aikho/awesome-feature-engineering) :  专门用于机器学习的特征工程技术的资源列表

[awesome-ai-usecases](https://github.com/JosPolfliet/awesome-ai-usecases) :  一系列很棒的且经过验证的人工智能用例和应用程序 

[lite.ai.toolkit](https://github.com/DefTruth/lite.ai.toolkit) : 一个lite C++工具包，包含了ONNXRuntime、NCNN、MNN和TNN的很棒的人工智能模型。YOLOX, YOLOP, YOLOv6, YOLOR, MODNet, YOLOX, YOLOv7, YOLOv5. MNN, NCNN, TNN, ONNXRuntime. 

[awesome-ai](https://github.com/hades217/awesome-ai) :  人工智能资源（课程、工具、应用程序、开源项目）的精选列表

[500-AI-Machine-learning-Deep-learning-Computer-vision-NLP-Projects-with-code](https://github.com/ashishpatel26/500-AI-Machine-learning-Deep-learning-Computer-vision-NLP-Projects-with-code) :  500+人工智能机器学习深度学习计算机视觉NLP项目代码

[knowledge-distillation-papers](https://github.com/lhyfst/knowledge-distillation-papers) :  知识蒸馏论文

[Awesome_Continual-Lifelong-Incremental_learning](https://github.com/chengsilin/Awesome_Continual-Lifelong-Incremental_learning) : 持续增量学习

[Awesome-Few-Shot-Class-Incremental-Learning](https://github.com/zhoudw-zdw/Awesome-Few-Shot-Class-Incremental-Learning) : 小样本持续增量学习

[awesome-gcn](https://github.com/Jiakui/awesome-gcn) :   图卷积神经网络相关资源  

[Awesome-Deep-Graph-Clustering](https://github.com/yueliu1999/Awesome-Deep-Graph-Clustering) :  深度图聚类的SOTA集合，包括论文、代码、数据集

[awesome-denovo-papers](https://github.com/asarigun/awesome-denovo-papers) :  全新药物设计的论文集合 

[awesome-lidar](https://github.com/szenergy/awesome-lidar) : 激光雷达列表。该列表包括激光雷达制造商、数据集、点云处理算法、点云框架和模拟器。

[awesome-self-supervised-gnn](https://github.com/ChandlerBang/awesome-self-supervised-gnn) :  关于图形神经网络（GNN）的预训练和自监督学习的论文

[ai-collection](https://github.com/ai-collection/ai-collection) : 生成式 AI 大观园 - 一组很棒的生成式 AI 应用程序

[papers-we-love](https://github.com/papers-we-love/papers-we-love) :  大量来自计算机科学社区的论文，可供阅读和讨论。

[Awesome-Autonomous-Driving](https://github.com/autodriving-heart/Awesome-Autonomous-Driving) :  自动驾驶