# Awesome AI List Guide

The guide of awesome list  about **AI**  ( a.k.a., **artificial intelligence**,  **machine learning**, **deep learning**)

 **The list is in no particular order!!!**

 Pull requests are welcome! 

[English](README.md) | [中文](README_ch.md)

# Table of Contents

- [Tutorials](#Tutorials)
- [CV](#CV)
- [NLP](#NLP)
- [Speech](#Speech)
- [Others](#Others)



## Tutorials

[awesome-for-beginners](https://github.com/MunGell/awesome-for-beginners):   A list of awesome beginners-friendly projects. 

[Awesome production machine learning](https://github.com/EthicalML/awesome-production-machine-learning.git):  A curated list of awesome open source libraries to deploy, monitor, version and scale your machine learning 

[awesome-ai-infrastructures](https://github.com/1duo/awesome-ai-infrastructures) :   Infrastructures™ for Machine Learning Training/Inference in Production.  

[Production-Level-Deep-Learning](https://github.com/alirezadir/Production-Level-Deep-Learning):  A guideline for building practical production-level deep learning systems to be deployed in real world applications. 

[competition_baselines](https://github.com/LogicJake/competition_baselines) : Open competition's baseline

[competition-baseline](https://github.com/datawhalechina/competition-baseline) :  Knowledge, code and ideas of data science competition

[paper-reproduction-tutorials](https://github.com/PaddleEdu/paper-reproduction-tutorials) ： The skill of reproducing papers and sharing PaddlePaddle outstanding projects

[awesome-mlops](https://github.com/visenger/awesome-mlops) :   A curated list of references for MLOps 

[awesome-machine-learning](https://github.com/josephmisiti/awesome-machine-learning) ： A curated list of awesome Machine Learning frameworks, libraries and software. 

[Learn-Data-Science-For-Free](https://github.com/therealsreehari/Learn-Data-Science-For-Free) ： This repositary is a combination of different resources lying scattered all over the internet. The reason for making such an repositary is to combine all the valuable resources in a sequential manner, so that it helps every beginners who are in a search of free and structured learning resource for Data Science. For Constant Updates Follow me in … 

[best-of-ml-python](https://github.com/ml-tooling/best-of-ml-python) ： 🏆 A ranked list of awesome machine learning Python libraries. Updated weekly. 

[build-your-own-x](https://github.com/danistefanovic/build-your-own-x) :  🤓 Build your own (insert technology here) 

[tensorflow_practice](https://github.com/princewen/tensorflow_practice) :  Tensorflow practice, including reinforcement learning, recommendation system, NLP, etc 

[awesome-courses](https://github.com/prakhar1989/awesome-courses) :  📚 List of awesome university courses for learning Computer Science! 

[MT-Reading-List](https://github.com/THUNLP-MT/MT-Reading-List) :  A machine translation reading list maintained by Tsinghua Natural Language Processing Group 

[cs-video-courses](https://github.com/Developer-Y/cs-video-courses) :  List of Computer Science courses with video lectures. 

[machine-learning-surveys](https://github.com/metrofun/machine-learning-surveys) :  A curated list of Machine Learning Surveys, Tutorials and Books. 

[data-science-blogs](https://github.com/rushter/data-science-blogs) :  A curated list of data science blogs 

[awesome-tensorflow](https://github.com/jtoy/awesome-tensorflow) :  TensorFlow - A curated list of dedicated resources 

[ds-cheatsheets](https://github.com/FavioVazquez/ds-cheatsheets) :  List of Data Science Cheatsheets to rule the world 

[awesome-R](https://github.com/qinwf/awesome-R) :  A curated list of awesome R packages, frameworks and software. 

[awesome-youtubers](https://github.com/JoseDeFreitas/awesome-youtubers) :  ▶️ An awesome list of awesome YouTubers that teach about technology. Tutorials about web development, computer science, machine learning, game development, cybersecurity, and more. 

[Book_List](https://github.com/mukeshmithrakumar/Book_List) :  Python, Machine Learning, Deep Learning and Data Science Books 

[awesome-deep-learning](https://github.com/ChristosChristofidis/awesome-deep-learning) :  A curated list of awesome Deep Learning tutorials, projects and communities. 

[awesome-artificial-intelligence](https://github.com/owainlewis/awesome-artificial-intelligence) :  A curated list of Artificial Intelligence (AI) courses, books, video lectures and papers. 

[awesome-project-ideas](https://github.com/NirantK/awesome-project-ideas) :  Curated list of Machine Learning, NLP, Vision, Recommender Systems Project Ideas 

[awesome-datascience](https://github.com/academic/awesome-datascience) :  📝 An awesome Data Science repository to learn and apply for real world problems. 

[awesome-deep-learning-papers](https://github.com/terryum/awesome-deep-learning-papers) :  The most cited deep learning papers 

[awesome-machine-learning-cn](https://github.com/jobbole/awesome-machine-learning-cn) : Machine learning resources of Chinese version, including the framework, library and software in the field of machine learning

[Awesome-PyTorch-Chinese](https://github.com/INTERMT/Awesome-PyTorch-Chinese) :  the most complete pytorch learning resources in history

[awesome-AI-books](https://github.com/zslucky/awesome-AI-books) :  Some awesome AI related books and pdfs for learning and downloading, also apply some playground models for learning 

[awesome-ml-courses](https://github.com/luspr/awesome-ml-courses) :  Awesome free machine learning and AI courses with video lectures. 

[awesome-ai-ml-dl](https://github.com/neomatrix369/awesome-ai-ml-dl) :  Awesome Artificial Intelligence, Machine Learning and Deep Learning as we learn it. Study notes and a curated list of awesome resources of such topics. 

[Awesome-Noah](https://github.com/AI-Sphere/Awesome-Noah) :   Awesome Top Solution List of Excellent AI Competitions 

[my-awesome-AI-bookmarks](https://github.com/goodrahstar/my-awesome-AI-bookmarks) :  Curated list of my reads, implementations and core concepts of Artificial Intelligence, Deep Learning, Machine Learning by best folk in the world. 

[awesome-DeepLearning](https://github.com/PaddlePaddle/awesome-DeepLearning) :  The course, case and knowledge of Deep Learning and AI 

[Machine-Learning-Collection](https://github.com/aladdinpersson/Machine-Learning-Collection) :  A resource for learning about Machine learning & Deep Learning 

[DeepLearningSystem](https://github.com/chenzomi12/DeepLearningSystem) :  Deep Learning System core principles introduction. 

[free-programming-books](https://github.com/EbookFoundation/free-programming-books) :  📚 Freely available programming books 

[research-method](https://github.com/secdr/research-method) :  Paper Writing and Resources Sharing



## CV

[awesome-hand-pose-estimation](https://github.com/xinghaochen/awesome-hand-pose-estimation):  Awesome work on hand pose estimation/tracking 

[CV-Backbones](https://github.com/huawei-noah/CV-Backbones) :  CV backbones including GhostNet, TinyNet and TNT, developed by Huawei Noah's Ark Lab.  

[SceneTextPapers](https://github.com/Jyouhou/SceneTextPapers.git):   Tracking the latest progress in Scene Text Detection and Recognition: Must-read papers well organized 

[Awesome-GANs](https://github.com/kozistr/Awesome-GANs) :  Awesome Generative Adversarial Networks with tensorflow 

[OCR_DataSet](https://github.com/WenmuZhou/OCR_DataSet) :  Collect and sort out the data set related to OCR and unify the annotation format for the needs of the experiment 

[awesome-ocr](https://github.com/wanghaisheng/awesome-ocr) :  A curated list of promising OCR resources 

[Awesome-Table-Recognition](https://github.com/cv-small-snails/Awesome-Table-Recognition) :  A curated list of resources dedicated to table recognition 

[awesome-object-detection](https://github.com/amusi/awesome-object-detection) :  Awesome Object Detection based on handong1587 github 

[deep_learning_object_detection](https://github.com/hoya012/deep_learning_object_detection) :  A paper list of object detection using deep learning. 

[awesome-captcha](https://github.com/ZYSzys/awesome-captcha) :  🔑 Curated list of awesome captcha libraries and crack tools.

[image-to-image-papers](https://github.com/lzhbrian/image-to-image-papers) :  🦓<->🦒 🌃<->🌆 A collection of image to image papers with code (constantly updating) 

[Deep-Learning-Papers-Reading-Roadmap](https://github.com/floodsung/Deep-Learning-Papers-Reading-Roadmap) :  Deep Learning papers reading roadmap for anyone who are eager to learn this amazing tech! 

[benchmark_results](https://github.com/foolwood/benchmark_results) :  Visual Tracking Paper List 

[awesome_3DReconstruction_list](https://github.com/openMVG/awesome_3DReconstruction_list) :  A curated list of papers & resources linked to 3D reconstruction from images. 

[the-gan-zoo](https://github.com/hindupuravinash/the-gan-zoo) :  A list of all named GANs! 

[awesome-computer-vision](https://github.com/jbhuang0604/awesome-computer-vision) :  A curated list of awesome computer vision resources 

[multi-object-tracking-paper-list](https://github.com/SpyderXu/multi-object-tracking-paper-list) :  Paper list and source code for multi-object-tracking 

[awesome-deep-vision](https://github.com/kjw0612/awesome-deep-vision) :  A curated list of deep learning resources for computer vision 

[AdversarialNetsPapers](https://github.com/zhangqianhui/AdversarialNetsPapers) :  Awesome paper list with code about generative adversarial nets (gan)

[awesome-lane-detection](https://github.com/amusi/awesome-lane-detection) :  A paper list of lane detection. 

[Paper_Reading_List](https://github.com/ArcherFMY/Paper_Reading_List) :   Recommended Papers. Subjects: Computer Vision and Pattern Recognition (cs.CV); Artificial Intelligence (cs.AI); Learning (cs.LG) 

[awesome-network-embedding](https://github.com/chihming/awesome-network-embedding) :  A curated list of network embedding techniques. 

[gans-awesome-applications](https://github.com/nashory/gans-awesome-applications) :  Curated list of awesome GAN applications and demo 

[WeakSupervisedSegmentationList](https://github.com/JackieZhangdx/WeakSupervisedSegmentationList) :  This repository contains lists of state-or-art weakly supervised semantic segmentation works 

[awesome-action-recognition](https://github.com/jinwchoi/awesome-action-recognition) :  A curated list of action recognition and related area resources 

[really-awesome-gan](https://github.com/nightrome/really-awesome-gan) : A list of papers on Generative Adversarial (Neural) Networks 

[awesome-panoptic-segmentation](https://github.com/Angzz/awesome-panoptic-segmentation) :  Panoptic Segmentation Resources List 

[Pedestrian-Attribute-Recognition-Paper-List](https://github.com/wangxiao5791509/Pedestrian-Attribute-Recognition-Paper-List) :  Paper list on Pedestrian Attribute Recognition (PAR) and related tasks (Pattern Recognition 2021) 

[awesome-vqa](https://github.com/chingyaoc/awesome-vqa) :  Visual Q&A reading list 

[3D-Shape-Analysis-Paper-List](https://github.com/yinyunie/3D-Shape-Analysis-Paper-List) :  A list of recent papers, libraries and datasets about 3D shape/scene analysis (by topics, updating). 

[awesome-semantic-segmentation](https://github.com/mrgloom/awesome-semantic-segmentation) : awesome-semantic-segmentation

[Awesome-Crowd-Counting](https://github.com/gjy3035/Awesome-Crowd-Counting) :  Awesome Crowd Counting 

[awesome-Face_Recognition](https://github.com/ChanChiChoi/awesome-Face_Recognition) :  papers about Face Detection; Face Alignment; Face Recognition && Face Identification && Face Verification && Face Representation; Face Reconstruction; Face Tracking; Face Super-Resolution && Face Deblurring; Face Generation && Face Synthesis; Face Transfer; Face Anti-Spoofing; Face Retrieval; 

[AWESOME-FER](https://github.com/EvelynFan/AWESOME-FER) :  Top conferences & Journals focused on Facial expression recognition (FER)/ Facial action unit (FAU)  

[Awesome-Gaze-Estimation](https://github.com/cvlab-uob/Awesome-Gaze-Estimation) :  Awesome Curated List of Eye Gaze Estimation Paper 

[awesome-ai-art-image-synthesis](https://github.com/altryne/awesome-ai-art-image-synthesis) :  A list of awesome tools, ideas, prompt engineering tools, colabs, models, and helpers for the prompt designer playing with aiArt and image synthesis. Covers Dalle2, MidJourney, StableDiffusion, and open source tools. 

[Diffusion-Models-Papers-Survey-Taxonomy](https://github.com/YangLing0818/Diffusion-Models-Papers-Survey-Taxonomy) :  Diffusion model papers, survey, and taxonomy 

[A-Survey-on-Generative-Diffusion-Model](https://github.com/chq1155/A-Survey-on-Generative-Diffusion-Model) :  A curated list for diffusion generative models introduced by the paper 

[Awesome-Face-Restoration](https://github.com/TaoWangzj/Awesome-Face-Restoration) :  A comprehensive list of recources (papers, repositories etc.) about face restoration methods. 

[awesome-point-cloud-analysis](https://github.com/Yochengliu/awesome-point-cloud-analysis) :  A list of papers and datasets about point cloud analysis (processing) 

[awesome-ai-painting](https://github.com/hua1995116/awesome-ai-painting) :  stable diffusion tutorial、disco diffusion tutorial、 AI Platform 

[awesome-aigc](https://github.com/gongminmin/awesome-aigc) :  A list of awesome AIGC works 

[awesome-llm-and-aigc](https://github.com/codingonion/awesome-llm-and-aigc) :  A collection of some awesome public projects about Large Language Model, Vision Foundation Model and AI Generated Content. 

[awesome-text-to-video](https://github.com/jianzhnie/awesome-text-to-video) :  A Survey on Text-to-Video Generation/Synthesis. 

[Awesome-AIGC-Tutorials](https://github.com/luban-agi/Awesome-AIGC-Tutorials) :  Curated tutorials and resources for Large Language Models, AI Painting, and more. 

[Awesome-AIGC](https://github.com/wshzd/Awesome-AIGC) :  AIGC资料汇总学习，持续更新...... 



## NLP



[nlp-tutorial](https://github.com/graykode/nlp-tutorial) :  Natural Language Processing Tutorial for Deep Learning Researchers 

[language-resources](https://github.com/google/language-resources) :  Datasets and tools for basic natural language processing. 

[Summarization-Papers](https://github.com/xcfcode/Summarization-Papers) ： Summarization Papers 

[CLUEDatasetSearch](https://github.com/CLUEbenchmark/CLUEDatasetSearch) ： Search all Chinese NLP datasets, with common English NLP datasets

[nlpdemo-ch-wordlib](https://github.com/MrLi008/nlpdemo-ch-wordlib) :  Chinese Thesaurus

[ChineseNLP](https://github.com/didi/ChineseNLP) :  Datasets, SOTA results of every fields of Chinese NLP

[ChineseNLPCorpus](https://github.com/InsaneLife/ChineseNLPCorpus) :  Chinese natural language processing data set is the material for experiments at ordinary times. 中文自然语言处理数据集

[Chinese-Word-Vectors](https://github.com/Embedding/Chinese-Word-Vectors) :  100+ Chinese Word Vectors 上百种预训练中文词向量

[ChineseNlpCorpus](https://github.com/SophonPlus/ChineseNlpCorpus) :  Collect, organize and publish Chinese natural language processing corpus / data set

[nlp-competitions-list-review](https://github.com/zhpmatrix/nlp-competitions-list-review) :  Resume the top plan of all NLP competitions, only focus on NLP competitions, and keep updating! NLP比赛top方案

[funNLP](https://github.com/fighting41love/funNLP) :  Chinese and English sensitive words, language detection, Chinese and foreign mobile phone / telephone home / operator query, name inference, gender, mobile phone number extraction, ID card extraction, email extraction, and more ... 有趣的中文NLP

[nlp_chinese_corpus](https://github.com/brightmart/nlp_chinese_corpus) :  大规模中文自然语言处理语料 Large Scale Chinese Corpus for NLP 

[awesome-2vec](https://github.com/MaxwellRebo/awesome-2vec) :  Curated list of 2vec-type embedding models 

[chatbot-list](https://github.com/lizhe2004/chatbot-list) :  Share and introduce the application, architecture and algorithm of intelligent customer service and chat robot in the industry   行业内关于智能客服、聊天机器人的应用和架构、算法分享和介绍 

[awesome-chatbot-list](https://github.com/aceimnorstuvwxz/awesome-chatbot-list) :  深度学习聊天机器人资源集合 Awesome chatbot resource list 

[nmt-list](https://github.com/jonsafari/nmt-list) :  A list of Neural MT implementations 

[Question-Generation-Paper-List](https://github.com/teacherpeterpan/Question-Generation-Paper-List) :  A summary of must-read papers for Neural Question Generation (NQG) 

[awesome-nlp](https://github.com/keon/awesome-nlp) :  📖 A curated list of resources dedicated to Natural Language Processing (NLP) 

[Style-Transfer-in-Text](https://github.com/fuzhenxin/Style-Transfer-in-Text) :  Paper List for Style Transfer in Text 

[TG-Reading-List](https://github.com/THUNLP-MT/TG-Reading-List) :  A text generation reading list maintained by Tsinghua Natural Language Processing Group. 

[awesome-sentence-embedding](https://github.com/Separius/awesome-sentence-embedding) :  A curated list of pretrained sentence and word embedding models 

[Awesome-Chinese-NLP](https://github.com/crownpku/Awesome-Chinese-NLP) :  A curated list of resources for Chinese NLP 中文自然语言处理相关资料 

[*awesome*_Chinese_medical_*NLP*](https://github.com/GanjinZero/awesome_Chinese_medical_NLP) :  Arrangement of Chinese medical NLP public resources 中文医学NLP公开资源整理：术语集/语料库/词向量/预训练模型/知识图谱/命名实体识别/QA/信息抽取/模型/论文/etc 

[awesome-dl4nlp](https://github.com/brianspiering/awesome-dl4nlp) :  A curated list of awesome Deep Learning for Natural Language Processing resources 

[Awesome-Korean-NLP](https://github.com/datanada/Awesome-Korean-NLP) :  A curated list of resources for NLP (Natural Language Processing) for Korean 

[awesome-bert-nlp](https://github.com/cedrickchee/awesome-bert-nlp) :  A curated list of NLP resources focused on BERT, attention mechanism, Transformer networks, and transfer learning. 

[awesome-knowledge-graph](https://github.com/husthuke/awesome-knowledge-graph) :  a cute list of Knowledge graph

[Task-Oriented-Dialogue-Research-Progress-Survey](https://github.com/AtmaHou/Task-Oriented-Dialogue-Research-Progress-Survey) :  A datasets and methods survey about task-oriented dialogue, including recent datasets and SOTA leaderboards. 

[Text_Classification](https://github.com/kk7nc/Text_Classification) : Text Classification Algorithms: A Survey

[awesome-punctuator](https://github.com/bigcash/awesome-punctuator) :  A curated list of awesome punctuator 

[text-classification-surveys](https://github.com/xiaoqian19940510/text-classification-surveys) :  文本分类资源汇总，包括深度学习文本分类模型 

[awesome_Chinese_medical_NLP](https://github.com/GanjinZero/awesome_Chinese_medical_NLP) :  中文医学NLP公开资源整理：术语集/语料库/词向量/预训练模型/知识图谱/命名实体识别/QA/信息抽取/模型/论文/etc 

[Awesome-LLM](https://github.com/Hannibal046/Awesome-LLM) :  Awesome-LLM: a curated list of Large Language Model 

[Prompt-Engineering-Guide](https://github.com/dair-ai/Prompt-Engineering-Guide) :  Guides, papers, lecture, and resources for prompt engineering 

[PromptPapers](https://github.com/thunlp/PromptPapers) :  Must-read papers on prompt-based tuning for pre-trained language models. 

[awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts) :  This repo includes ChatGPT prompt curation to use ChatGPT better. 

[awesome-chatgpt-prompts-zh](https://github.com/PlexPt/awesome-chatgpt-prompts-zh) :  ChatGPT 中文调教指南。各种场景使用指南。学习怎么让它听你的话。 

[awesome-gpt3](https://github.com/elyase/awesome-gpt3) :  Awesome GPT-3 is a collection of demos and articles about the [OpenAI GPT-3 API](https://openai.com/blog/openai-api/). 

[Awesome-ChatGPT](https://github.com/dalinvip/Awesome-ChatGPT) :  ChatGPT资料汇总学习，持续更新...... 

[awesome-open-gpt](https://github.com/EwingYangs/awesome-open-gpt) :  Collection of Open Source Projects Related to GPT，GPT相关开源项目合集🚀、精选🔥🔥 

[awesome-chatgpt](https://github.com/humanloop/awesome-chatgpt) :  Curated list of awesome tools, demos, docs for ChatGPT and GPT-3 

[awesome-gpt4](https://github.com/radi-cho/awesome-gpt4) :  A curated list of prompts, tools, and resources regarding the GPT-4 language model. 

[Awesome-ChatGPT](https://github.com/runningcheese/Awesome-ChatGPT) :  ChatGPT related knowledge and resource

[awesome-gpt](https://github.com/formulahendry/awesome-gpt) :  A curated list of awesome projects and resources related to GPT, ChatGPT, OpenAI, LLM, and more. 

[awesome-instruction-dataset](https://github.com/yaodongC/awesome-instruction-dataset) :  A collection of open-source dataset to train instruction-following LLMs (ChatGPT,LLaMA,Alpaca) 

[LLMSurvey](https://github.com/RUCAIBox/LLMSurvey) :  The official GitHub page for the survey paper "A Survey of Large Language Models". 

[awesome-langchain](https://github.com/kyrolabs/awesome-langchain) :  Awesome list of tools and projects with the awesome LangChain framework 
[awesome-pretrained-chinese-nlp-models](https://github.com/lonePatient/awesome-pretrained-chinese-nlp-models) :   Awesome Pretrained Chinese NLP Models  

[Awesome-Multimodal-Large-Language-Models](https://github.com/BradyFU/Awesome-Multimodal-Large-Language-Models) :  Latest Papers and Datasets on Multimodal Large Language Models, and Their Evaluation. 

[awesome-LLMs-In-China](https://github.com/wgwang/awesome-LLMs-In-China) : LLMs in china

[awesome-open-foundation-models](https://github.com/wgwang/awesome-open-foundation-models) :  Open foundation models, such LLama2, ChatGLM, etc. 

[awesome-LLM-benchmarks](https://github.com/wgwang/awesome-LLM-benchmarks) :  Awesome LLM Benchmarks to evaluate the LLMs across text, code, image, audio, video and more. 

[Awesome-Chinese-LLM](https://github.com/HqWu-HITCS/Awesome-Chinese-LLM) :  整理开源的中文大语言模型，以规模较小、可私有化部署、训练成本较低的模型为主，包括底座模型，垂直领域微调及应用，数据集与教程等。 

[Awesome-Domain-LLM](https://github.com/luban-agi/Awesome-Domain-LLM) :  收集和梳理垂直领域的开源模型、数据集及评测基准。 

[DecryptPrompt](https://github.com/DSXiangLi/DecryptPrompt) :  总结Prompt&LLM论文，开源数据&模型，AIGC应用 

[Awesome-Open-domain-Dialogue-Models](https://github.com/cingtiye/Awesome-Open-domain-Dialogue-Models) :  Awesome Open-domain Dialogue Models，高质量开放域对话模型集合 

[LLMDataHub](https://github.com/Zjh-819/LLMDataHub) :  A quick guide (especially) for trending instruction finetuning datasets 

[NLPer-Arsenal](https://github.com/TingFree/NLPer-Arsenal) :  收录NLP竞赛策略实现、各任务baseline、相关竞赛经验贴（当前赛事、往期赛事、训练赛）、NLP会议时间、常用自媒体、GPU推荐等 

[awesome-llm-apps](https://github.com/Shubhamsaboo/awesome-llm-apps) :  Collection of awesome LLM apps with RAG using OpenAI, Anthropic, Gemini and opensource models. 

[llm-app](https://github.com/pathwaycom/llm-app) :  Dynamic RAG for enterprise. Ready to run with Docker,⚡in sync with Sharepoint, Google Drive, S3, Kafka, PostgreSQL, real-time data APIs, and more. 

[Awesome-LLM-RAG-Application](https://github.com/lizhe2004/Awesome-LLM-RAG-Application) :  the resources about the application based on LLM with RAG pattern 

[Awesome-Text2SQL](https://github.com/eosphoros-ai/Awesome-Text2SQL) :  Curated tutorials and resources for Large Language Models, Text2SQL, Text2DSL、Text2API、Text2Vis and more. 

[NL2SQL](https://github.com/yechens/NL2SQL) :  Text2SQL 语义解析数据集、解决方案、paper资源整合项目 

[awesome-chatgpt-dataset](https://github.com/voidful/awesome-chatgpt-dataset) :  Unlock the Power of LLM: Explore These Datasets to Train Your Own ChatGPT! 

[Awesome-LLM-Reasoning](https://github.com/atfortes/Awesome-LLM-Reasoning) :  Reasoning in Large Language Models: Papers and Resources, including Chain-of-Thought and OpenAI o1 🍓 

[Awesome-LLM-Strawberry](https://github.com/hijkzzz/Awesome-LLM-Strawberry) :  A collection of LLM papers, blogs, and projects, with a focus on OpenAI o1 and reasoning techniques. 

[Awesome-LLMOps](https://github.com/tensorchord/Awesome-LLMOps) :  An awesome & curated list of best LLMOps tools for developers 

[awesome-LLM-resourses](https://github.com/WangRongsheng/awesome-LLM-resourses) :  🧑‍🚀 全世界最好的LLM资料总结 | Summary of the world's best LLM resources. 

[Awesome-LLM-Robotics](https://github.com/GT-RIPL/Awesome-LLM-Robotics) :  A comprehensive list of papers using large language/multi-modal models for Robotics/RL, including papers, codes, and related websites 

[Awesome-LLM-Inference](https://github.com/DefTruth/Awesome-LLM-Inference) :  📖A curated list of Awesome LLM Inference Paper with codes, TensorRT-LLM, vLLM, streaming-llm, AWQ, SmoothQuant, WINT8/4, Continuous Batching, FlashAttention, PagedAttention etc. 

[Awesome-LLM-RAG](https://github.com/jxzhangjhu/Awesome-LLM-RAG) :  Awesome-LLM-RAG: a curated list of advanced retrieval augmented generation (RAG) in Large Language Models 

[Awesome-LLM-Compression](https://github.com/HuangOwen/Awesome-LLM-Compression) :  Awesome LLM compression research papers and tools. 

[Awesome-LLMs-on-device](https://github.com/NexaAI/Awesome-LLMs-on-device) :  Awesome LLMs on Device: A Comprehensive Survey 

[Awesome-LLMs-Datasets](https://github.com/lmmlzn/Awesome-LLMs-Datasets) :  Summarize existing representative LLMs text datasets. 

[awesome-ml](https://github.com/underlines/awesome-ml) :  Curated list of useful LLM / Analytics / Datascience resources 

[awesome-llm-security](https://github.com/corca-ai/awesome-llm-security) :  A curation of awesome tools, documents and projects about LLM Security. 

[Awesome-LLM4AD](https://github.com/Thinklab-SJTU/Awesome-LLM4AD) :  A curated list of awesome LLM for Autonomous Driving resources

[awesome-llm-powered-agent](https://github.com/hyp1231/awesome-llm-powered-agent) :  Awesome things about LLM-powered agents. Papers / Repos / Blogs 

[awesome-llm-json](https://github.com/imaurer/awesome-llm-json) :  Resource list for generating JSON using LLMs via function calling, tools, CFG. Libraries, Models, Notebooks, etc. 

[Awesome-Code-LLM](https://github.com/codefuse-ai/Awesome-Code-LLM) :  A curated list of language modeling researches for code and related datasets. 

[awesome-llm-interpretability](https://github.com/JShollaj/awesome-llm-interpretability) :  A curated list of Large Language Model (LLM) Interpretability resources. 

[Awesome-Graph-LLM](https://github.com/XiaoxinHe/Awesome-Graph-LLM) :  A collection of AWESOME things about Graph-Related LLMs. 

[Awesome-GPT-Agents](https://github.com/fr0gger/Awesome-GPT-Agents) :  A curated list of GPT agents for cybersecurity 

[LLM4Rec-Awesome-Papers](https://github.com/WLiK/LLM4Rec-Awesome-Papers) :  A list of awesome papers and resources of recommender system on large language model (LLM). 

[Awesome-LLM-KG](https://github.com/RManLuo/Awesome-LLM-KG) :  Awesome papers about unifying LLMs and KGs 

[awesome_LLMs_interview_notes](https://github.com/jackaduma/awesome_LLMs_interview_notes) :  LLMs interview notes and answers:该仓库主要记录大模型（LLMs）算法工程师相关的面试题和参考答案 



## Speech

[awesome-speech-recognition-speech-synthesis-papers](https://github.com/zzw922cn/awesome-speech-recognition-speech-synthesis-papers) ： Automatic Speech Recognition (ASR), Speaker Verification, Speech Synthesis, Text-to-Speech (TTS), Language Modelling, Singing Voice Synthesis (SVS), Voice Conversion (VC) 

 [Speech-Separation-Paper-Tutorial](https://github.com/JusperLee/Speech-Separation-Paper-Tutorial) ： A must-read paper for speech separation based on neural networks 

[speech-recognition-papers](https://github.com/wenet-e2e/speech-recognition-papers):  Towards hot directions in industrial end to end speech recognition 

[awesome-data-augmentation](https://github.com/CrazyVertigo/awesome-data-augmentation)![](https://img.shields.io/github/stars/CrazyVertigo/awesome-data-augmentation.svg?style=social)：  This is a list of awesome methods about data augmentation. 

[Awesome-SLP](https://github.com/BenSaunders27/Awesome-SLP.git):   A curated list of awesome work on Sign Language Production 

 [Awesome-SLU-Survey](https://github.com/yizhen20133868/Awesome-SLU-Survey) ： Tracking the progress in SLU (resources, code, and new frontiers etc.) 

[speech_dataset](https://github.com/double22a/speech_dataset):  The dataset of Speech Recognition 

[awesome_OpenSetRecognition_list](https://github.com/iCGY96/awesome_OpenSetRecognition_list):  A curated list of papers & resources linked to open set recognition, out-of-distribution, open set domain adaptation and open world recognition 

[speech-synthesis-paper](https://github.com/wenet-e2e/speech-synthesis-paper) :  List of speech synthesis papers. 

[Awesome-Speech-Enhancement](https://github.com/nanahou/Awesome-Speech-Enhancement) ： A tutorial for Speech Enhancement researchers and practitioners. The purpose of this repo is to organize the world’s resources for speech enhancement and make them universally accessible and useful. 

[awesome-speech-enhancement](https://github.com/WenzheLiu-Speech/awesome-speech-enhancement) :  speech enhancement\speech seperation\sound source localization 

[speech_data_augment](https://github.com/zzpDapeng/speech_data_augment) :  A summary of speech data augment algorithms 

[wer_are_we](https://github.com/syhw/wer_are_we) :  Attempt at tracking states of the arts and recent results (bibliography) on speech recognition. 

[awesome-diarization](https://github.com/wq2012/awesome-diarization) :  A curated list of awesome Speaker Diarization papers, libraries, datasets, and other resources. 

[awesome-audio-visualization](https://github.com/willianjusten/awesome-audio-visualization) :  A curated list about Audio Visualization. 

[awesome-deep-learning-music](https://github.com/ybayle/awesome-deep-learning-music) :  List of articles related to deep learning applied to music 

[speech-language-processing](https://github.com/edobashira/speech-language-processing) :  A curated list of speech and natural language processing resources 

[SpeechAlgorithms](https://github.com/Ryuk17/SpeechAlgorithms) :  Speech Algorithms Collections 

[awesome-vad](https://github.com/bigcash/awesome-vad) : A curated list of awesome voice activity detection 

[SER-datasets](https://github.com/SuperKogito/SER-datasets) :  A collection of datasets for the purpose of emotion recognition/detection in speech. 

[awesome-openai-whisper](https://github.com/ancs21/awesome-openai-whisper) :  A curated list of awesome OpenAI's Whisper 

[Tutorial_Separation](https://github.com/gemengtju/Tutorial_Separation) :  This repo summarizes the tutorials, datasets, papers, codes and tools for speech separation and speaker extraction task. You are kindly invited to pull requests. 

[open-speech-corpora](https://github.com/coqui-ai/open-speech-corpora) :  💎 A list of accessible speech corpora for ASR, TTS, and other Speech Technologies

[awesome-vits](https://github.com/34j/awesome-vits) :  List of repositories relevant to VITS.  

[Awesome-Text-to-Speech-TTS](https://github.com/TouchSky-Lab/Awesome-Text-to-Speech-TTS) :  Awesome TTS 

[awesome-tts-samples](https://github.com/seungwonpark/awesome-tts-samples) :  Awesome list of TTS papers with audio samples 

[awesome-disfluency-detection](https://github.com/pariajm/awesome-disfluency-detection) :  A curated list of awesome disfluency detection publications along with the released code and bibliographical information 

[WeDataset](https://github.com/wenet-e2e/wenet/issues/2094): List of (OpenSource data) + (Crawler Resources)



## Others

[anomaly-detection-resources](https://github.com/yzhao062/anomaly-detection-resources) :  Anomaly detection related books, papers, videos, and toolboxes 

[awesome-anomaly-detection](https://github.com/hoya012/awesome-anomaly-detection) :  A curated list of awesome anomaly detection resources 

[Surface-Defect-Detection](https://github.com/Charmve/Surface-Defect-Detection) :   Constantly summarizing open source dataset and critical papers in the field of surface defect research which are of great importance. 

[Awesome-Meta-Learning](https://github.com/sudharsan13296/Awesome-Meta-Learning) :  A curated list of Meta Learning papers, code, books, blogs, videos, datasets and other resources. 

[GitHub-Chinese-Top-Charts](https://github.com/GrowingGit/GitHub-Chinese-Top-Charts) :  🇨🇳 GitHub chinese top list 中文排行榜，各语言分离设置「软件 / 资料」榜单，精准定位中文好项目。各取所需，互不干扰，高效学习。

[state-of-the-art-result-for-machine-learning-problems](https://github.com/RedditSota/state-of-the-art-result-for-machine-learning-problems) :  This repository provides state of the art (SoTA) results for all machine learning problems. We do our best to keep this repository up to date. If you do find a problem's SoTA result is out of date or missing, please raise this as an issue or submit Google form (with this information: research paper name, dataset, metric, source code and year). 

[PyTorchTricks](https://github.com/lartpang/PyTorchTricks) :  Some tricks of pytorch... ⭐ 

[Awesome-pytorch-list-CNVersion](https://github.com/xavier-zy/Awesome-pytorch-list-CNVersion) :  Awesome-pytorch-list 翻译工作进行中...... 

[Awesome-pytorch-list](https://github.com/bharathgs/Awesome-pytorch-list) :  A comprehensive list of pytorch related content on github,such as different models,implementations,helper libraries,tutorials etc. 

[deeplearning-models](https://github.com/rasbt/deeplearning-models) :  A collection of various deep learning architectures, models, and tips 

[awesome-data-labeling](https://github.com/heartexlabs/awesome-data-labeling) :  A curated list of awesome data labeling tools 

[Awesome-Learning-with-Label-Noise](https://github.com/subeeshvasu/Awesome-Learning-with-Label-Noise) :  A curated list of resources for Learning with Noisy Labels 

[awesome-music-production](https://github.com/ad-si/awesome-music-production.git):   A curated list of software, services and resources to create and distribute music.  

[leetcode-master](https://github.com/youngyangyang04/leetcode-master) ： LeetCode Introduction 刷题攻略：200道经典题目刷题顺序，共60w字的详细图解，视频难点剖析，50余张思维导图，支持C++，Java，Python，Go，JavaScript等多语言版本，从此算法学习不再迷茫！🔥🔥 来看看，你会发现相见恨晚！🚀 

[awesome-python-login-model](https://github.com/Kr1s77/awesome-python-login-model) ： 😮python crawlers 模拟登陆一些大型网站，还有一些简单的爬虫， 

[awesome-spider](https://github.com/facert/awesome-spider) :   crawlers list 爬虫集合 

[awesome-python](https://github.com/vinta/awesome-python) :  A curated list of awesome Python frameworks, libraries, software and resources 

[awesome-remote-job](https://github.com/lukasz-madon/awesome-remote-job) :  A curated list of awesome remote jobs and resources. 

[public-apis](https://github.com/public-apis/public-apis) :  A collective list of free APIs 

[Public-APIs](https://github.com/n0shake/Public-APIs) :  📚 A public list of APIs from round the web. 

[public-api-lists](https://github.com/public-api-lists/public-api-lists) :  A collective list of free APIs for use in software and web development 🚀 

[lists](https://github.com/jnv/lists) :  The definitive list of lists (of lists) curated on GitHub and elsewhere 

[interview](https://github.com/Olshansk/interview) :  Everything you need to prepare for your technical interview 

[A-to-Z-Resources-for-Students](https://github.com/dipakkr/A-to-Z-Resources-for-Students) :  ✅ Curated list of resources for college students 

[awesome-math](https://github.com/rossant/awesome-math) :  A curated list of awesome mathematics resources 

[awesome-raspberry-pi](https://github.com/thibmaek/awesome-raspberry-pi) :  📝 A curated list of awesome Raspberry Pi tools, projects, images and resources 

[science-based-games-list](https://github.com/stared/science-based-games-list) :  Science-based games - a collaborative list 

[awesome-SLAM-list](https://github.com/OpenSLAM/awesome-SLAM-list) :  awesome-SLAM-list 

[awesome-slam](https://github.com/kanster/awesome-slam) :  A curated list of awesome SLAM tutorials, projects and communities. 

[SLAM-All-In-One](https://github.com/zhouyong1234/SLAM-All-In-One) :  SLAM汇总，包括多传感器融合建图、定位、VIO系列、常用工具包、开源代码注释和公式推导、文章综述 

[awesome-robotics](https://github.com/kiloreux/awesome-robotics) :  A list of awesome Robotics resources 

[TopDeepLearning](https://github.com/aymericdamien/TopDeepLearning) :  A list of popular github projects related to deep learning 

[awesome-ai-residency](https://github.com/dangkhoasdc/awesome-ai-residency) :  List of AI Residency Programs 

[ICRA2020-paper-list](https://github.com/PaoPaoRobot/ICRA2020-paper-list) :  ICRA2020 paperlist by paopaorobot,  ICRA 2020 : the 2020 IEEE International Conference on Robotics and Automation. 

[RSPapers](https://github.com/hongleizhang/RSPapers) :  A Curated List of Must-read Papers on Recommender System. 

[Awesome-Embedded](https://github.com/nhivp/Awesome-Embedded) :  A curated list of awesome embedded programming. 

[useful-computer-vision-phd-resources](https://github.com/hassony2/useful-computer-vision-phd-resources) :  Lists of resources useful for my PhD in computer vision 

[spatio-temporal-paper-list](https://github.com/Eilene/spatio-temporal-paper-list) :  Spatio-temporal modeling 论文列表（主要是graph convolution相关) 

[awesome-self-supervised-learning](https://github.com/jason718/awesome-self-supervised-learning) :  A curated list of awesome self-supervised methods 

[medical-imaging-datasets](https://github.com/sfikas/medical-imaging-datasets) :  A list of Medical imaging datasets. 

[awesome-roadmaps](https://github.com/liuchong/awesome-roadmaps) :  A curated list of roadmaps. 

[EEG-Datasets](https://github.com/meagmohit/EEG-Datasets) :  A list of all public EEG-datasets 

[MARL-Papers](https://github.com/LantaoYu/MARL-Papers) :  Paper list of multi-agent reinforcement learning (MARL) 

[awesome-multimodal-ml](https://github.com/pliang279/awesome-multimodal-ml) :  Reading list for research topics in multimodal machine learning 

[Awesome-Multimodal-Research](https://github.com/Eurus-Holmes/Awesome-Multimodal-Research) :  A curated list of Multimodal Related Research. 

[deep-reinforcement-learning-papers](https://github.com/junhyukoh/deep-reinforcement-learning-papers) :  A list of recent papers regarding deep reinforcement learning 

[awesome-machine-learning-interpretability](https://github.com/jphall663/awesome-machine-learning-interpretability) :  A curated list of awesome machine learning interpretability resources. 

[awesome-fast-attention](https://github.com/Separius/awesome-fast-attention) :  list of efficient attention modules 

[deeplearning-biology](https://github.com/hussius/deeplearning-biology) :  A list of deep learning implementations in biology 

[FreeML](https://github.com/Shujian2015/FreeML) :  A List of Data Science/Machine Learning Resources (Mostly Free) 

[Paper-List](https://github.com/ConanCui/Paper-List) :  A reading paper list which is mainted daily 

[awesome-jupyter](https://github.com/markusschanta/awesome-jupyter) :  A curated list of awesome Jupyter projects, libraries and resources 

[the-incredible-pytorch](https://github.com/ritchieng/the-incredible-pytorch) :  The Incredible PyTorch: a curated list of tutorials, papers, projects, communities and more relating to PyTorch. 

[awesome-quant](https://github.com/wilsonfreitas/awesome-quant) :  A curated list of insanely awesome libraries, packages and resources for Quants (Quantitative Finance) 

[awesome-quant](https://github.com/thuquant/awesome-quant) :  quant related resources index in China 

[awesome-community-detection](https://github.com/benedekrozemberczki/awesome-community-detection) :  A curated list of community detection research papers with implementations. 

[awesome-robotics-libraries](https://github.com/jslee02/awesome-robotics-libraries) :  😎 A curated list of robotics libraries and software 

[awesome_time_series_in_python](https://github.com/MaxBenChrist/awesome_time_series_in_python) :  This curated list contains python packages for time series analysis 

[awesome-rnn](https://github.com/kjw0612/awesome-rnn) :  Recurrent Neural Network - A curated list of resources dedicated to RNN 

[awesome-random-forest](https://github.com/kjw0612/awesome-random-forest) :  Random Forest - a curated list of resources regarding random forest 

[awesome-adversarial-machine-learning](https://github.com/yenchenlin/awesome-adversarial-machine-learning) :  A curated list of awesome adversarial machine learning resources 

[awesome-awesome](https://github.com/emijrp/awesome-awesome) :  A curated list of awesome curated lists of many topics. 

[VR-Awesome](https://github.com/Vytek/VR-Awesome) :  VR Awesome List 

[machine-learning-surveys](https://github.com/metrofun/machine-learning-surveys) :  A curated list of Machine Learning Surveys, Tutorials and Books. 

[awesome-rl](https://github.com/aikorea/awesome-rl) :  Reinforcement learning resources curated 

[awesome-knowledge-distillation](https://github.com/dkozlov/awesome-knowledge-distillation) :  Awesome Knowledge Distillation 

[Awesome-Incremental-Learning](https://github.com/xialeiliu/Awesome-Incremental-Learning) :  Awesome Incremental Learning 

[awesome-graph-classification](https://github.com/benedekrozemberczki/awesome-graph-classification) :  A collection of important graph embedding, classification and representation learning papers with implementations. 

[Awesome-Transformer-Attention](https://github.com/cmhungsteve/Awesome-Transformer-Attention) ： An ultimately comprehensive paper list of Vision Transformer/Attention, including papers, codes, and related websites 

[awesome-public-datasets](https://github.com/awesomedata/awesome-public-datasets) :  A topic-centric list of HQ open datasets. 

[awesome-ai-in-finance](https://github.com/georgezouq/awesome-ai-in-finance) :  🔬 A curated list of awesome machine learning strategies & tools in financial market. 

[Awesome-explainable-AI](https://github.com/wangyongjie-ntu/Awesome-explainable-AI) :  A collection of research materials on explainable AI/ML 

[Awesome-Federated-Learning](https://github.com/chaoyanghe/Awesome-Federated-Learning) :  FedML - The Research and Production Integrated Federated Learning Library

[Awesome-AI-Security](https://github.com/DeepSpaceHarbor/Awesome-AI-Security) :  A curated list of AI security resources inspired by [awesome-adversarial-machine-learning](https://github.com/yenchenlin/awesome-adversarial-machine-learning) & [awesome-ml-for-cybersecurity](https://github.com/jivoi/awesome-ml-for-cybersecurity). 

[awesome-deep-rl](https://github.com/tigerneil/awesome-deep-rl) :  For deep RL and the future of AI. 

[awesome-fashion-ai](https://github.com/ayushidalmia/awesome-fashion-ai) :  A repository to curate and summarise research papers related to fashion and e-commerce 

[awesome-blockchain-ai](https://github.com/steven2358/awesome-blockchain-ai) :  A curated list of Blockchain projects for Artificial Intelligence and Machine Learning 

[awesome-starcraftAI](https://github.com/SKTBrain/awesome-starcraftAI) :  A curated list of resources dedicated to StarCraft AI. 

[awesome-game-ai](https://github.com/datamllab/awesome-game-ai) :  Awesome Game AI materials of Multi-Agent Reinforcement Learning 

[awesome-feature-engineering](https://github.com/aikho/awesome-feature-engineering) :  A curated list of resources dedicated to Feature Engineering Techniques for Machine Learning 

[awesome-ai-usecases](https://github.com/JosPolfliet/awesome-ai-usecases) :  A list of awesome and proven Artificial Intelligence use cases and applications 

[lite.ai.toolkit](https://github.com/DefTruth/lite.ai.toolkit) :  A lite C++ toolkit of awesome AI models with ONNXRuntime, NCNN, MNN and TNN. YOLOX, YOLOP, YOLOv6, YOLOR, MODNet, YOLOX, YOLOv7, YOLOv5. MNN, NCNN, TNN, ONNXRuntime. 

[awesome-ai](https://github.com/hades217/awesome-ai) :  A curated list of artificial intelligence resources (Courses, Tools, App, Open Source Project) 

[500-AI-Machine-learning-Deep-learning-Computer-vision-NLP-Projects-with-code](https://github.com/ashishpatel26/500-AI-Machine-learning-Deep-learning-Computer-vision-NLP-Projects-with-code) :  500 AI Machine learning Deep learning Computer vision NLP Projects with code 

[knowledge-distillation-papers](https://github.com/lhyfst/knowledge-distillation-papers) :  knowledge distillation papers 

[Awesome_Continual-Lifelong-Incremental_learning](https://github.com/chengsilin/Awesome_Continual-Lifelong-Incremental_learning) : Awesome Continual-Lifelong-Incremental learning

[Awesome-Few-Shot-Class-Incremental-Learning](https://github.com/zhoudw-zdw/Awesome-Few-Shot-Class-Incremental-Learning) : Awesome Few-Shot Class Incremental Learning

[awesome-gcn](https://github.com/Jiakui/awesome-gcn) :  resources for graph convolutional networks 

[Awesome-Deep-Graph-Clustering](https://github.com/yueliu1999/Awesome-Deep-Graph-Clustering) :  Awesome Deep Graph Clustering is a collection of SOTA, novel deep graph clustering methods (papers, codes, and datasets). 

[awesome-denovo-papers](https://github.com/asarigun/awesome-denovo-papers) :  Awesome De novo drugs design papers 

[awesome-lidar](https://github.com/szenergy/awesome-lidar) :  Awesome LIDAR list. The list includes LIDAR manufacturers, datasets, point cloud-processing algorithms, point cloud frameworks and simulators. 

[awesome-self-supervised-gnn](https://github.com/ChandlerBang/awesome-self-supervised-gnn) :  Papers about pretraining and self-supervised learning on Graph Neural Networks (GNN). 

[ai-collection](https://github.com/ai-collection/ai-collection) : The Generative AI Landscape - A Collection of Awesome Generative AI Applications

[papers-we-love](https://github.com/papers-we-love/papers-we-love) :  Papers from the computer science community to read and discuss. 

[Awesome-Autonomous-Driving](https://github.com/autodriving-heart/Awesome-Autonomous-Driving) :  awesome-autonomous-driving 

