import React from "react";

import {
  Favorite,
  Delete,
  Rating,
  Up,
  Down,
  Left,
  Right,
  Download,
  Search,
  Copy,
  Design,
  UserCircle,
  Settings,
  Image,
} from "neetoicons";

const columnData = [
  {
    dataIndex: "id",
    key: "id",
    sorter: () => {},
    title: "ID",
    width: 75,
    moreActions: [{ type: "action1", label: "Action 1" }],
  },
  {
    dataIndex: "guid",
    ellipsis: { showTitle: false },
    key: "guid",
    title: function noRefCheck() {},
    width: 150,
  },
  {
    dataIndex: "first_name",
    key: "first_name",
    render: function noRefCheck() {},
    title: "First Name",
    width: 150,
  },
  {
    dataIndex: "last_name",
    key: "last_name",
    title: "Last Name",
    width: 150,
  },
  {
    dataIndex: "buzzword",
    key: "buzzword",
    title: "Buzzword",
    width: 250,
  },
  { dataIndex: "gender", key: "gender", title: "Gender", width: 150 },
  {
    dataIndex: "email",
    ellipsis: { showTitle: false },
    key: "email",
    title: "Email",
    width: 200,
  },
  {
    dataIndex: "company_name",
    ellipsis: { showTitle: false },
    key: "company_name",
    title: "Company Name",
    width: 75,
  },
  {
    dataIndex: "ip_address",
    key: "ip_address",
    title: "IP Address",
    width: 150,
  },
  {
    dataIndex: "department",
    ellipsis: { showTitle: false },
    key: "department",
    title: "Department",
    width: 150,
  },
  {
    dataIndex: "job_title",
    ellipsis: { showTitle: false },
    key: "job_title",
    title: "Job Title",
    width: 75,
  },
  {
    dataIndex: "currency",
    key: "currency",
    title: "Currency",
    width: 150,
  },
  {
    dataIndex: "credit_card_number",
    ellipsis: { showTitle: false },
    key: "credit_card_number",
    title: "Credit Card Number",
    width: 250,
  },
  {
    dataIndex: "currency_code",
    key: "currency_code",
    title: "Currency Code",
    width: 150,
  },
  {
    dataIndex: "domain_name",
    ellipsis: { showTitle: false },
    key: "domain_name",
    title: "Domain Name",
    width: 200,
  },
  {
    dataIndex: "app_name",
    key: "app_name",
    title: "App Name",
    width: 150,
  },
  {
    dataIndex: "app_version",
    key: "app_version",
    title: "App Version",
    width: 150,
  },
  {
    dataIndex: "shirt_size",
    key: "shirt_size",
    title: "Shirt Size",
    width: 150,
  },
  {
    dataIndex: "action",
    key: "action",
    render: function noRefCheck() {},
    title: "Action",
    width: 150,
  },
  {
    dataIndex: "icon_button",
    key: "icon_button",
    render: function noRefCheck() {},
    title: "Icon Button",
    width: 150,
  },
];

const columnDataToString = () =>
  JSON.stringify(columnData, null, 4).replace(/(\{|\}|\])/gi, "\t$1");

export const icons = {
  Favorite,
  Delete,
  Up,
  Rating,
  Down,
  Left,
  Right,
  Download,
};

export const prefixes = {
  Favorite: <Favorite />,
  Search: <Search />,
  Up: <Up />,
  Rating: <Rating />,
  Down: <Down />,
  Left: <Left />,
  Right: <Right />,
  Download: <Download />,
};

export const suffixes = {
  "Example.com": ".example.com",
  "Bigbinary.com": ".bigbinary.com",
  "Neeto.com": ".neeto.com",
};

export const SIMPLE_TABLE_DATA = [
  {
    key: 1,
    id: "cd75b6a6-54fa-4a0f-8fe9-5b62a461a2d0",
    guid: "cd75b6a6-54fa-4a0f-8fe9-5b62a461a2d0cd75b6a6-54fa-4a0f-8fe9-5b62a461a2d0",
    first_name: "Brennen",
    last_name: "Realy",
  },
  {
    key: 2,
    id: "c48cfefc-9e04-4169-9b31-442b363c30e8",
    guid: "c48cfefc-9e04-4169-9b31-442b363c30e8c48cfefc-9e04-4169-9b31-442b363c30e8",
    first_name: "Manny",
    last_name: "Jaime",
  },
];

export const TABLE_DATA = [
  {
    key: 1,
    id: 1,
    guid: "cd75b6a6-54fa-4a0f-8fe9-5b62a461a2d0",
    first_name: "Brennen",
    last_name: "Realy",
    buzzword: "artificial intelligence",
    gender: "Male",
    email: "brealy0@who.int",
    company_name: "Schuppe-Beier",
    ip_address: "144.32.99.33",
    department: "Training",
    job_title: "Internal Auditor",
    currency: "Ruble",
    credit_card_number: 3551746792304987,
    currency_code: "RUB",
    domain_name: "freewebs.com",
    app_name: "Sub-Ex",
    app_version: "7.0.9",
    shirt_size: "3XL",
  },
  {
    key: 2,
    id: 2,
    guid: "c48cfefc-9e04-4169-9b31-442b363c30e8",
    first_name: "Manny",
    last_name: "Jaime",
    buzzword: "Profit-focused",
    gender: "Polygender",
    email: "mjaime1@jigsy.com",
    company_name: "Legros, Ankunding and Cartwright",
    ip_address: "41.191.104.169",
    department: "Engineering",
    job_title: "Community Outreach Specialist",
    currency: "Yuan Renminbi",
    credit_card_number: 3584141123636532,
    currency_code: "CNY",
    domain_name: "unc.edu",
    app_name: "Duobam",
    app_version: 4.92,
    shirt_size: "M",
  },
  {
    key: 3,
    id: 3,
    guid: "894f0864-706d-4b76-b889-48ea99128687",
    first_name: "Wilton",
    last_name: "Huddlestone",
    buzzword: "definition",
    gender: "Agender",
    email: "whuddlestone2@mapquest.com",
    company_name: "Hickle-Turcotte",
    ip_address: "53.47.156.177",
    department: "Legal",
    job_title: "Sales Associate",
    currency: "Euro",
    credit_card_number: 4405563411056815,
    currency_code: "EUR",
    domain_name: "businessinsider.com",
    app_name: "Asoka",
    app_version: 0.35,
    shirt_size: "XL",
  },
  {
    key: 4,
    id: 4,
    guid: "c13fb646-6019-44c5-bc90-f53c992237fe",
    first_name: "Crin",
    last_name: "Tapply",
    buzzword: "next generation",
    gender: "Polygender",
    email: "ctapply3@newsvine.com",
    company_name: "Jones Inc",
    ip_address: "44.224.117.201",
    department: "Product Management",
    job_title: "Tax Accountant",
    currency: "Dollar",
    credit_card_number: 3556557574431111,
    currency_code: "USD",
    domain_name: "wordpress.com",
    app_name: "Zoolab",
    app_version: "0.3.5",
    shirt_size: "XL",
  },
  {
    key: 5,
    id: 5,
    guid: "c8082a50-cbed-4107-8566-ae21eacc9c06",
    first_name: "Antons",
    last_name: "Shallow",
    buzzword: "Multi-tiered",
    gender: "Non-binary",
    email: "ashallow4@reference.com",
    company_name: "Moen, Kub and Beatty",
    ip_address: "106.27.145.38",
    department: "Marketing",
    job_title: "Quality Engineer",
    currency: "Dram",
    credit_card_number: 5602218894989493000,
    currency_code: "AMD",
    domain_name: "adobe.com",
    app_name: "Wrapsafe",
    app_version: "0.1.4",
    shirt_size: "XL",
  },
  {
    key: 6,
    id: 6,
    guid: "4a0081ee-cc8c-4e8d-a509-414f1e9bc82f",
    first_name: "Junette",
    last_name: "Peever",
    buzzword: "Down-sized",
    gender: "Agender",
    email: "jpeever5@mysql.com",
    company_name: "Hills Inc",
    ip_address: "107.200.153.250",
    department: "Business Development",
    job_title: "Civil Engineer",
    currency: "Peso",
    credit_card_number: 3577689643877217,
    currency_code: "PHP",
    domain_name: "ed.gov",
    app_name: "Tres-Zap",
    app_version: 1.4,
    shirt_size: "M",
  },
  {
    key: 7,
    id: 7,
    guid: "0c92fac4-4c57-4882-89bd-05612ead4eaf",
    first_name: "Julee",
    last_name: "Palmby",
    buzzword: "Reduced",
    gender: "Polygender",
    email: "jpalmby6@webs.com",
    company_name: "Douglas-Oberbrunner",
    ip_address: "166.202.115.161",
    department: "Legal",
    job_title: "Structural Analysis Engineer",
    currency: "Yuan Renminbi",
    credit_card_number: 3553225504871102,
    currency_code: "CNY",
    domain_name: "edublogs.org",
    app_name: "Fix San",
    app_version: 7.99,
    shirt_size: "XL",
  },
  {
    key: 8,
    id: 8,
    guid: "4f5bcb5e-3c89-488b-9772-9b710b7c9b19",
    first_name: "Izak",
    last_name: "Towe",
    buzzword: "orchestration",
    gender: "Bigender",
    email: "itowe7@toplist.cz",
    company_name: "Koepp LLC",
    ip_address: "103.225.165.252",
    department: "Legal",
    job_title: "Tax Accountant",
    currency: "Real",
    credit_card_number: 3572576521356502,
    currency_code: "BRL",
    domain_name: "un.org",
    app_name: "Lotlux",
    app_version: 4.7,
    shirt_size: "S",
  },
  {
    key: 9,
    id: 9,
    guid: "27701bfe-39ba-487c-90c7-9d1b7f05c001",
    first_name: "Blondy",
    last_name: "Gosselin",
    buzzword: "intranet",
    gender: "Polygender",
    email: "bgosselin8@cornell.edu",
    company_name: "Pagac, Spinka and Dooley",
    ip_address: "19.182.162.193",
    department: "Services",
    job_title: "Assistant Manager",
    currency: "Zloty",
    credit_card_number: 5602247062713142,
    currency_code: "PLN",
    domain_name: "imdb.com",
    app_name: "Latlux",
    app_version: 0.82,
    shirt_size: "3XL",
  },
  {
    key: 10,
    id: 10,
    guid: "d3af8777-7341-4b52-a93a-6204e5a153bb",
    first_name: "Joceline",
    last_name: "Brushneen",
    buzzword: "productivity",
    gender: "Female",
    email: "jbrushneen9@fotki.com",
    company_name: "Torp, Altenwerth and Runolfsson",
    ip_address: "142.44.166.35",
    department: "Sales",
    job_title: "Account Executive",
    currency: "Shilling",
    credit_card_number: 374622594660937,
    currency_code: "SOS",
    domain_name: "ow.ly",
    app_name: "Tresom",
    app_version: "0.6.8",
    shirt_size: "XS",
  },
  {
    key: 11,
    id: 11,
    guid: "b67cab6d-09e2-4488-ab09-21b0b4602db2",
    first_name: "William",
    last_name: "Marskell",
    buzzword: "knowledge base",
    gender: "Female",
    email: "wmarskella@mayoclinic.com",
    company_name: "Thiel Group",
    ip_address: "81.128.177.11",
    department: "Business Development",
    job_title: "Nurse",
    currency: "Peso",
    credit_card_number: 3580273946709412,
    currency_code: "PHP",
    domain_name: "zdnet.com",
    app_name: "Y-find",
    app_version: "9.5.8",
    shirt_size: "L",
  },
  {
    key: 12,
    id: 12,
    guid: "2447d583-3aaf-4041-ae8d-c18be28e7695",
    first_name: "Petronille",
    last_name: "Pays",
    buzzword: "intranet",
    gender: "Polygender",
    email: "ppaysb@salon.com",
    company_name: "Medhurst-Rau",
    ip_address: "243.51.208.133",
    department: "Human Resources",
    job_title: "VP Marketing",
    currency: "Rupiah",
    credit_card_number: 3544976316054269,
    currency_code: "IDR",
    domain_name: "google.com.au",
    app_name: "Flowdesk",
    app_version: 0.39,
    shirt_size: "3XL",
  },
  {
    key: 13,
    id: 13,
    guid: "4194a9ee-8df5-440b-b4b6-f0916cb458e5",
    first_name: "Donielle",
    last_name: "Streetley",
    buzzword: "core",
    gender: "Bigender",
    email: "dstreetleyc@blogs.com",
    company_name: "Hackett and Sons",
    ip_address: "131.226.233.206",
    department: "Legal",
    job_title: "Web Designer IV",
    currency: "Baht",
    credit_card_number: 3529415443141201,
    currency_code: "THB",
    domain_name: "arstechnica.com",
    app_name: "Subin",
    app_version: 5,
    shirt_size: "L",
  },
  {
    key: 14,
    id: 14,
    guid: "e232b2d3-d970-45ae-9a82-7141581f0e02",
    first_name: "Kirby",
    last_name: "Bauckham",
    buzzword: "Grass-roots",
    gender: "Agender",
    email: "kbauckhamd@gmpg.org",
    company_name: "Grant and Sons",
    ip_address: "76.55.175.39",
    department: "Training",
    job_title: "Programmer Analyst I",
    currency: "Euro",
    credit_card_number: 3532022554787874,
    currency_code: "EUR",
    domain_name: "nymag.com",
    app_name: "Duobam",
    app_version: 0.18,
    shirt_size: "XL",
  },
  {
    key: 15,
    id: 15,
    guid: "062102bc-394c-45eb-bad1-616d3d29b3f2",
    first_name: "Rosella",
    last_name: "McMorran",
    buzzword: "Polarised",
    gender: "Bigender",
    email: "rmcmorrane@si.edu",
    company_name: "O'Connell, Mueller and Hintz",
    ip_address: "38.195.52.98",
    department: "Engineering",
    job_title: "Administrative Officer",
    currency: "Peso",
    credit_card_number: 676374294410437600,
    currency_code: "ARS",
    domain_name: "gravatar.com",
    app_name: "Gembucket",
    app_version: 8.74,
    shirt_size: "2XL",
  },
  {
    key: 16,
    id: 16,
    guid: "ca7f23bc-64e1-4740-9f8a-76d1a8ba82a4",
    first_name: "Donaugh",
    last_name: "Letty",
    buzzword: "Self-enabling",
    gender: "Female",
    email: "dlettyf@wikimedia.org",
    company_name: "Hintz LLC",
    ip_address: "103.30.154.240",
    department: "Research and Development",
    job_title: "Tax Accountant",
    currency: "Euro",
    credit_card_number: 4041379016969579,
    currency_code: "EUR",
    domain_name: "surveymonkey.com",
    app_name: "Zontrax",
    app_version: 0.66,
    shirt_size: "M",
  },
  {
    key: 17,
    id: 17,
    guid: "6865d197-4b4e-499a-a05a-5e12293b4828",
    first_name: "Luis",
    last_name: "Dufore",
    buzzword: "radical",
    gender: "Female",
    email: "lduforeg@rediff.com",
    company_name: "Wehner Inc",
    ip_address: "73.192.236.39",
    department: "Research and Development",
    job_title: "Social Worker",
    currency: "Hryvnia",
    credit_card_number: 5464311981590119,
    currency_code: "UAH",
    domain_name: "sitemeter.com",
    app_name: "Zoolab",
    app_version: 3.61,
    shirt_size: "2XL",
  },
  {
    key: 18,
    id: 18,
    guid: "83c939de-ede2-4e8d-9399-baef9aa79a86",
    first_name: "Delly",
    last_name: "Tanti",
    buzzword: "Upgradable",
    gender: "Genderfluid",
    email: "dtantih@quantcast.com",
    company_name: "Bosco-Rodriguez",
    ip_address: "19.34.47.1",
    department: "Accounting",
    job_title: "Clinical Specialist",
    currency: "Yuan Renminbi",
    credit_card_number: 4026584466448789,
    currency_code: "CNY",
    domain_name: "intel.com",
    app_name: "Zoolab",
    app_version: 0.68,
    shirt_size: "M",
  },
  {
    key: 19,
    id: 19,
    guid: "f99f09f4-708d-4526-b818-9da6a7ef4ac2",
    first_name: "Margarete",
    last_name: "Eakin",
    buzzword: "executive",
    gender: "Agender",
    email: "meakini@163.com",
    company_name: "Hodkiewicz-Barton",
    ip_address: "203.140.170.240",
    department: "Marketing",
    job_title: "Paralegal",
    currency: "Yuan Renminbi",
    credit_card_number: 3582508580807750,
    currency_code: "CNY",
    domain_name: "istockphoto.com",
    app_name: "Tresom",
    app_version: "0.1.6",
    shirt_size: "L",
  },
  {
    key: 20,
    id: 20,
    guid: "ee25a901-aa59-4142-bc36-9eb49b90268e",
    first_name: "Agneta",
    last_name: "Gillhespy",
    buzzword: "Ergonomic",
    gender: "Bigender",
    email: "agillhespyj@php.net",
    company_name: "Breitenberg, Wiza and Lowe",
    ip_address: "178.218.21.66",
    department: "Marketing",
    job_title: "Technical Writer",
    currency: "Yuan Renminbi",
    credit_card_number: 3572790732285737,
    currency_code: "CNY",
    domain_name: "goodreads.com",
    app_name: "Biodex",
    app_version: "5.2.2",
    shirt_size: "XS",
  },
  {
    key: 21,
    id: 21,
    guid: "95a4a128-8fca-4db4-8969-43ce26150abe",
    first_name: "Osbert",
    last_name: "Rasher",
    buzzword: "fault-tolerant",
    gender: "Genderqueer",
    email: "orasherk@behance.net",
    company_name: "Baumbach Inc",
    ip_address: "241.51.123.49",
    department: "Engineering",
    job_title: "Media Manager I",
    currency: "Euro",
    credit_card_number: 5602221156261995,
    currency_code: "EUR",
    domain_name: "cnbc.com",
    app_name: "Bytecard",
    app_version: 0.16,
    shirt_size: "XS",
  },
  {
    key: 22,
    id: 22,
    guid: "6c620e0b-8f13-447b-87d9-980ef714e5d9",
    first_name: "Janeva",
    last_name: "Vedeniktov",
    buzzword: "functionalities",
    gender: "Polygender",
    email: "jvedeniktovl@fda.gov",
    company_name: "Christiansen, Littel and Hane",
    ip_address: "218.238.9.122",
    department: "Research and Development",
    job_title: "Office Assistant III",
    currency: "Rupiah",
    credit_card_number: 3558670031398837,
    currency_code: "IDR",
    domain_name: "tiny.cc",
    app_name: "Pannier",
    app_version: 4.33,
    shirt_size: "M",
  },
  {
    key: 23,
    id: 23,
    guid: "8866454e-7d6e-4238-acfc-bf4e7a51c7a9",
    first_name: "Berkeley",
    last_name: "Skacel",
    buzzword: "internet solution",
    gender: "Agender",
    email: "bskacelm@omniture.com",
    company_name: "Larkin, Streich and Lowe",
    ip_address: "60.45.85.209",
    department: "Training",
    job_title: "General Manager",
    currency: "Yuan Renminbi",
    credit_card_number: 6334279038674233000,
    currency_code: "CNY",
    domain_name: "ibm.com",
    app_name: "Redhold",
    app_version: "0.5.4",
    shirt_size: "XL",
  },
  {
    key: 24,
    id: 24,
    guid: "2f4d7cb5-b4e7-4e86-add9-19cd821cec48",
    first_name: "Leona",
    last_name: "Melluish",
    buzzword: "flexibility",
    gender: "Genderfluid",
    email: "lmelluishn@squarespace.com",
    company_name: "Lang-Effertz",
    ip_address: "194.76.65.241",
    department: "Business Development",
    job_title: "Recruiter",
    currency: "Afghani",
    credit_card_number: 5602224025594026,
    currency_code: "AFN",
    domain_name: "hatena.ne.jp",
    app_name: "Tampflex",
    app_version: 0.8,
    shirt_size: "2XL",
  },
  {
    key: 25,
    id: 25,
    guid: "af1203f8-2f00-4097-a41c-1f269b99bdd6",
    first_name: "Ashbey",
    last_name: "Fieldstone",
    buzzword: "content-based",
    gender: "Non-binary",
    email: "afieldstoneo@ning.com",
    company_name: "Stokes-Rath",
    ip_address: "47.209.60.4",
    department: "Human Resources",
    job_title: "Analog Circuit Design manager",
    currency: "Yuan Renminbi",
    credit_card_number: 3559779202186571,
    currency_code: "CNY",
    domain_name: "liveinternet.ru",
    app_name: "Ronstring",
    app_version: 5.2,
    shirt_size: "XS",
  },
  {
    key: 26,
    id: 26,
    guid: "1ed3f775-e6f7-4b37-9c4f-0f5c69631d5c",
    first_name: "Dunn",
    last_name: "Krysiak",
    buzzword: "strategy",
    gender: "Male",
    email: "dkrysiakp@upenn.edu",
    company_name: "Bernier, Baumbach and Welch",
    ip_address: "33.244.185.24",
    department: "Services",
    job_title: "Account Representative III",
    currency: "Dollar",
    credit_card_number: 3562059677399941,
    currency_code: "USD",
    domain_name: "wix.com",
    app_name: "Sub-Ex",
    app_version: 8,
    shirt_size: "XS",
  },
  {
    key: 27,
    id: 27,
    guid: "e89eeebc-557e-42fd-ae3e-a41a7ad2522f",
    first_name: "Amie",
    last_name: "Kildea",
    buzzword: "model",
    gender: "Female",
    email: "akildeaq@imgur.com",
    company_name: "Willms Group",
    ip_address: "195.157.247.242",
    department: "Human Resources",
    job_title: "Senior Sales Associate",
    currency: "Krona",
    credit_card_number: 3587641327169187,
    currency_code: "SEK",
    domain_name: "cisco.com",
    app_name: "Veribet",
    app_version: 0.77,
    shirt_size: "L",
  },
  {
    key: 28,
    id: 28,
    guid: "7322b51b-594e-4cb2-8682-5aadc8c1c8d3",
    first_name: "Timmy",
    last_name: "Munford",
    buzzword: "methodical",
    gender: "Bigender",
    email: "tmunfordr@aboutads.info",
    company_name: "Gislason-Connelly",
    ip_address: "31.60.248.119",
    department: "Product Management",
    job_title: "Systems Administrator II",
    currency: "Rupiah",
    credit_card_number: 3589565079946807,
    currency_code: "IDR",
    domain_name: "dion.ne.jp",
    app_name: "Zathin",
    app_version: "6.1.2",
    shirt_size: "S",
  },
  {
    key: 29,
    id: 29,
    guid: "b0b9d617-522b-40e7-aa12-4674e5e9c2b2",
    first_name: "Barbara",
    last_name: "Clemintoni",
    buzzword: "encompassing",
    gender: "Non-binary",
    email: "bclemintonis@yahoo.com",
    company_name: "Tillman, Christiansen and Deckow",
    ip_address: "54.156.98.62",
    department: "Sales",
    job_title: "Software Engineer IV",
    currency: "Rial",
    credit_card_number: 3544550976162801,
    currency_code: "SAR",
    domain_name: "hao123.com",
    app_name: "Y-Solowarm",
    app_version: 8.7,
    shirt_size: "M",
  },
  {
    key: 30,
    id: 30,
    guid: "2e17df52-9a89-4d47-aa65-45b1e1f3b3cc",
    first_name: "Amabel",
    last_name: "Cookley",
    buzzword: "6th generation",
    gender: "Non-binary",
    email: "acookleyt@auda.org.au",
    company_name: "Macejkovic, Quigley and Swaniawski",
    ip_address: "33.195.249.107",
    department: "Marketing",
    job_title: "Quality Control Specialist",
    currency: "Quetzal",
    credit_card_number: 3561027132640267,
    currency_code: "GTQ",
    domain_name: "adobe.com",
    app_name: "Pannier",
    app_version: 8.54,
    shirt_size: "M",
  },
  {
    key: 31,
    id: 31,
    guid: "428fd7ad-752f-43d4-be12-30d72f17f7ef",
    first_name: "Far",
    last_name: "McQuillin",
    buzzword: "Intuitive",
    gender: "Agender",
    email: "fmcquillinu@mayoclinic.com",
    company_name: "Lind, Schaden and Luettgen",
    ip_address: "97.120.222.128",
    department: "Product Management",
    job_title: "Safety Technician III",
    currency: "Naira",
    credit_card_number: 3554204593135264,
    currency_code: "NGN",
    domain_name: "google.fr",
    app_name: "Bytecard",
    app_version: 0.53,
    shirt_size: "3XL",
  },
  {
    key: 32,
    id: 32,
    guid: "db70b10e-2d0e-43b6-af26-6b923362c66d",
    first_name: "Melinda",
    last_name: "Orbine",
    buzzword: "core",
    gender: "Polygender",
    email: "morbinev@icio.us",
    company_name: "Schuppe, Klein and Lehner",
    ip_address: "148.245.232.49",
    department: "Product Management",
    job_title: "Professor",
    currency: "Ruble",
    credit_card_number: 5010124216630470,
    currency_code: "RUB",
    domain_name: "vinaora.com",
    app_name: "Regrant",
    app_version: "3.2.4",
    shirt_size: "XL",
  },
  {
    key: 33,
    id: 33,
    guid: "81f0b31b-1916-4157-bd22-fe089b28077b",
    first_name: "Brande",
    last_name: "Molder",
    buzzword: "clear-thinking",
    gender: "Genderqueer",
    email: "bmolderw@about.me",
    company_name: "Schuster-Torp",
    ip_address: "80.238.142.34",
    department: "Research and Development",
    job_title: "Senior Cost Accountant",
    currency: "Yuan Renminbi",
    credit_card_number: 4913681294911792,
    currency_code: "CNY",
    domain_name: "last.fm",
    app_name: "Veribet",
    app_version: 0.86,
    shirt_size: "2XL",
  },
  {
    key: 34,
    id: 34,
    guid: "f50685bd-2234-4dcb-8884-73bb037a860d",
    first_name: "Jody",
    last_name: "Seadon",
    buzzword: "monitoring",
    gender: "Genderqueer",
    email: "jseadonx@desdev.cn",
    company_name: "Kozey and Sons",
    ip_address: "50.174.18.226",
    department: "Business Development",
    job_title: "Marketing Manager",
    currency: "Ruble",
    credit_card_number: 30413081741075,
    currency_code: "RUB",
    domain_name: "spiegel.de",
    app_name: "Veribet",
    app_version: "0.4.9",
    shirt_size: "XS",
  },
  {
    key: 35,
    id: 35,
    guid: "b9d609b5-ee46-4a2f-a58d-e9706aef220e",
    first_name: "Winn",
    last_name: "Bernlin",
    buzzword: "stable",
    gender: "Male",
    email: "wbernliny@nbcnews.com",
    company_name: "Nolan, Langworth and Paucek",
    ip_address: "89.122.188.120",
    department: "Business Development",
    job_title: "Assistant Media Planner",
    currency: "Pula",
    credit_card_number: 3538602620385516,
    currency_code: "BWP",
    domain_name: "livejournal.com",
    app_name: "Sonair",
    app_version: 0.56,
    shirt_size: "L",
  },
  {
    key: 36,
    id: 36,
    guid: "178f1c48-d532-464c-9325-98011a2b34c8",
    first_name: "Osbourn",
    last_name: "Prando",
    buzzword: "Re-engineered",
    gender: "Polygender",
    email: "oprandoz@lulu.com",
    company_name: "Green, Hamill and Steuber",
    ip_address: "13.167.81.202",
    department: "Marketing",
    job_title: "Account Executive",
    currency: "Franc",
    credit_card_number: 3569402240310578,
    currency_code: "XAF",
    domain_name: "t-online.de",
    app_name: "Andalax",
    app_version: 0.91,
    shirt_size: "S",
  },
  {
    key: 37,
    id: 37,
    guid: "ccafefc3-82c9-4bee-a325-a25dddbff6e8",
    first_name: "Luca",
    last_name: "Ritchman",
    buzzword: "installation",
    gender: "Non-binary",
    email: "lritchman10@amazon.co.jp",
    company_name: "Fahey, Bosco and Rowe",
    ip_address: "231.101.73.115",
    department: "Legal",
    job_title: "Accountant III",
    currency: "Euro",
    credit_card_number: 5517569330137653,
    currency_code: "EUR",
    domain_name: "narod.ru",
    app_name: "Biodex",
    app_version: 0.56,
    shirt_size: "3XL",
  },
  {
    key: 38,
    id: 38,
    guid: "c6716f88-d911-46de-a083-2f1843f54996",
    first_name: "Sylvester",
    last_name: "Skeech",
    buzzword: "Assimilated",
    gender: "Female",
    email: "sskeech11@weather.com",
    company_name: "Stiedemann-Brakus",
    ip_address: "3.80.16.49",
    department: "Research and Development",
    job_title: "Financial Analyst",
    currency: "Koruna",
    credit_card_number: 4175008962570028,
    currency_code: "CZK",
    domain_name: "hp.com",
    app_name: "Voyatouch",
    app_version: 0.34,
    shirt_size: "S",
  },
  {
    key: 39,
    id: 39,
    guid: "6ffe8638-f8f5-430e-83f6-b0a40caf80ba",
    first_name: "Farr",
    last_name: "Backhurst",
    buzzword: "toolset",
    gender: "Male",
    email: "fbackhurst12@jalbum.net",
    company_name: "Mitchell-Gulgowski",
    ip_address: "237.32.2.206",
    department: "Accounting",
    job_title: "Social Worker",
    currency: "Lilangeni",
    credit_card_number: 30590264425152,
    currency_code: "SZL",
    domain_name: "unc.edu",
    app_name: "Daltfresh",
    app_version: 1.6,
    shirt_size: "L",
  },
  {
    key: 40,
    id: 40,
    guid: "9177391d-adc9-4b2e-8d9a-d5b1f53c6a71",
    first_name: "Ingra",
    last_name: "Toping",
    buzzword: "tangible",
    gender: "Polygender",
    email: "itoping13@mapy.cz",
    company_name: "Haley, Legros and Lesch",
    ip_address: "46.56.84.173",
    department: "Sales",
    job_title: "Nuclear Power Engineer",
    currency: "Ruble",
    credit_card_number: 374283216285783,
    currency_code: "RUB",
    domain_name: "photobucket.com",
    app_name: "Keylex",
    app_version: "8.7.4",
    shirt_size: "3XL",
  },
  {
    key: 41,
    id: 41,
    guid: "d3fcb17c-a8a6-4d8f-b71a-50c289e2ebba",
    first_name: "Bonnibelle",
    last_name: "Seyers",
    buzzword: "hybrid",
    gender: "Male",
    email: "bseyers14@scribd.com",
    company_name: "Farrell, Treutel and Tremblay",
    ip_address: "171.223.82.115",
    department: "Training",
    job_title: "Account Coordinator",
    currency: "Euro",
    credit_card_number: 4038429292425609,
    currency_code: "EUR",
    domain_name: "state.gov",
    app_name: "Stringtough",
    app_version: 0.97,
    shirt_size: "2XL",
  },
  {
    key: 42,
    id: 42,
    guid: "1c5b4dd8-a5a4-4d34-8edf-d0739b982cc9",
    first_name: "Elna",
    last_name: "Giacoppoli",
    buzzword: "5th generation",
    gender: "Agender",
    email: "egiacoppoli15@elpais.com",
    company_name: "Hintz and Sons",
    ip_address: "95.245.208.117",
    department: "Product Management",
    job_title: "Nurse",
    currency: "Dong",
    credit_card_number: 6331100342027708,
    currency_code: "VND",
    domain_name: "wunderground.com",
    app_name: "Bitchip",
    app_version: 0.32,
    shirt_size: "L",
  },
  {
    key: 43,
    id: 43,
    guid: "cd14d14c-3fb6-4d70-a174-174066c2d388",
    first_name: "Blaine",
    last_name: "Inman",
    buzzword: "capability",
    gender: "Female",
    email: "binman16@ycombinator.com",
    company_name: "Hilll-Raynor",
    ip_address: "38.223.109.122",
    department: "Business Development",
    job_title: "Senior Cost Accountant",
    currency: "Escudo",
    credit_card_number: 30039670018243,
    currency_code: "CVE",
    domain_name: "wired.com",
    app_name: "Tin",
    app_version: 0.99,
    shirt_size: "XL",
  },
  {
    key: 44,
    id: 44,
    guid: "057ddf29-2eea-48df-9794-90246da1a1eb",
    first_name: "Mychal",
    last_name: "Geertz",
    buzzword: "systematic",
    gender: "Non-binary",
    email: "mgeertz17@who.int",
    company_name: "Robel, Abshire and Veum",
    ip_address: "72.173.0.86",
    department: "Business Development",
    job_title: "Senior Developer",
    currency: "Koruna",
    credit_card_number: 5010122602384546,
    currency_code: "CZK",
    domain_name: "instagram.com",
    app_name: "Fix San",
    app_version: 1.78,
    shirt_size: "3XL",
  },
  {
    key: 45,
    id: 45,
    guid: "be59dbfe-55f8-4c39-9381-9fb6fb9f8152",
    first_name: "Olly",
    last_name: "Gilffillan",
    buzzword: "orchestration",
    gender: "Male",
    email: "ogilffillan18@squarespace.com",
    company_name: "Jenkins, Gibson and Lynch",
    ip_address: "47.1.250.209",
    department: "Training",
    job_title: "Clinical Specialist",
    currency: "Rupiah",
    credit_card_number: 337941264901173,
    currency_code: "IDR",
    domain_name: "deviantart.com",
    app_name: "Keylex",
    app_version: 5.3,
    shirt_size: "M",
  },
  {
    key: 46,
    id: 46,
    guid: "e8ba4e85-6776-4a89-b8a4-f2439fa9e9ea",
    first_name: "Berti",
    last_name: "Steutly",
    buzzword: "fresh-thinking",
    gender: "Male",
    email: "bsteutly19@naver.com",
    company_name: "Bednar Inc",
    ip_address: "193.150.237.223",
    department: "Legal",
    job_title: "Product Engineer",
    currency: "Euro",
    credit_card_number: 5293232320770922,
    currency_code: "EUR",
    domain_name: "istockphoto.com",
    app_name: "Zathin",
    app_version: "5.4.6",
    shirt_size: "M",
  },
  {
    key: 47,
    id: 47,
    guid: "517d833c-c56a-419b-b012-1e10a5743310",
    first_name: "Cyndy",
    last_name: "Clemson",
    buzzword: "explicit",
    gender: "Female",
    email: "cclemson1a@google.com.hk",
    company_name: "Hilll and Sons",
    ip_address: "40.77.128.245",
    department: "Services",
    job_title: "Civil Engineer",
    currency: "Yuan Renminbi",
    credit_card_number: 5602259183616658,
    currency_code: "CNY",
    domain_name: "sphinn.com",
    app_name: "Tampflex",
    app_version: "0.8.1",
    shirt_size: "3XL",
  },
  {
    key: 48,
    id: 48,
    guid: "b8941c58-61c5-4608-b04c-5cbb11c05558",
    first_name: "Eward",
    last_name: "Pennazzi",
    buzzword: "model",
    gender: "Agender",
    email: "epennazzi1b@youku.com",
    company_name: "Koss-Breitenberg",
    ip_address: "196.225.230.97",
    department: "Accounting",
    job_title: "Pharmacist",
    currency: "Yuan Renminbi",
    credit_card_number: 6398254797354313,
    currency_code: "CNY",
    domain_name: "amazonaws.com",
    app_name: "Zamit",
    app_version: 2.82,
    shirt_size: "3XL",
  },
  {
    key: 49,
    id: 49,
    guid: "5c5044fb-8498-4e49-9c7b-c06565e4fd3c",
    first_name: "Gerardo",
    last_name: "Elphick",
    buzzword: "circuit",
    gender: "Genderfluid",
    email: "gelphick1c@taobao.com",
    company_name: "Kertzmann, Donnelly and Carroll",
    ip_address: "119.102.121.127",
    department: "Support",
    job_title: "VP Product Management",
    currency: "Afghani",
    credit_card_number: 3556363213587821,
    currency_code: "AFN",
    domain_name: "tamu.edu",
    app_name: "Prodder",
    app_version: 6.13,
    shirt_size: "XL",
  },
  {
    key: 50,
    id: 50,
    guid: "ab8d3fcb-5840-4d56-8cb7-83bc7641fd78",
    first_name: "Janice",
    last_name: "Stutard",
    buzzword: "capability",
    gender: "Polygender",
    email: "jstutard1d@chicagotribune.com",
    company_name: "Heaney-Dickens",
    ip_address: "167.124.3.146",
    department: "Engineering",
    job_title: "Account Representative I",
    currency: "Peso",
    credit_card_number: 3574877885978479,
    currency_code: "PHP",
    domain_name: "ibm.com",
    app_name: "Konklux",
    app_version: 5.6,
    shirt_size: "M",
  },
  {
    key: 51,
    id: 51,
    guid: "ae52fdb0-1586-47cf-963b-5cd42667d53c",
    first_name: "Gabriella",
    last_name: "Blay",
    buzzword: "interface",
    gender: "Agender",
    email: "gblay1e@dailymail.co.uk",
    company_name: "Reichert, Miller and Barrows",
    ip_address: "149.176.71.147",
    department: "Support",
    job_title: "General Manager",
    currency: "Zloty",
    credit_card_number: 3579744098367046,
    currency_code: "PLN",
    domain_name: "prlog.org",
    app_name: "Flowdesk",
    app_version: "2.7.9",
    shirt_size: "M",
  },
  {
    key: 52,
    id: 52,
    guid: "d94a7f6f-c7a5-4675-908a-272e0da0bcd8",
    first_name: "Cherida",
    last_name: "Gunton",
    buzzword: "knowledge base",
    gender: "Bigender",
    email: "cgunton1f@google.com",
    company_name: "Ziemann Group",
    ip_address: "174.81.1.231",
    department: "Support",
    job_title: "Senior Financial Analyst",
    currency: "Euro",
    credit_card_number: 5038382027891901000,
    currency_code: "EUR",
    domain_name: "indiatimes.com",
    app_name: "Duobam",
    app_version: "5.1.9",
    shirt_size: "S",
  },
  {
    key: 53,
    id: 53,
    guid: "8bc1d29c-85b4-4de9-a95d-fda8f4b7da93",
    first_name: "Michaelina",
    last_name: "Cruise",
    buzzword: "hybrid",
    gender: "Bigender",
    email: "mcruise1g@eepurl.com",
    company_name: "Murray-Vandervort",
    ip_address: "79.80.122.1",
    department: "Human Resources",
    job_title: "Dental Hygienist",
    currency: "Rupiah",
    credit_card_number: 30008326875496,
    currency_code: "IDR",
    domain_name: "aol.com",
    app_name: "Temp",
    app_version: "3.2.2",
    shirt_size: "XS",
  },
  {
    key: 54,
    id: 54,
    guid: "ec7aedd5-3d23-43e4-9631-22d41635fe14",
    first_name: "Martainn",
    last_name: "Morrell",
    buzzword: "Horizontal",
    gender: "Male",
    email: "mmorrell1h@behance.net",
    company_name: "Turcotte-Maggio",
    ip_address: "133.216.35.117",
    department: "Services",
    job_title: "Staff Accountant III",
    currency: "Yuan Renminbi",
    credit_card_number: 3546960858916992,
    currency_code: "CNY",
    domain_name: "ezinearticles.com",
    app_name: "Prodder",
    app_version: 4.3,
    shirt_size: "XS",
  },
  {
    key: 55,
    id: 55,
    guid: "55ebf77a-066b-4e62-a3d0-ce31e1fa0b1f",
    first_name: "Aarika",
    last_name: "Grishunin",
    buzzword: "3rd generation",
    gender: "Bigender",
    email: "agrishunin1i@photobucket.com",
    company_name: "Klocko and Sons",
    ip_address: "180.188.76.41",
    department: "Services",
    job_title: "Data Coordiator",
    currency: "Krona",
    credit_card_number: 3539169643886218,
    currency_code: "SEK",
    domain_name: "51.la",
    app_name: "Vagram",
    app_version: "0.6.8",
    shirt_size: "3XL",
  },
];

export const getTableSource = (extraProps = "") => `<Table
  \tcolumnData={${columnDataToString()}}
    currentPageNumber={1}
    defaultPageSize={10}
    handlePageChange={function noRefCheck() {}}
    onRowClick={function noRefCheck() {}}
    onRowSelect={function noRefCheck() {}}
    rowData={[
      // rowData is limited to just 1 item to favour readability
      {
        app_name: 'Sub-Ex',
        app_version: '7.0.9',
        buzzword: 'artificial intelligence',
        company_name: 'Schuppe-Beier',
        credit_card_number: 3551746792304987,
        currency: 'Ruble',
        currency_code: 'RUB',
        department: 'Training',
        domain_name: 'freewebs.com',
        email: 'brealy0@who.int',
        first_name: 'Brennen',
        gender: 'Male',
        guid: 'cd75b6a6-54fa-4a0f-8fe9-5b62a461a2d0',
        id: 1,
        ip_address: '144.32.99.33',
        job_title: 'Internal Auditor',
        key: 1,
        last_name: 'Realy',
        shirt_size: '3XL'
      }
    ]}
    ${extraProps.trim()}
  />
`;

export const TABLE_IN_LAYOUT = `
<div className="flex">
  <MenuBar
    title={<div className="flex justify-between"><Typography style="h2">Contacts</Typography></div>}
  >
    <Block
      active
      count={13}
      label="All"
    />
    <Block
      count={2}
      label="Users"
    />
    <Block
      count={7}
      label="Leads"
    />
    <Block
      count={4}
      label="Visitors"
    />
    <SubTitle
      iconProps={[
        {
          icon: () => {},
          onClick: function noRefCheck() {}
        }
      ]}
    >
      <Typography
        component="h4"
        style="h5"
        textTransform="uppercase"
        weight="bold"
      >
        Segments
      </Typography>
    </SubTitle>
    <Search
      collapse
      onCollapse={function noRefCheck() {}}
    />
    <Block
      count={80}
      label="Europe"
    />
    <Block
      count={60}
      label="Middle-East"
    />
    <Block
      count={60}
      label="Asia"
    />
    <AddNew label="Add New Segments" />
    <SubTitle
      iconProps={[
        {
          icon: function noRefCheck() {}
        },
        {
          icon: function noRefCheck() {}
        },
        {
          icon: function noRefCheck() {}
        }
      ]}
    >
      <Typography
        component="h4"
        style="h5"
        textTransform="uppercase"
        weight="bold"
      >
        Tags
      </Typography>
    </SubTitle>
    <Block
      count={80}
      label="Europe"
    />
    <Block
      count={60}
      label="Middle-East"
    />
    <Block
      count={60}
      label="Asia"
    />
    <AddNew label="Add New Tag" />
    <Item
      description="Welcome Message, KB and Labels "
      label="General"
    />
    <Item
      active
      description="Brand Color, Logo and Widget Position"
      label="Styling"
    />
    <Item
      description="Position, Icon and Label"
      label="Widget Icon"
    />
  </MenuBar>
  <Container>
    <Header
      actionBlock={<Button label="Primary Action" />}
      menuBarToggle={function noRefCheck() {}}
      title={<div className="flex items-center"><h3>Layout</h3></div>}
    />
    <SubHeader
      deleteButtonProps={{
        count: 0,
        onClick: function noRefCheck() {},
        selectedIDs: []
      }}
      disableButtonProps={{
        count: 0,
        onClick: function noRefCheck() {},
        selectedIDs: []
      }}
      searchProps={{
        onChange: function noRefCheck() {},
        value: ''
      }}
    />
    <Scrollable className="w-full">
      ${getTableSource()}</Scrollable>
  </Container>
</div>
`;

export const FORMIK_SELECT = `
<>
  <Formik
    initialValues={{
      selects: [
        { formikSelect: { value: "v1", label: "v1" } },
        { formikSelect: { value: "v1", label: "v1" } },
      ],
    }}
    onSubmit={(values) => setValues(values)}
  >
    {({ values }) => (
      <Form>
        <div className="flex flex-col space-y-6">
          <FieldArray name="selects">
            {({ push, remove }) => (
              <div className="flex flex-col space-y-3">
                {values.selects.map((_, index) => (
                  <div key={index} className="flex items-end space-x-6">
                    <FormikSelect
                      name={\`selects.\${index}.formikSelect\`}
                      label="Select"
                      options={[
                        { value: "v1", label: "v1" },
                        { value: "v2", label: "v2" },
                        { value: "v3", label: "v3" },
                      ]}
                    />
                    <Button
                      label="Remove"
                      className="mb-2"
                      onClick={() => remove(index)}
                    />
                  </div>
                ))}
                <Button
                  className="self-start"
                  label="Add"
                  onClick={() => push({ formikSelect: null })}
                />
              </div>
            )}
          </FieldArray>
          <Button className="self-start" label="Submit" type="submit" />
        </div>
      </Form>
    )}
  </Formik>
  <div className="py-6">
    <Typography weight="bold">Selected Values:</Typography>
    {values.selects?.map(({ formikSelect }, index) => (
      <Typography key={index}>{formikSelect?.label}</Typography>
    ))}
  </div>
</>;
`;

export const STORYBOOK_NAV_LINKS = [
  {
    label: "Components",
    description: "Description here",
    to: "/components",
    icon: Copy,
  },
  {
    label: "Form Elements",
    description: "Description here",
    to: "/form-elements",
    icon: Design,
  },
  {
    label: "Formik",
    description: "Description here",
    to: "/formik",
    icon: Image,
  },
  {
    label: "Overlays",
    description: "Description here",
    to: "/overlays",
    icon: Settings,
  },
  {
    label: "Layouts",
    description: "Description here",
    to: "/layouts",
    icon: UserCircle,
  },
];

export const DATE_PICKER_CODE = `
<DatePicker
  label="Date range"
  type="range"
  defaultValue={[dayjs(), dayjs().add(7, "day")]}
/>`;

export const DATE_RANGE_PICKER_CODE = `
<DatePicker
  label="Date range"
  type="range"
  defaultValue={[dayjs(), dayjs().add(7, "day")]}
  ranges={{
    Today: [dayjs(), dayjs()],
    Yesterday: [dayjs().subtract(1, "d"), dayjs()],
    "Last Week": [dayjs().subtract(7, "d"), dayjs()],
    "This Month": [dayjs().startOf("month"), dayjs().endOf("month")],
    "Last Month": [
      dayjs().subtract(1, "month").startOf("month"),
      dayjs().subtract(1, "month").endOf("month"),
    ],
    "This Year": [dayjs().startOf("year"), dayjs().endOf("year")],
  }}
/>`;
