import { connect, createDataItemSigner } from "@permaweb/aoconnect";

const AppVersion = "1.0.0";
export const AOModule = "1PdCJiXhNafpJbvC-sjxWTeNzbf9Q_RfUNs84GYoPm0";
export const AOScheduler = "_GQ33BkPtZrqxA84vM8Zk-N2aO0toNNu_C-l-rawrBA";

const CommonTags = [
    { name: "App-Name", value: "LearnAO" },
    { name: "App-Version", value: AppVersion },
];

type Tags = { name: string, value: string }[];

export async function spawnProcess(name?: string, tags?: Tags) {
    const ao = connect();

    if (tags) {
        tags = [...CommonTags, ...tags];
    } else {
        tags = CommonTags;
    }
    tags = name ? [...tags, { name: "Name", value: name }] : tags;

    const result = await ao.spawn({
        module: AOModule,
        scheduler: AOScheduler,
        tags,
        signer: createDataItemSigner(window.othentWallet),
    });

    return result;
}

export async function runLua(code: string, process: string, tags?: Tags) {
    const ao = connect();

    if (tags) {
        tags = [...CommonTags, ...tags];
    } else {
        tags = CommonTags;
    }

    tags = [...tags, { name: "Action", value: "Eval" }];

    const message = await ao.message({
        process,
        data: code,
        signer: createDataItemSigner(window.othentWallet),
        tags,
    });

    const result = await ao.result({ process, message });
    // console.log(result);
    return result;
}

export async function getResults(process: string, cursor = "") {
    const ao = connect();

    const r = await ao.results({
        process,
        from: cursor,
        sort: "ASC",
        limit: 50,
    });

    if (r.edges.length > 0) {
        const newCursor = r.edges[r.edges.length - 1].cursor;
        const results = r.edges.map((e: any) => e.node);
        return { cursor: newCursor, results };
    } else {
        return { cursor, results: [] };
    }
}