# Learn AO with BetterIDEa

This is a platform for learning AO, it consists of a series of interactive exercises to help you learn AO.

## Adding more exercises

To add more exercises, you need to create a new file in `src/data` folder with the filename `<number>.<name>.ts`

The ts file should contain a default export object of type `TExerciseData`

and its endpoint route must be added to the object in `data/index.ts`

<details>
<summary>TExerciseData</summary>

```ts
export interface TExerciseData {
  route: string;
  nextRoute: string;
  prevRoute: string;
  title: string;
  content: string;
  defaultCode: string;
  expectedResult: string | TExpectedResult;
  runLua?: boolean;
  allowNext?: boolean;
  fromId?: "SELF" | string;
  validateTimestamp?: boolean;
}
```

</details>

| Field             | Description                                                                                                                          | Type                      | Required | Example Values                                                                                   |
| ----------------- | ------------------------------------------------------------------------------------------------------------------------------------ | ------------------------- | -------- | ------------------------------------------------------------------------------------------------ |
| prevRoute         | endpoint for the previous exercise (value must exist in the data/index.ts file)                                                      | string                    | true     | "10-connect-wallet"                                                                              |
| route             | endpoint for the current exercise (value must exist in the data/index.ts file)                                                       | string                    | true     | "20-create-wallet"                                                                               |
| nextRoute         | endpoint for the next exercise (value must exist in the data/index.ts file)                                                          | string                    | true     | "30-create-asset"                                                                                |
| title             | title of the exercise                                                                                                                | string                    | true     | "Create a wallet"                                                                                |
| content           | markdown supported description of the exercise                                                                                       | string                    | true     | "# Markdown"                                                                                     |
| defaultCode       | default boilerplate code for the exercise                                                                                            | string                    | true     | "print('Hello World')"                                                                           |
| expectedResult\*  | expected result of the exercise (either a string or an object)                                                                       | string or TExpectedResult | true     | "Hello World" or `{ run:"print('Hello World')", "Hello World" }` or `{run:"Inbox[#Inbox].Data"}` |
| runLua            | boolean to decide wether to check output by running some lua code (must always be true if expectedResult is of type TExpectedResult) | boolean                   | false    | true                                                                                             |
| allowNext         | boolean that allows moving to the next exercise by default                                                                           | boolean                   | false    | true                                                                                             |
| fromId            | In case we are checking if we have received an Inbox message from a particular process (SELF if we are sending it to ao.id)          | "SELF" or string          | false    | "<process if>" or "SELF"                                                                         |
| validateTimestamp | To check if an Inbox message was received after running the exercise code (compares timestamps)                                      | boolean                   | false    | true                                                                                             |

\*expectedResult can be a string or an object

<details>
<summary>TExpectedResult</summary>

```ts
type TExpectedResult =
  | string
  | {
      run: string;
      out?: string;
    };
```

</details>

| Field | Description                                                                                                                                                                      | Type   | Required | Example Values          |
| ----- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------ | -------- | ----------------------- |
| run   | lua code to run to get the expected result                                                                                                                                       | string | true     | "print('Hello World!')" |
| out   | If declared, will check if the output of the run field is equal to this value, else will compare the lua output with the output of the code the user has written in the exercise | string | optional | "Hello World!"          |

After creating an object you need to add it to the `data/index.ts` file

<details>
<summary>Your exercise file</summary>

```ts
import { TExerciseData } from "@/types";

export default {
  prevRoute:...,
  route:...,
  nextRoute:...,
  .
  .
  .
} as TExerciseData;
```

</details>

<details>
<summary>data/index.ts</summary>

```ts
import { TExerciseData } from "@/types";

export default {
  "10-connect-wallet": require("@/data/10.connect-wallet").default,
  "20-spawn-process": require("@/data/20.spawn-process").default,
  "30-hello-ao": require("@/data/30.hello-ao").default,
  .
  .
  .
  "<your-route>": require("@/data/<your-exercise-file").default,
} as { [foo: string]: TExerciseData };
```

**IMPORTANT NOTES:**

1. Make sure the route in your exercise file and the key in the data/index.ts file are the same.
2. Make sure the prevRoute, route, and nextRoute in your exercise file exist in the keys of the index files exported object.
3. Make sure the route in your exercise file is unique.
4. The exercises are spaced by 10s, so there is a possibility to add more exercises between the existing ones if needed (All hail QBASIC programming) Make sure you follow the same pattern.
