export default function PrivacyPolicy() {
    return (
        <div className="space-y-12 text-md md:text-lg text-muted-foreground pb-4 md:pb-8">
            <p>Effective Date: Wed 6 Sep 2023</p>
            <p>
                At Modifio, we are committed to safeguarding your privacy. This Privacy Policy outlines our practices
                regarding the collection, use, and disclosure of personal information when you use our website and
                services. Please read this policy carefully to understand how we handle your data.
            </p>
            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">1. Information We Collect</h2>
                <p>
                    We collect and use limited information to improve the user experience. The only data we collect is
                    through Google Analytics, which includes: Usage Information: We may collect information about your
                    interaction with our website, such as the pages you visit, your IP address, browser type, device
                    type, and referral URLs. This information helps us understand how users interact with our website to
                    enhance its functionality and content.
                </p>
            </div>

            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">
                    2. How We Use Your Information
                </h2>
                <p>
                    We use the information collected through Google Analytics solely for the purpose of understanding
                    user behavior and improving our website's performance. We do not sell, rent, or share this
                    information with third parties.
                </p>
            </div>

            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">
                    3. Cookies and Tracking Technologies
                </h2>
                <p>
                    We use cookies and similar tracking technologies to collect and store information about your
                    interactions with our website. You can control cookie preferences through your browser settings.
                    Please note that disabling cookies may affect your experience on our website.
                </p>
            </div>

            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">4. Data Security</h2>
                <p>
                    We take reasonable measures to protect your data against unauthorized access, disclosure,
                    alteration, or destruction. However, please be aware that no method of data transmission over the
                    internet or electronic storage is 100% secure.
                </p>
            </div>

            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">5. Third-Party Links</h2>
                <p>
                    Our website may contain links to third-party websites or services that are not operated by us. We
                    have no control over the content, privacy policies, or practices of these third-party websites. We
                    encourage you to review the privacy policies of these websites before providing any personal
                    information.
                </p>
            </div>

            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">6. Children's Privacy</h2>
                <p>
                    Our website is not intended for children under the age of 13. We do not knowingly collect personal
                    information from children. If you are a parent or guardian and believe that your child has provided
                    us with personal information, please contact us, and we will take appropriate action to remove that
                    information.
                </p>
            </div>

            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">
                    7. Changes to This Privacy Policy
                </h2>
                <p>
                    We reserve the right to update or modify this Privacy Policy at any time without prior notice. Any
                    changes will be effective immediately upon posting on this page, and the date of the latest revision
                    will be indicated at the top of the policy.
                </p>
            </div>

            <div className="space-y-2">
                <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">8. Contact Us</h2>
                <p>
                    If you have any questions or concerns about this Privacy Policy or the data we collect, please
                    contact us at souhailbenlhachemi1999@gmail.com.
                </p>
            </div>

            <p>
                By using Modifio, you agree to the practices outlined in this Privacy Policy. Please discontinue use of
                our services if you do not agree with this policy. Thank you for trusting us with your privacy.
            </p>
        </div>
    );
}
