export default function About() {
  return (
      <div className="space-y-12 text-md md:text-lg text-muted-foreground pb-4 md:pb-8">
          <p>
              Introducing Modifio, the ultimate multimedia conversion powerhouse that empowers you to transform images,
              audio files, and videos with unprecedented freedom, all at absolutely no cost! Say goodbye to limitations
              and hello to limitless creative possibilities.
          </p>
          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">🖼️ Image Conversion:</h2>
              <p>
                  Unleash your creativity with our image conversion tool. Whether you need to resize, crop, rotate, or
                  convert formats, we've got you covered. From JPEG to PNG, and everything in between, effortlessly
                  enhance your visual content.
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">🎵 Audio Transformation:</h2>
              <p>
                  Turn up the volume on your audio projects! With our audio conversion capabilities, you can convert
                  audio files between various formats like MP3, WAV, or AAC. Adjust bitrates, trim, and merge audio
                  files to create your perfect soundtrack.
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">🎥 Video Metamorphosis:</h2>
              <p>
                  Lights, camera, action! Edit and transcode videos without limits. From changing video formats to
                  cutting and merging clips, you can create stunning video content for any platform or purpose.
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">
                  🚀 Unlimited Usage, No Strings Attached:
              </h2>
              <p>
                  Unlike other services, we believe in empowering your creativity without hidden fees or restrictions.
                  You can convert as many images, audio files, and videos as your heart desires, and it won't cost you a
                  dime.
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">🌐 Accessible Anywhere:</h2>
              <p>
                  Access Modifio from any device with an internet connection. Whether you're on your computer, tablet,
                  or smartphone, you can use our platform with ease.
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">🔒 Secure and Private:</h2>
              <p>
                  Rest easy knowing that your multimedia files are treated with the utmost care. We prioritize your
                  privacy and data security, ensuring that your files remain yours alone.
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">💡 User-Friendly Interface:</h2>
              <p>
                  Our intuitive interface is designed for both beginners and experts, making the conversion process a
                  breeze. No technical expertise required!
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">📈 Constantly Evolving:</h2>
              <p>
                  We're committed to staying ahead of the curve. Expect regular updates and new features to keep your
                  multimedia experience fresh and exciting.
              </p>
          </div>

          <div className="space-y-2">
              <h2 className="text-xl md:text-2xl font-medium text-muted-foreground">
                  🌟 It's Free, It's Powerful, It's Modifio:
              </h2>
              <p>
                  Experience the freedom to convert images, audio, and video without boundaries. Elevate your multimedia
                  projects with the unlimited potential of Modifio.
              </p>
          </div>

          <p>
              Join the revolution of content creators, professionals, and enthusiasts who are transforming the way they
              work with multimedia. Get started today and let your creativity shine like never before!
          </p>
      </div>
  );
}
