﻿# page

На уровне переопределения `touch.blocks` блок предоставляет шаблоны, создающие дополнительный набор HTML-элементов внутри `head`.

## Обзор

### Специализированные поля блока

| Поле | Тип | Описание |
| ---- | --- | -------- |
| <a href="#elems-meta-declfields-zoom">zoom</a> | `{Boolean}` | Наличие масштабирования. |

### Элементы блока

| Элемент | Способы использования | Описание |
| ------- | --------------------- | -------- |
| <a href="#elems-icon">icon</a> | `BEMJSON` | Позволяет задать ссылку на значки Web Clips, для отображения на рабочем столе iOS при добавлении ссылки на сайт. |

### Специализированные поля элементов блока

| Элемент | Поле | Тип | Описание |
| ------- | ---- | --- | -------- |
| <a href="#elems-icon">icon</a> | <a href="#elems-icon-declfields-src">src{X}</a> | `{String}` | Используются для указания пути к файлу значка. |

### Публичные технологии блока

Блок реализован в технологиях:

* `bh.js`
* `bemhtml`

## Подробности

Блок создает HTML-элементы:

* `<meta>` с атрибутом `name` в значении `'format-detection'`. Значением `content` служит `'telephone=no'`. Элемент отключает автоматическое распознавание телефонных номеров в html-коде и их набор по нажатию.
* `<link>` с атрибутом `name` в значении `'apple-mobile-web-app-capable'`. Значением `content` служит `'yes'`. Элемент задает для страницы полноэкранный режим отображения на устройствах с iOS.
* `<meta>` с атрибутом `name` в значении `'viewport'`. Элемент позволяет управлять масштабированием страницы. По умолчанию, масштабирование отключено. Для включения используйте специализированное поле `zoom` со значением `true`.

Кроме того, к элементу <body> с классом `page` подмешивается блок [ua](https://github.com/bem/bem-core/blob/v2/desktop.blocks/ua/ua.ru.md).

<a name="declfields"></a>
### Специализированные поля блока

<a name="declfields-zoom"></a>
##### Специализированное поле `zoom`

Тип: `{Boolean}`.

Управляет масштабированием страницы. Определяет значение атрибута `content` HTML-элемент `<meta>` с атрибутом `name` в значении `'viewport'`:

* со значением `true` – `'initial-scale=1'`. Масштабирование включено. Масштаб по умолчанию устанавливается равным 100%.
* без значения или `false` – `'maximum-scale=1,initial-scale=1,user-scalable=no'`. Масштаб по умолчанию устанавливается равным 100%. Масштабирование отключено.

```js
{
    block : 'page',
    title : 'Hello, World!',
    zoom : true,
    content : 'Включение масштабирования страницы'
}
```


<a name="elems"></a>
### Элементы блока

<a name="elems-icon"></a>
#### Элемент `icon` 

Позволяет задать ссылку на значки Web Clips, для отображения на рабочем столе iOS при добавлении ссылки на сайт. Ссылка задается через специализированное поле `src{X}`.

<a name="elems-icon-declfields-src"></a>
##### Специализированное поле `src{X}`

Тип: `String`.

Поле вида `src{X}` используются для указания пути к файлу значка. В зависимости от значения `{X}` элемент `icon` преобразуется в HTML-элемент:

* `src16` – `<link>` c атрибутом `rel` со значением `'shortcut icon'`. 
* `src57` – `<link>` c атрибутами: 
    * `sizes` со значением `'57x57'`;
    * `rel` со значением `'apple-touch-icon-precomposed'`. 
* `src72` – `<link>` c атрибутами: 
    * `sizes` со значением `'72x72'`;
    * `rel` со значением `'apple-touch-icon-precomposed'`. 
* `src114` – `<link>` c атрибутом `rel` со значением `'apple-touch-icon-precomposed'`. 

```js
{
    block : 'page',
    title : 'Page title',
    head : { elem : 'icon', src72 : 'example.png' },
    content : 'Страница с подключенным значком'
}
```
