# i-bem.js: руководство пользователя

## i-bem.js: JavaScript-фреймворк для БЭМ

`i-bem.js` — специализированный JavaScript-фреймворк для веб-разработки в рамках [БЭМ-методологии](https://ru.bem.info/methodology/).

`i-bem.js` позволяет:

* разрабатывать веб-интерфейс в терминах блоков, элементов, модификаторов;
* описывать логику работы блока в декларативном стиле — как набор состояний;
* легко интегрировать JavaScript-код с BEMHTML- или BH-шаблонами и CSS в стиле БЭМ;
* гибко переопределять поведение библиотечных блоков.

`i-bem.js` не предназначен для замены фреймворка общего назначения, подобного jQuery.

**Краткий обзор содержания документа**:

* [Общие сведения](./i-bem-js-common.ru.md) о фреймворке: связь с предметной областью БЭМ, краткое описание модульной структуры фреймворка, шаблонного проекта и инструментов для сборки кода, написанного с использованием `i-bem.js`.
* [Привязка JS-экземпляров к HTML](./i-bem-js-html-binding.ru.md) — разметка JS-блоков в HTML-коде страницы, варианты соотношения HTML-элементов и JS-экземпляров.
* [Декларация](./i-bem-js-decl.ru.md) — синтаксис описания класса блока и элемента.
* [Передача параметров](./i-bem-js-params.ru.md) — передача параметров экземпляру блока и элемента, получение доступа к параметрам из экземпляра.
* [Работа с DOM-деревом](./i-bem-js-dom.ru.md) — API для работы с DOM-узлами блоков и элементов.
* [Состояния](./i-bem-js-states.ru.md) — модификаторы, триггеры на изменение модификаторов.
* [Коллекции](./i-bem-js-collections.ru.md) — работа с несколькими экземплярами блоков или элементов.
* [События](./i-bem-js-events.ru.md) — событийная модель `i-bem.js`: DOM- и БЭМ-события.
* [Инициализация](./i-bem-js-init.ru.md) — инициализация экземпляров блоков и элементов.
* [Взаимодействие блоков](./i-bem-js-interact.ru.md) — обращение из экземпляра блока или элемента к другим экземплярам и классам.
* [Контекст](./i-bem-js-context.ru.md) —  собственные и статические свойства блока и элемента. Статические свойства `i-bem-dom`.
* [Что дальше?](./i-bem-js-extras.ru.md) — ссылки на документацию и дополнительные материалы.
