## Взаимодействие блоков и элементов

В рамках БЭМ-методологии блоки и элементы следует разрабатывать так, чтобы свести к минимуму зависимость состояний одних сущностей от других. Однако на практике идеал полной независимости блоков недостижим.

Взаимодействие блоков и элементов может быть реализовано:

* с помощью подписки на [БЭМ-события](./i-bem-js-events.ru.md#БЭМ-события);
* с помощью непосредственного вызова методов других экземпляров или статических методов класса;
* через проверку [состояний](./i-bem-js-states.ru.md) одного экземпляра из другого.

> **Примечание** Не используйте [DOM-события](./i-bem-js-events.ru.md#dom-события) для организации взаимодействия между экземплярами. DOM-события следует использовать только во взаимодействиях экземпляра со своим DOM-узлом.

Для реализации взаимодействия блоков или элементов `i-bem.js` предоставляет API:

* [Поиск экземпляров в DOM-дереве](./i-bem-js-dom.ru.md#Поиск-экземпляров-блоков-и-элементов-в-dom-дереве).
* [Доступ к экземплярам без DOM-представления](./i-bem-js-html-binding.ru.md#Блоки-без-dom-представления).
* [Доступ к классам блоков и элементов](#Доступ-к-классам-блоков-и-элементов).

### Доступ к классам блоков и элементов

Классы блоков и элементов, можно получить через [модульную систему ym](https://github.com/ymaps/modules). Это же верно и для блоков и элементов [без DOM-представления](./i-bem-js-html-binding.ru.md#Блоки-без-dom-представления).

Доступ к классам блоков и элементов необходим для:

* [Доопределения](./i-bem-js-decl.ru.md#Доопределение-блока-или-элемента) декларации блока и [наследования](./i-bem-js-decl.ru.md#Наследование).
* [Поиска](./i-bem-js-dom.ru.md#Поиск-экземпляров-блоков-и-элементов-в-dom-дереве) их экземпляров в DOM-дереве.
* [Для работы с событиями в контексте класса](./i-bem-js-events.ru.md).
* Вызова статических методов класса.

**Пример**

Блок `button` наследуется от базового блока `control`:

```js
modules.define('button', ['i-bem-dom', 'control'], function(provide, bemDom, Control) {

provide(bemDom.declBlock(this.name, Control, {}));

});
```
