## Привязка JS-блоков к HTML

JavaScript-компоненты в `i-bem.js` служат для «оживления» HTML-элементов страницы. Типовая задача JS-блока — установка реакции на события внутри HTML-фрагмента.

В `i-bem.js` первичным «каркасом» является HTML-дерево документа. В нем размечаются точки, к которым привязаны интерактивные элементы интерфейса — JS-блоки. Точка привязки JS-блока — HTML-элемент (DOM-узел), в атрибуте `class` которого указано имя блока, а в атрибуте `data-bem` — [параметры блока](./i-bem-js-params.ru.md#Передача-параметров-экземпляру-блока-и-элемента).

При загрузке страницы в браузере выполняется [инициализация блоков](./i-bem-js-init.ru.md#Инициализация). В ходе нее создаются экземпляры блоков — JS-объекты всех блоков, упомянутых в классах HTML-элементов страницы. JS-объект, привязанный к HTML-элементу, обрабатывает происходящие на нем [DOM-события](./i-bem-js-events.ru.md#dom-события) и хранит состояния данного экземпляра блока.

Такой способ привязки JavaScript-компонентов к HTML имеет следующие преимущества:

* естественная деградация интерфейса на клиентах с отключенным JavaScript;
* прогрессивный рендеринг — возможность начинать отрисовку элементов интерфейса до окончания загрузки всех данных страницы (например, изображений).

> **Примечание** Начиная с версии `bem-core@v4.0.0` всё описанное ниже для блоков так же справедливо для элементов.

### Механизм привязки блоков

Чтобы привязать блок к HTML-элементу (например, `<div>...</div>`), необходимо:

* **Декларировать блок в `i-bem`**.

Cоздать модуль [ym](https://github.com/ymaps/modules), содержащий JS-реализацию блока ([декларацию](./i-bem-js-decl.ru.md#Декларация-блоков-и-элементов)). Для этого строка с именем блока передается первым аргументом методам `modules.define` и `bemDom.declBlock`.

```js
modules.define('my-block', ['i-bem-dom'], function(provide, bemDom){

provide(bemDom.declBlock(this.name,
    {
        /* методы экземпляра */
    },
    {
        /* статические методы */
    }
));

});
```

На уровне проекта каждый модуль `ym` обычно хранится как отдельный файл технологии `js`. Например, декларация `my-block` в проекте может храниться как `my-block/my-block.js` – файл `my-block.js`, вложенный в папку `my-block`.

* **Отметить блок в HTML-дереве**.

  Добавить HTML-элементу атрибут `class` с именем блока.

  ```html
   <div class="my-block">...</div>
  ```

* **Разрешить инициализацию экземпляра блока**.

  Включить класс `i-bem` в список классов HTML-элемента. Наличие этого класса укажет фреймворку, что HTML-элемент связан с JS-блоком.

  ```html
  <div class="my-block i-bem">...</div>
  ```

* **Передать параметры экземпляру блока**.

  Поместить параметры блока в атрибут `data-bem`. Параметры блока записываются в формате JSON и представляют собой хеш вида: `имя блока : хэш параметров`. Параметры будут переданы экземпляру блока [в момент инициализации](./i-bem-js-init.ru.md#Инициализация).

  ```html
  <div class="my-block i-bem" data-bem='{ "my-block": { "name": "ya" } }'>...</div>
  ```

### Связь блоков с HTML-элементами

Одному HTML-элементу не обязательно должен соответствовать один экземпляр блока. Возможны следующие типы связи между блоками и HTML-элементами:

* [Один HTML-элемент — один JS-блок](#Один-html-элемент--один-js-блок)
* [Один HTML-элемент — несколько JS-блоков](#Один-html-элемент--несколько-js-блоков)
* [Один JS-блок на нескольких HTML-элементах](#Один-js-блок-на-нескольких-html-элементах)

#### Один HTML-элемент — один JS-блок

Самый простой и распространенный способ привязки блоков к HTML.

**Пример**

HTML-элемент `div`, на котором размещен блок `my-block`. Параметры блока: пустой список `{}`.

```html
<div class="my-block i-bem" data-bem='{ "my-block": {} }'>
    ...
</div>
```

#### Один HTML-элемент — несколько JS-блоков

Техника размещения нескольких блоков на одном HTML-элементе в БЭМ-методологии называется [микс](./i-bem-js-decl.ru.md#Миксины).

**Пример**

HTML-элемент `div`, на котором размещены:

* блок `user` с параметром `name`: `pushkin`;
* блок `avatar` с параметром `img`: `http://...`.

```html
<div class="user avatar i-bem"
    data-bem='{
        "user": { "name": "pushkin" },
        "avatar": { "img": "http://..." }
     }'>
     ...
</div>
```

#### Один JS-блок на нескольких HTML-элементах

Такой дизайн удобен, если нужно согласовать состояния нескольких компонентов блока.

Чтобы привязать экземпляр блока к нескольким HTML-элементам, нужно указать им в атрибуте `data-bem` одинаковое значение параметра `id`. Значением `id` может быть произвольная строка.

**Пример**

Экземпляр блока `notebook` привязан к HTML-элементам `div` и `span`. В параметрах блока указан общий `id` — `maintab`.

```html
<div class="notebook i-bem" data-bem='{ "notebook": { "id": "maintab" }}'>
</div>
...
<span class="notebook i-bem" data-bem='{ "notebook": { "id": "maintab" }}'>
</span>
```

В результате при инициализации блоков создается один JS-объект, поле [domElem](./i-bem-js-dom.ru.md#Работа-с-dom-деревом) которого содержит ссылки на jQuery-объекты обоих DOM-узлов.

Например, виджет «вкладка», где клик по заголовку вкладки (первый HTML-элемент), меняет ее содержимое (второй HTML-элемент).

Другой пример: маркер, обозначающий точку на карте (первый элемент), и связанное с ним описание точки в списке рядом (второй элемент).

Идентификатор `id` используется *только в момент инициализации* экземпляра блока. Значение `id` должно быть уникальным для экземпляров одного блока в рамках одной [волны инициализации](./i-bem-js-init.ru.md#Волны-инициализации).

### Блоки без DOM-представления

Инфраструктурный код, решающий общие задачи интерфейса (связь с бэкэндом, вспомогательные методы), можно оформить в виде блока. Это позволит выражать состояния блока с помощью [модификаторов](./i-bem-js-states.ru.md#Модификаторы), на изменение которых смогут [подписаться другие блоки](./i-bem-js-states.ru.md#Триггеры-на-установку-модификаторов).

Чтобы не привязывать такие блоки к HTML-дереву искусственно в `i-bem.js` можно создавать блоки без DOM-представления.

Блоки без DOM-представления:

* не требуют привязки к HTML-коду страницы;
* должны быть явно [инициализированы](./i-bem-js-init.ru.md#Инициализация-и-удаление-блоков-без-dom-представления) и уничтожены.

#### Доступ к экземплярам блоков без DOM-представления

При создании экземпляра блока без DOM-представления необходимо позаботиться о сохранении ссылки на этот экземпляр для блоков, которым нужно с ним взаимодействовать.
