## Контекст

**Методы экземпляра** исполняются в контексте JS-объекта экземпляра блока и элемента. Ключевое слово `this` в методах экземпляра блока ссылается на JS-объект **экземпляра**.

**Статические методы** исполняются в контексте JS-объекта, соответствующего классу блока или элемента. Ключевое слово `this` в статических методах блока ссылается на **класс**.

> **Примечание** При разработке с использованием `i-bem.js` внутренним методам блока и элемента, не предназначенным для использования извне, принято давать имена, начинающиеся с символа подчеркивания. Например, `_onClick`.

### Свойства и методы экземпляра блока и элемента

#### С DOM-представлением

* `params` – [хеш параметров](./i-bem-js-params.ru.md), соответсвующий параметрам заданных в HTML-экземпляра.
* `domElem` – объект jQuery, содержащий ссылки на DOM-элементы, к которым [привязан](./i-bem-js-html-binding.ru.md#Привязка-js-блоков-к-html) экземпляр.

#### Без DOM-представления

* `params` – хеш параметров, переданных экземпляру при инициализации.

#### Вспомогательные свойства

Экземпляр предоставляет набор вспомогательных свойств:

* `__self` – для доступа к статическим свойствам и методам из экземпляра.

**Пример**

Вызов статического метода `staticMethod()` в методе `_onEvent()` экземпляра блока `my-block`.

```js
bemDom.declBlock('my-block', {
    _onEvent : function() {
        this.__self.staticMethod(); // вызов статического метода
        this.doMore();
    }
}, {
    staticMethod : function() { /* ... */ } // определение статического метода
});
```

* `__base` – для вызова реализации одноименного метода из базового класса, от которого [наследуется](./i-bem-js-decl.ru.md#Наследование) данный («super call»).

**Пример**

Вызов базовой реализации метода `_onClick` базового класса `button`.

```js
modules.define('my-button', ['i-bem-dom', 'button'], function(provide, bemDom, Button) {

provide(bemDom.declBlock(this.name, Button, {
    _onClick : function() {
        this.__base(); // вызываем базовый _onClick
        this.doMore();
    }
}));

});
```

Вспомогательные свойства предоставляются модулем [inherit](../../common.blocks/inherit/inherit.ru.md), реализующим механизм наследования в `bem-core`.

#### Вспомогательные методы

* `_nextTick(fn)` — производит асинхронный вызов функции `fn` `{Function}`, в следующем витке событийного цикла. Функция `fn` вызывается в контексте текущего экземпляра, при условии, что он ещё существует.

**Пример**

Подписываемся на событие `pointerclick` на документе в следующем витке событийного цикла, чтобы попап не закрывался (по клику во вне) до того, как обработается клик на нём.

```js
modules.define('popup', ['i-bem-dom'], function(provide, bemDom) {

provide(bemDom.decl(this.name, {
    onSetMod : {
        'visible' : {
            'true' : function() {
                this._nextTick(function() {
                    this._domEvents(bemDom.doc).on('pointerclick', this._onDocPointerClick);
                });
            }
        }
    },

    _onDocPointerClick : function() {
        // ...
        this.delMod('visible');
    }
}));

});
```

### Статические свойства блока и элемента

#### Вспомогательные свойства

В декларации статических методов доступны вспомогательные свойства:

* `__base` – для вызова реализации одноименного метода из базового класса, от которого наследуется данный («super call»).

```js
modules.define('my-button', ['i-bem-dom', 'button'], function(provide, bemDom, Button) {

provide(bemDom.declBlock(this.name, Button,
    { /* ... */ },
    {
        staticMethod: function() {
            this.__base();
            this.doMore();
        }
    }
));

});
```

### Статические свойства модуля `i-bem-dom`

* `scope` – корневой элемент обрабатываемого DOM-дерева. Позволяет выполнять несколько разных версий `i-bem.js` в одном рантайме. По умолчанию содержит ссылку на jQuery объект `body`;
* `doc` – ссылка на jQuery объект `document`;
* `win` – ссылка на jQuery объект `window`.
