# bem-core library [![Build Status](https://travis-ci.org/bem/bem-core.svg?branch=v2)](https://travis-ci.org/bem/bem-core) [![GitHub Release](https://img.shields.io/github/release/bem/bem-core.svg)](https://github.com/bem/bem-core/releases) [![devDependency Status](https://david-dm.org/bem/bem-core/dev-status.svg)](https://david-dm.org/bem/bem-core#info=devDependencies)

Documentation on `bem-core` in a much more informative way is also available at [bem.info](https://en.bem.info/libs/bem-core/). It is also available [in Russian](https://ru.bem.info/libs/bem-core/).

## What is this?

`bem-core` is a base library for web interface development.
It provides the minimal stack for coding client-side JavaScript and templating.

## Use

The easiest way to run a project with `bem-core` is to use
the [project-stub](https://github.com/bem/project-stub).

You can use any other way you are familiar with to include the library into
the project.

## Inside

### Levels

  - `common.blocks` — suited for any devices and browsers
  - `desktop.blocks` — should be used for desktop browsers
  - `touch.blocks` — implement some touch-platforms specifics

### Blocks

  - `i-bem` — base block with helpers for JS and HTML
  - `strings` — helpers for JS-strings
  - `objects` — helpers for JS-objects
  - `functions` — helpers for JS-functions
  - `events` — JS-events
  - `querystring` — helpers for work with querystring
  - `tick` — global timer
  - `idle` — IDLE event
  - `next-tick` — polyfill for `nextTick`/`setTimeout(0, ...)`
  - `inherit` — OOP helpers
  - `jquery` — jQuery
  - `clearfix` — CSS clearfix trick
  - `identify` — identify JS-objects
  - `cookie` — helpers for work with browser cookies
  - `vow` — Promises/A+ implementation
  - `dom` — helpers for work with DOM
  - `loader` — loader for JS files
  - `ua` — browser features detection
  - `keyboard` — keyboard helpers
  - `page` — html/head/body scaffold

### Technologies

  - vanilla.js + browser.js
  - bemhtml
  - bemtree

## API

The autogenerated JSDoc API can be found on bem.info. E.g. JSDoc for `i-bem` is here https://en.bem.info/platform/libs/bem-core/current/desktop/i-bem/#jsdoc

## Changelog

You can check the changelog at the [Changelog](https://bem.info/libs/bem-core/changelog/) page.

## Migration

If you used BEM before, check the [migration instructions](https://bem.info/libs/bem-core/migration/).

## Development

### Working copy

1. Get the needed version code (e.g., `v4`):
   ```shell
   $ git clone -b v4 git://github.com/bem/bem-core.git
   $ cd bem-core
   ```

2. Install the dependencies:
   ```shell
   $ npm install
   ```

   You need `export PATH=./node_modules/.bin:$PATH`
   or an alternative way to run locally-installed `npm` dependencies.

3. Install all necessary libraries:
   ```shell
   $ npm run deps
   ```

4. Build and run tests (specs):
   ```shell
   $ npm test
   ```

5. Run development server:
   ```shell
   $ npm start
   ```

### How to contribute

Please refer to [How to contribute](/CONTRIBUTING.md) guide.

### Modular testing

A default test bundle for `functions__debounce`:
```shell
$ magic make desktop.specs/functions__debounce
```

You can see the results of the tests in the terminal after the building process finishes.

You can also watch them in a browser loading `desktop.specs/functions__debounce/spec-js+browser-js+bemhtml/spec-js+browser-js+bemhtml.html`.

Run tests for other BEM entities in the same way. This will work for those which are equipped with `.spec.js` file.

### Code coverage

To build code coverage report add `ISTANBUL_COVERAGE=yes` environment variable to the tests run command:
```shell
$ ISTANBUL_COVERAGE=yes magic make desktop.specs && istanbul report html
```

You can run modular testing with coverage as well by using more concrete build target as was described above.
```
$ ISTANBUL_COVERAGE=yes magic make desktop.specs/functions__debounce && istanbul report html
```

After tests finish, you can view coverage HTML report by opening `coverage/index.html` in your favorite
browser.

The whole code coverage statistics can be found on the [bem-core profile page](https://coveralls.io/r/bem/bem-core) on
[Coveralls](https://coveralls.io).

Tests are built with a [enb-bem-specs](https://github.com/enb-bem/enb-bem-specs/) library.
Check the [details](https://ru.bem.info/tools/bem/enb-bem-specs/) (available in Russian only).

## Supported browsers

Our browser support policy is based on statistics we get from [Yandex](https://company.yandex.com) services.

Browsers with more than 2% users get full compliant support, more than 0.5% — partially compliant
(which means that data is accessible but not necessary 100% functional). New features testing
is not provided by us for  browsers with less than 0.5% users.

### Desktop

#### Fully compliant

  - Google Chrome 29+
  - Firefox 24+
  - Yandex 1.7+
  - Opera 12.16
  - MSIE 10.0
  - MSIE 9.0
  - MSIE 8.0
  - Opera 12.15

#### Partially compliant

  - Opera 17.0
  - Opera 16.0
  - Opera 12.14
  - Opera 12.2
  - Firefox 23

### Touch

#### Fully compliant

  - iOS 6+
  - Android 2.3+
  - Opera Mobile 12+
  - Windows Phone 7+

#### Partially compliant

  - iOS 5
  - Android 2.2

## License
Code and documentation copyright 2012 YANDEX LLC. Code released under the [Mozilla Public License 2.0](LICENSE.txt).
