# tick

Блок предоставляет объект для работы с регулярно генерируемым событием `tick` (для реализации паттерна polling).

## Обзор

### События объекта

| Имя | Описание |
| -------- | -------- |
| <a href="#events-tick">tick</a> | Регулярно генерируемое событие. |

### Свойства и методы объекта

| Имя | Тп возвращаемого значения | Описание |
| -------- | --- | -------- |
| <a href="#fields-start">start</a>() | - | Запускает генерацию события `tick`, если она еще не запущена. |
| <a href="#fields-stop">stop</a>() | - | Останавливает генерацию события `tick`, если она еще не остановлена. |

### Модификаторы блока

| Модификатор | Допустимые значения | Способы использования | Описание |
| ----------- | ------------------- | --------------------- | -------- |
| <a href="#modifiers-start">start</a> | `'auto'` | `JS` | Автоматический запуск генерации события |

### Публичные технологии блока

Блок реализован в технологиях:

* `vanilla.js`

## Описание

<a name="events"></a>

### События объекта

<a name="events-tick"></a>

#### Событие `tick`

Подписавшись на событие, можно использовать его для реализации паттерна polling.

Событие генерируется с интервалом в 50 миллисекунд.

<a name="fields"></a>

### Свойства и методы объекта

Блок наследуется от клсаса `Emitter` блока `events`, что позволяет вызывать методы класса.

```js
modules.require('tick', function(tick) {

var update = function() { /* ... */ };

tick
    .on('tick', update) // подписываемся на событие tick
    .start(); // запускаем генерацию события tick
});
```

<a name="fields-start"></a>

#### Метод `start`

Запускает генерацию события [tick](#fields-tick), если они еще не запущены. Событие `tick` генерируется через интервал в 50 миллисекунд после вызова метода.

Не принимает аргументов.

Не имеет возвращаемого значения.

<a name="fields-stop"></a>

#### Метод `stop`

Останавливает генерацию события [tick](#fields-tick).

Не принимает аргументов.

Не имеет возвращаемого значения.

<a name="modifiers"></a>

### Модификаторы блока

<a name="modifiers-start"></a>

#### Модификатор `start`

Допустимые значения: `'auto'`.

Способ использования: `JS`.

Блок с модификатором `start` в значении `auto` используется для автоматического запуска генерации события [tick](#fields-tick). Событие начинает генерироваться в момент инициализации блока.
