# objects

Блок предоставляет объект, содержащий набор методов для работы с объектами JavaScript.

## Обзор

### Свойства и методы объекта

| Имя | Тип возвращаемого значения | Описание |
| -------- | --- | -------- |
| <a href="#fields-extend">extend</a>(<br>`target {Object}`, <br>`source {Object}`) | `Object` | Расширяет объект свойствами другого объекта. |
| <a href="#fields-isEmpty">isEmpty</a>(`obj {Object}`) | `Boolean` |  Позволяет выяснить пуст ли переданный объект. |
| <a href="#fields-each">each</a>(<br>`obj {Object}`, <br>`fn {Function}`, <br>`[ctx {Object}]`) | - | Итеративно обходит собственные свойства объекта. |

### Публичные технологии блока

Блок реализован в технологиях:

* `vanilla.js`

## Описание

<a name="fields"></a>

### Свойства и методы объекта

<a name="fields-extend"></a>

#### Метод `extend`

Расширяет объект свойствами другого объекта. Копируются только собственные свойства, не полученные по цепочке прототипов.

**Принимаемые аргументы:**

* `target {Object}` – целевой объект. Обязательный аргумент.
* `source {Object}` – объект, свойства которого добавляются к целевому. Может быть передано несколько объектов. Свойства каждого из них будут добавлены к целевому. Обязательный аргумент.

**Возвращаемое значение:** `Object`. Целевой объект с добавленными свойствами.

Пример:

```js
modules.require(['objects'], function(objects) {

var obj1 = { a : 1, b : 2 },
    obj2 = { b : 3, c : 4 };

console.log(objects.extend(obj1, obj2)); // { a : 1, b : 3, c : 4 }
});
```

<a name="fields-isEmpty"></a>

#### Метод `isEmpty`

Позволяет выяснить пуст ли переданный объект. Другими словами, имеет ли объект собственные свойства.

**Принимаемые аргументы:**

* `obj {Object}` – объект для проверки. Обязательный аргумент.

**Возвращаемое значение:** `Boolean`. В случае, если объект не имеет собственных свойств – `true`.

Пример:

```js
modules.require(['objects'], function(objects) {

var obj1 = {},
    obj2 = { foo : 'bar' };

console.log(objects.isEmpty(obj1)); // true
console.log(objects.isEmpty(obj2)); // false
});
```

<a name="fields-each"></a>

#### Метод `each`

Служит для итерации по собственным свойствам объекта. Для каждого собственного свойства вызывается функция-обработчик.

**Принимаемые аргументы:**

* `obj {Object}` – объект, обход свойств которого производится. Обязательный аргумент.
* `fn {Function}` – функция-обработчик, вызываемая для каждого свойства. Обязательный аргумент.
* [`ctx {Object}`] – контекст обработчика.

Не имеет возвращаемого значения.

Функция-обработчик получает в качестве аргументов значение и ключ свойства объекта, для которого была вызвана.

Пример:

```js
modules.require(['objects'], function(objects) {
    objects.each(
        { a : 1, b : 2 },
        function(val, key) {
            console.log(key, val);
        });
    // a 1
    // b 2
});
```
