# loader

Блок `loader` служит для загрузки и подключения скриптов по URL.

## Обзор

### Модификаторы блока

| Модификатор | Допустимые значения | Способы использования | Описание |
| ----------- | ------------------- | --------------------- | -------- |
| <a href="#modifiers-type">type</a> | `'js'`, `'bundle'` | `JS` | Позволяет по URL получить и подключить JS-код или бандл. |

### Функции, подключаемые модификаторами блока

| Модификатор | Функция | Возвращаемое значение | Описание |
| ----------- | --- | ----------------------------- | -------- |
| <a href="#modifiers-type-js">js</a> | loader(</br>`id {String}`,</br> `url {String}`,</br> `[success {Function}]`,</br> `[error {Function}]`) | - | Загружает и подключает фрагмент JavaScript-кода. |
| <a href="#modifiers-type-bundle">bundle</a> | loader(</br>`url {String}`,</br> `success {Function}`,</br> `[error {Function}]`) | - | Загружает и подключает пакет, собранный из CSS и JS-файлов – «бандл». |

### Публичные технологии блока

Блок реализован в технологиях:

* `js`

## Описание

<a name="modifiers"></a>

### Модификаторы блока

<a name="modifiers-type"></a>

#### Модификатор `type`

Предоставляет набор функций для загрузки и подключение различных типов данных.

Допустимые значения: `'js'`, `'bundle'`.

Способ использования: `JS`.

В зависимости от значения модификатора `type` блок `loader` позволяет получить по URL и подключить:

* `js` – фрагмент JS-кода.
* `bundle` – пакет, собранный из CSS и JS-файлов – «бандл».

<a name="modifiers-type-js"></a>

##### Модификатор `type` в значении `js`

Предоставляет функцию, позволяющую загрузить и подключить фрагмент JS-кода.

**Принимаемые аргументы:**

* `url {String}` – URL загружаемого фрагмента JS-кода. Обязательный аргумент.
* [`success {Function}`] – callback-функция, выполняемая по завершению загрузки кода.
* [`error {Function}`] – callback-функция, выполняемая при ошибке в ходе загрузки кода.

Не имеет возвращаемого значения.

Например, `loader_type_js` может использоваться для загрузки и подключения jQuery:

```js
modules.define('jquery', ['loader_type_js'], function(provide, loader) {

    loader(
        'https://yastatic.net/jquery/2.2.0/jquery.min.js',
        function() { provide(jQuery) });

});
```

Расширенный пример смотрите в блоке [common.blocks/jquery](https://github.com/bem/bem-core/blob/v2/common.blocks/jquery/jquery.js) библиотеки `bem-core`.

<a name="modifiers-type-bundle"></a>

##### Модификатор `type` в значении `bundle`

Предоставляет функцию, позволяющую загрузить и подключить пакет, собранный из CSS и JS-файлов – «бандл».

**Принимаемые аргументы:**

* `id {String}` – идентификатор бандла. Обязательный аргумент.
* `url {String}` – путь до файла бандла в формате URL. Обязательный аргумент.
* `onSuccess {Function}` – callback, вызываемая по завершению загрузки бандла. Обязательный аргумент.
* [`onError {Function}`] – callback, вызываемая при неудачной загрузке бандла.

Не имеет возвращаемого значения.

Спецификации технологии `bundle` находятся в процессе разработки. Для получения детальной информации пишите на [форум](https://ru.bem.info/forum/).

###### Статический метод `_loaded`

Функция, подключаемая с модификатором `type_bundle`, обладает статическим методом – `_loaded`. Он используется как вспомогательный после успешной загрузки бандла.

**Принимаемые аргументы:**

* `id {String}` – идентификатор бандла. Обязательный аргумент.

Не имеет возвращаемого значения.
