# idle

Блок предоставляет объект, содержащий набор методов для генерации события в момент прекращения пользовательской активности (т.е. пользователь работает с другим окном или не совершает действий).

## Обзор

### События объекта

Доступен следующий набор событий:

| Имя | Описание |
| -------- | -------- |
| <a href="#events-idle">idle</a> | Браузер простаивает. |
| <a href="#events-wakeup">wakeup</a> | Пользователь возобновил активность. |

### Свойства и методы объекта

| Имя | Возвращаемое значение | Описание |
| -------- | --- | -------- |
| <a href="#fields-start">start</a>() | - | Запуск отслеживания пользовательской активности. |
| <a href="#fields-stop">stop</a>() | - | Остановка отслеживания пользовательской активности. |
| <a href="#fields-isIdle">isIdle</a>() | `Boolean` | Проверка текущего состояния. |

### Модификаторы блока

| Модификатор | Допустимые значения | Способы использования | Описание |
| ----------- | ------------------- | --------------------- | -------- |
| <a href="#modifiers-start">start</a> | `auto` | `JS` | Автоматический запуск отслеживания пользовательской активности. |

### Публичные технологии блока

Блок реализован в технологиях:

* `js`

## Описание

Подписавшись на события блока можно приостанавливать выполнение операций, например, отображение анимации, при отсутствии пользовательской активности.

Блок наследуется от класса `Emitter` блока `events`, что позволяет вызывать его методы.

```js
modules.require(['idle'], function(idle) {

idle
    .on({
        idle : function() {
            // обработчик события idle
        },
        wakeup : function() {
            // обработчик события wakeup
        }
    })
    .start(); // запуск генерации событий

});
```

<a name="events"></a>

### События объекта

<a name="events-idle"></a>

#### Событие `idle`

Генерируется при прекращении пользовательской активности.

<a name="events-wakeup"></a>

#### Событие `wakeup`

Генерируется в момент возобновления пользовательской активности.

<a name="fields"></a>

### Свойства и методы объекта

<a name="fields-start"></a>

#### Метод `start`

Запуск отслеживания пользовательской активности.

Не принимает аргументов.

Не имеет возвращаемого значения.

```js
modules.require(['idle'], function(idle) {

idle.start()

});
```

<a name="fields-stop"></a>

#### Метод `stop`

Служит для прекращения отслеживания пользовательской активности.

Не принимает аргументов.

Не имеет возвращаемого значения.

```js
modules.require(['idle'], function(idle) {

idle.start() // начинаем отслеживать активность
idle.stop() // прекращаем отслеживать активность

});
```

<a name="fields-isIdle"></a>

#### Метод `isIdle`

Служит для проверки наличия пользовательской активности.

Не принимает аргументов.

**Возвращаемое значение:** `Boolean`. В случае если активность отсутствует – `true`.

```js
modules.require(['idle'], function(idle) {

idle.isIdle() // true или false, в зависимости от текущего состояния

});
```

<a name="modifiers"></a>

### Модификаторы блока

<a name="modifiers-start"></a>

#### Модификатор `start`

Допустимые значения: `'auto'`.

Способ использования: подключается в файле зависимостей `deps.js`.

Автоматический запуск отслеживания пользовательской активности.
