# identify

Блок предоставляет функцию для работы с уникальными идентификаторами, которая позволяет:

* создавать идентификаторы объектов;
* проверять у объектов наличие идентификатора;
* создавать уникальную строку-идентификатор.

**Принимаемые аргументы:**

* [`obj {Object}`] – идентифицируемый объект.
* [`onlyGet {Boolean}`] – флаг для проверки наличия у объекта идентификатора. Если `true`, функция будет возвращать строку с идентификатором только если объект был заранее идентифицирован. По умолчанию `false`.

**Возвращаемое значение:** `String`. Строка с идентификатором, присвоенным объекту. При последующих вызовах всегда будет возвращаться один и тот же идентификатор.

Пример:

```js
modules.require(['identify'], function(identify) {
    var a = {},
        b = {},
        identA = identify(a);

    console.log(identA === identify(a)); // true
    console.log(identA === identify(b)); // false
});
```

При вызове без аргументов, функция будет каждый раз возвращать строку с уникальным идентификатором.

Пример:

```js
modules.require(['identify'], function(identify) {
    var a = identify(),
        b = identify();

    console.log(a === b); // false
});
```

## Публичные технологии блока

Блок реализован в технологиях:

* `vanilla.js`
