# i18n

Блок предоставляет функцию для интернационализации проекта.
Может быть использован в браузере и в node.js-окружении.

## Сигнатура

```js
/**
 * @exports
 * @param {String} keyset
 * @param {String} key
 * @param {Object} [params]
 * @returns {String}
 */
i18n(keyset, key, params);
```

Например:

```js
i18n('keyset1', 'key2', { a : '1' });
```

Для добавления переводов используется метод `decl`:

```js
i18n.decl({
    keyset1 : {
        key1 : 'keyset1 key1 string',
        key2 : function(params) {
            return 'keyset1 key2 function ' + JSON.stringify(params);
        },
        key3 : function(params) {
            return 'keyset1 key3 ' + this('keyset1', 'key2', params);
        }
    }
});
```

Документацию на сборку проекта с интернационализацией см. в пакете для сборки [enb-bem-i18n](https://ru.bem.info/tools/bem/enb-bem-i18n/readme/).
