# i18n

This block provides a function for project internationalization.
It can be used in a browser and in a node.js environment.

## Signature

```js
/**
 * @exports
 * @param {String} keyset
 * @param {String} key
 * @param {Object} [params]
 * @returns {String}
 */
i18n(keyset, key, params);
```

For example:

```js
i18n('keyset1', 'key2', { a : '1' });
```

Use the `decl` method to add translations:

```js
i18n.decl({
    keyset1 : {
        key1 : 'keyset1 key1 string',
        key2 : function(params) {
            return 'keyset1 key2 function ' + JSON.stringify(params);
        },
        key3 : function(params) {
            return 'keyset1 key3 ' + this('keyset1', 'key2', params);
        }
    }
});
```

For information about building an internationalized project, see  [enb-bem-i18n](https://ru.bem.info/tools/bem/enb-bem-i18n/readme/).
