# functions

Блок предоставляет объект, содержащий набор методов для работы с функциями JavaScript.

## Обзор

### Свойства и методы объекта

| Имя | Тип или возвращаемое значение | Описание |
| -------- | --- | -------- |
| <a href="#fields-isFunction">isFunction</a>(`obj {*}`) |  `Boolean` | Проверяет, является ли переданный аргумент функцией. |
| <a href="#fields-noop">noop</a> | `Function` | Пустая функция. |

### Элементы блока

| Элемент |  Способы использования | Описание |
| --------| ---- | -------- |
| <a href="#elems-debounce">debounce</a> | `JS`  | Декоратор функции. Объединяет несколько вызовов функции, производимых в заданном временном интервале, в один. |
| <a href="#elems-throttle">throttle</a> | `JS` | Декоратор функции. Ограничивает частоту выполнения функции до одного раза в указанный период. |

### Публичные технологии блока

Блок реализован в технологиях:

* `vanilla.js`

## Описание

<a name="fields"></a>

### Свойства и методы объекта

<a name="fields-isFunction"></a>

#### Метод `isFunction`

Метод проверяет, является ли переданный аргумент функцией.  

**Принимаемые аргументы:**

* `obj {*}` – проверяемый объект. Обязательный аргумент.

**Возвращаемое значение:** `Boolean`. В случае, если аргумент является функцией – `true`.

```js
modules.require('functions', function(func) {
    var a = function(){},
        b = {};
    console.log(func.isFunction(a)); // true
    console.log(func.isFunction(b)); // false
});
```

<a name="fields-noop"></a>

#### Свойство `noop`

Пустая функция (`function() {}`).

Не имеет аргументов и возвращаемого значения.

`noop` можно использовать в ситуациях, когда для работы требуется функция, но нет смысла добавлять логику. Например в качестве «заглушки» для базовых классов при проектировании в парадигме ООП.

Пример:

```js
modules.define('base-class', ['inherit', 'functions'], function(provide, inherit, functions) {

provide(inherit({
    getData : function() {
        this._sendRequest();
    },

    _sendRequest : functions.noop

}));

});
```

<a name="elems"></a>

### Элементы блока

Элементы блока реализуют набор декораторов функций.

Декораторы добавляют функции логику, не меняя ее оригинальной сигнатуры.

<a name="elems-debounce"></a>

#### Элемент `debounce`

Декоратор, откладывающий вызовов функции до истечения задержки. После каждой попытки вызова задержка начинает отсчитываться заново.

**Принимаемые аргументы:**

* `fn {Function}` — оригинальная функция. Обязательный аргумент.
* `timeout {Number}` — время задержки в миллисекундах. Обязательный аргумент.
* [`invokeAsap {Boolean}`] — режим работы `debounce`. По умолчанию используется первый режим (соответствует значению `false`).
* [`context {Object}`] — контекст для выполнения оригинальной функции.

В зависимости от значения аргумента `invokeAsap` `debounce` может работать в двух режимах:

1. Вызов оригинальной функции производится по истечению задержки после последней попытки вызова.
2. Первый вызов оригинальной функции производится сразу же при вызове декорированной функции. Дальнейшее поведение аналогично режиму 1.

**Возвращаемое значение:** `Function`. Декорированная функция.

Пример:

```js
modules.require('functions__debounce', function(provide, debounce) {

    function log() {
        console.log('hello!');
    }

    var debouncedLog = debounce(log, 300);
    setInterval(debouncedLog, 50);

});
```

<a name="elems-throttle"></a>

#### Элемент `throttle`

Декоратор позволяет «затормозить» функцию. Она будет выполняться не чаще одного раза в указанный период, сколько бы раз в течение этого периода ни была вызвана. Все промежуточные вызовы игнорируются.

**Принимаемые аргументы:**

* `fn {Function}` — оригинальная функция. Обязательный аргумент.
* `period {Number}` — интервал между вызовами в миллисекундах. Обязательный аргумент.
* [`context {Object}`] — контекст для выполнения оригинальной функции.

**Возвращаемое значение:** `Function`. Декорированная функция.

Метод удобно использовать, например, для установки ресурсоемких обработчиков для часто генерируемых событий – `resize`, `pointermove` и т.п.

Пример:

```js
modules.require('functions__throttle', function(provide, throttle) {

    function log() {
        console.log('hello!');
    }

    var throttledLog = throttle(log, 300);
    setInterval(throttledLog, 50);

});
```

В результате, функция будет выполняться не чаще чем раз в 300 миллисекунд.
