<a name="elems-channels"></a>

# Элемент `channels` блока `events`

Элемент `channels` блока `events` предназначен для работы с именованными каналами событий. Именные каналы позволяют организовать работу с событиями, используя шаблон проектирования «наблюдатель» (также известный как Publisher-subscriber).

Элемент реализует функцию, позволяющую:

* получить ссылку на именной канал по `id`;
* получить ссылку на стандартный канал;
* удалить канал – стандартный или по `id`.

**Принимаемые аргументы:**

* [`id {String}`] – Идентификатор канала. Если не задан будет использоваться канал по умолчанию (`'default'`).
* [`drop {Boolean}`] – Логический флаг, указывающий (в значении `true`) на необходимость удалить канал. По умолчанию `false`.

**Возвращаемое значение:**

* `Object`. Объект «класса» `Emitter` – именной канал.
* `undefined`. В случае если функция была вызвана с параметром `drop` в значении `true`.

Пример:

```js
modules.require(['events__channels'], function(channels) {

var myChannel = channels('my-channel');
myChannel.on('test', function(e, data) { console.log(data.foo) });

myChannel.emit('test', { foo : 'bar' }); // 'bar'

});
```
