﻿namespace MahApps.Metro.Controls
{
    /// <summary>
    ///     Constants that specify whether the pane is set to the left or to the right of the content in a
    ///     <see cref="SplitView" />.
    /// </summary>
    public enum SplitViewPanePlacement
    {
        /// <summary>
        ///     The pane is shown to the left of the <see cref="SplitView" /> content.
        /// </summary>
        Left = 0,

        /// <summary>
        ///     The pane is shown to the right of the <see cref="SplitView" /> content.
        /// </summary>
        Right = 1
    }
}